/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.Pick;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.GeneralTaskEditPage;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.IValidator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WFBPELCodeGen;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowEditorContext;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.XPathAction;
import oracle.tip.tools.ide.pm.modules.workflow.util.WFUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Element;

public class AdvancedTaskEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener,
DocumentListener,
IValidator {
    protected JTextField m_scopeNameField;
    protected JTextField m_globalTaskVarField;
    protected JTextField m_ownerField;
    protected JTextField m_indentificationKeyField;
    private JTextField mIdentityContext;
    private JTextField mApplicationContext;
    protected JButton m_ownerCreateBtn;
    protected JButton m_IdentificationKeyBtn;
    protected JCheckBox m_incHistory;
    protected JComboBox m_historyCB;
    protected JCheckBox m_allowCallback;
    private boolean mCallback;
    protected JRadioButton m_reInitPayload;
    protected JRadioButton m_useOldPayload;
    protected UserTask m_task;
    protected UserTaskEditorData mEditorData;
    private static final String PICK_NAME = "receiveTaskUpdates";
    public static final String REINITIATE_OPERATION = "reinitiateTask";
    protected Assign m_ownerAssign;
    protected Assign m_idKeyAssign;
    protected Copy m_ownerCPRule;
    protected Copy m_idKeyCPRule;
    protected Copy m_idContextCPRule;
    protected Copy m_AppContextCPRule;
    protected boolean m_bOrigIncHistory;
    protected boolean m_bOrigAllowCallBack;
    private WorkflowEditorContext mContext;

    @Override
    public void onSelection() {
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def != null) {
            String name = def.getName();
            String text = this.m_scopeNameField.getText();
            if (text == null || text.trim().equals("")) {
                name = BPELModelUtil.generateUniqueName((Process)this.m_graphModel.getProcess(), (String)name, Scope.class);
            }
            if (text != null && !text.trim().equals("") && !name.equals(text)) {
                name = text;
            }
            this.m_scopeNameField.setText(name);
            if (!this.m_incHistory.isSelected()) {
                this.m_globalTaskVarField.setText(name + "_globalVariable");
                this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
            }
            if (this.m_ownerField.getText().trim().equals("")) {
                String defOwner = null;
                if (def.getRoutingSlip() != null && def.getRoutingSlip().getGlobalConfiguration() != null) {
                    defOwner = def.getRoutingSlip().getGlobalConfiguration().getOwner();
                }
                if (defOwner != null) {
                    this.m_ownerField.setText(defOwner);
                }
            }
        }
    }

    public AdvancedTaskEditPage(BPELGraphPane graphPane, UserTaskEditorData pData) {
        super(graphPane);
        this.mEditorData = pData;
        this.mContext = new WorkflowEditorContext();
        this.mContext.setGraphPane(this.m_graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.loadControls();
        this.setModified(true);
    }

    private void createControls() {
        this.m_scopeNameField = new JTextField();
        this.m_scopeNameField.getDocument().addDocumentListener(this);
        this.m_globalTaskVarField = new JTextField();
        this.m_globalTaskVarField.setEnabled(false);
        this.m_ownerField = new JTextField();
        this.m_indentificationKeyField = new JTextField();
        this.m_ownerCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_ownerCreateBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_ownerCreateBtn.addActionListener(this);
        this.m_IdentificationKeyBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_IdentificationKeyBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_IdentificationKeyBtn.addActionListener(this);
        this.mIdentityContext = new JTextField();
        this.mApplicationContext = new JTextField();
        this.m_incHistory = new JCheckBox(BPELStringTranslator.getString("WF_INCLUDE_HISTORY"));
        this.m_reInitPayload = new JRadioButton(BPELStringTranslator.getString("WF_RE_INIT_PAYLOAD"));
        this.m_useOldPayload = new JRadioButton(BPELStringTranslator.getString("WF_USE_OLD_PAYLOAD"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_reInitPayload);
        group.add(this.m_useOldPayload);
        this.m_reInitPayload.addActionListener(this);
        this.m_useOldPayload.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_reInitPayload, (String)BPELStringTranslator.getString("WF_RE_INIT_PAYLOAD"));
        ResourceUtils.resButton((AbstractButton)this.m_useOldPayload, (String)BPELStringTranslator.getString("WF_USE_OLD_PAYLOAD"));
        this.m_incHistory.addActionListener(this);
        this.m_historyCB = new JComboBox();
        this.m_historyCB.addActionListener(this);
        this.m_allowCallback = new JCheckBox(BPELStringTranslator.getString("WF_ALLOW_TASK_CUSTOMIZATION"));
        ResourceUtils.resButton((AbstractButton)this.m_incHistory, (String)BPELStringTranslator.getString("WF_INCLUDE_HISTORY"));
        ResourceUtils.resButton((AbstractButton)this.m_allowCallback, (String)BPELStringTranslator.getString("WF_ALLOW_TASK_CUSTOMIZATION"));
    }

    private void layoutControls() {
        ToolBar creatorTB = new ToolBar();
        creatorTB.add((Component)this.m_ownerCreateBtn);
        ToolBar identificationKeyTB = new ToolBar();
        identificationKeyTB.add((Component)this.m_IdentificationKeyBtn);
        JLabel scopeLbl = new JLabel(BPELStringTranslator.getString("WF_SCOPE_NAME"));
        JLabel globalVarLbl = new JLabel(BPELStringTranslator.getString("WF_GLOBAL_TASK_VARIABLE_NAME"));
        JMultiLineLabel globalVarDescLbl = new JMultiLineLabel(BPELStringTranslator.getString("WF_VARIABLE_CONTAINS_ALL"));
        globalVarDescLbl.setEnabled(false);
        JMultiLineLabel identificationKeyDescLbl = new JMultiLineLabel(BPELStringTranslator.getString("WF_IDENTIFICATIONKEY_DESC"));
        identificationKeyDescLbl.setEnabled(false);
        JLabel ownerLbl = new JLabel(BPELStringTranslator.getString("WF_OWNER"));
        JLabel identificationKeyLbl = new JLabel(BPELStringTranslator.getString("WF_INENTIFICATION_KEY"));
        JLabel identityContextLbl = new JLabel();
        JLabel applicationContext = new JLabel();
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)scopeLbl, (Component)this.m_scopeNameField, (String)BPELStringTranslator.getString("WF_SCOPE_NAME"));
        ResourceUtils.resLabel((JLabel)ownerLbl, (Component)this.m_ownerField, (String)BPELStringTranslator.getString("WF_OWNER"));
        ResourceUtils.resLabel((JLabel)identificationKeyLbl, (Component)this.m_indentificationKeyField, (String)BPELStringTranslator.getString("WF_INENTIFICATION_KEY"));
        ResourceUtils.resLabel((JLabel)globalVarLbl, (Component)this.m_globalTaskVarField, (String)BPELStringTranslator.getString("WF_GLOBAL_TASK_VARIABLE_NAME"));
        ResourceUtils.resLabel((JLabel)identityContextLbl, (Component)this.mIdentityContext, (String)BPELStringTranslator.getString("IDENTITY_CONTEXT"));
        ResourceUtils.resLabel((JLabel)applicationContext, (Component)this.mApplicationContext, (String)BPELStringTranslator.getString("APPLICATION_CONTEXT"));
        JButton identityButton = new JButton(new XPathAction(this.mIdentityContext, this.mContext, true));
        UIHelper.setupButton((JButton)identityButton);
        JButton applicationRoleButton = new JButton(new XPathAction(this.mApplicationContext, this.mContext, true));
        UIHelper.setupButton((JButton)applicationRoleButton);
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)scopeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_scopeNameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)globalVarLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_globalTaskVarField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)globalVarDescLbl, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)ownerLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_ownerField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)creatorTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)identificationKeyLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_indentificationKeyField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)identificationKeyTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)identificationKeyDescLbl, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)identityContextLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mIdentityContext, (int)1, (int)row, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)identityButton, (int)3, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)applicationContext, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.mApplicationContext, (int)1, (int)row, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)applicationRoleButton, (int)3, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel histPanel = new JPanel();
        histPanel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)histPanel, (Component)this.m_incHistory, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)histPanel, (Component)this.m_historyCB, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)histPanel, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel reInitPanel = new JPanel();
        reInitPanel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)reInitPanel, (Component)this.m_reInitPayload, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)reInitPanel, (Component)this.m_useOldPayload, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)reInitPanel, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    @Override
    public void setUserObject(Object model) {
        this.m_task = (UserTask)model;
        this.mContext.setActivity((Activity)this.getUserObject());
        this.mContext.setProcess(this.m_graphModel.getProcess());
        this.mContext.setNSResolver(this.getNSResolver((Activity)this.m_task));
    }

    @Override
    public Object getUserObject() {
        return this.m_task;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("ADVANCED_TASK_EDIT_PAGE");
    }

    @Override
    public void saveChanges() {
        boolean isCallback;
        String t;
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def == null) {
            return;
        }
        String name = def.getName();
        String text = this.m_scopeNameField.getText();
        if (text == null || text.trim().equals("")) {
            name = BPELModelUtil.generateUniqueName((Process)this.m_graphModel.getProcess(), (String)name, Scope.class);
        } else if (text != null && !text.trim().equals("") && !name.equals(text)) {
            name = text;
        }
        String varName = "";
        String textVar = this.m_globalTaskVarField.getText();
        if (textVar == null || textVar.trim().length() == 0) {
            varName = name + "_globalVariable";
            this.m_globalTaskVarField.setText(varName);
        } else {
            varName = this.m_globalTaskVarField.getText();
        }
        this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
        WFBPELCodeGen u = this.mEditorData.getBPELCodeGen();
        u.setScopeName(name);
        u.setVariableName(varName);
        String taskPrefix = this.m_graphModel.getProcess().addNamespace("http://xmlns.oracle.com/bpel/workflow/task", "task");
        String taskSvcPrefix = this.m_graphModel.getProcess().addNamespace("http://xmlns.oracle.com/bpel/workflow/taskService", "taskservice");
        String wfCommonPrefix = this.m_graphModel.getProcess().addNamespace("http://xmlns.oracle.com/bpel/workflow/common", "wfcommon");
        String taskVarName = this.m_incHistory.isSelected() ? "reinitiateTaskInput" : "initiateTaskInput";
        String msgName = this.m_incHistory.isSelected() ? REINITIATE_OPERATION : "initiateTask";
        u.setTaskPrefix(taskPrefix);
        u.setTaskServicePrefix(taskSvcPrefix);
        u.setWFCommonPrefix(wfCommonPrefix);
        if (!this.m_incHistory.isSelected()) {
            Variable v = (Variable)BPELParser.createImplementation(Variable.class);
            v.setName(varName);
            v.setMessageType(new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "taskMessage", taskSvcPrefix));
            Process process = this.m_graphModel.getProcess();
            List varList = new ArrayList();
            if (process.getVariables() != null && process.getVariables().getVariables() != null) {
                varList = process.getVariables().getVariables();
            }
            boolean bAdd = true;
            for (int i = 0; i < varList.size() && bAdd; ++i) {
                Variable var = (Variable)varList.get(i);
                if (!varName.equals(var.getName())) continue;
                bAdd = false;
            }
            if (bAdd) {
                process.addVariable(v);
            }
        }
        if ((t = this.m_ownerField.getText()) != null && t.trim().length() > 0) {
            MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
            String exp = parser.convertMixedStringToXPathCompliantForm(t);
            u.addUserCopyRule(u.genOwnerCPRule(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            this.saveOwnerValue(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix);
        } else {
            this.removeOwnerValue();
        }
        String idKeyValue = this.m_indentificationKeyField.getText();
        if (idKeyValue != null && idKeyValue.trim().length() > 0) {
            MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
            String exp = parser.convertMixedStringToXPathCompliantForm(idKeyValue);
            u.addUserCopyRule(u.genIdentificationKeyCPRule(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            this.saveIdKeyValue(exp, taskVarName, taskSvcPrefix, msgName, taskPrefix);
        } else {
            this.removeIdKeyValue();
        }
        String identityContext = this.mIdentityContext.getText();
        if (identityContext != null && identityContext.trim().length() > 0) {
            u.addUserCopyRule(u.genIdentityContextCPRule(identityContext, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            this.saveIdentityContextKeyValue(identityContext, taskVarName, taskSvcPrefix, msgName, taskPrefix);
        } else {
            this.removeIdContextValue();
        }
        String appContext = this.mApplicationContext.getText();
        if (appContext != null && appContext.trim().length() > 0) {
            u.addUserCopyRule(u.genIdentityContextCPRule(appContext, taskVarName, taskSvcPrefix, msgName, taskPrefix));
            this.saveApplicationContextKeyValue(appContext, taskVarName, taskSvcPrefix, msgName, taskPrefix);
        } else {
            this.removeAppContextValue();
        }
        String patternName = "";
        boolean bl = isCallback = this.getCallback() || this.mCallback;
        if (this.m_incHistory.isSelected()) {
            u.addReinitCopyRule(varName, taskPrefix, taskVarName, msgName, taskSvcPrefix);
            patternName = isCallback ? "WFReinitiateCallBack" : "WFReinitiate";
        } else {
            patternName = isCallback ? "WFBasicCallBack" : "WFBasic";
        }
        this.mEditorData.setAllowCallbackPattern(patternName);
        if (this.m_bOrigAllowCallBack != isCallback || this.m_bOrigIncHistory != this.m_incHistory.isSelected()) {
            this.mEditorData.setGenerateData(true);
        }
    }

    private void loadControls() {
        if (this.m_task == null) {
            return;
        }
        List list = this.mEditorData.getUserTaskList();
        if (list == null || list.size() == 0) {
            list = WFUtil.findAllDefinedUserTask(this.m_task);
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                UserTask u = (UserTask)list.get(i);
                this.m_historyCB.addItem(new UserTaskItem(u));
                this.m_reInitPayload.setEnabled(false);
                this.m_useOldPayload.setEnabled(false);
            }
        } else {
            this.m_historyCB.setEnabled(false);
            this.m_incHistory.setEnabled(false);
            this.m_reInitPayload.setEnabled(false);
            this.m_useOldPayload.setEnabled(false);
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return;
        }
        this.loadReinitAndCallback();
        this.loadScopeNameAndGlobalVar();
        this.loadIdentificationKeyFromTask();
        this.loadIdentityContextFromTask();
        this.loadApplicationContextFromTask();
        actList = ((Sequence)act).getActivityList();
        boolean bSet = false;
        for (int i = 0; i < actList.size() && !bSet; ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            List cpRules = ((Assign)act).getCopyRules();
            for (int j = 0; j < cpRules.size() && !bSet; ++j) {
                Object c = cpRules.get(j);
                if (!(c instanceof Copy)) continue;
                bSet = this.loadOwner((Copy)c, (Assign)act);
            }
        }
        if (!bSet) {
            this.loadOwnerFromTask();
        }
    }

    private void saveOwnerValue(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_ownerAssign == null) {
            this.m_ownerAssign = this.getFirstAssign();
            if (this.m_ownerAssign == null) {
                return;
            }
        }
        if (this.m_ownerCPRule == null) {
            this.m_ownerCPRule = this.createCopyRule();
            this.m_ownerAssign.addCopyRule(this.m_ownerCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:ownerUser", objs);
        this.m_ownerCPRule.getFrom().setExpression(exp);
        this.m_ownerCPRule.getTo().setVariable(taskVarName);
        this.m_ownerCPRule.getTo().setPart("payload");
        this.m_ownerCPRule.getTo().setQuery(queryStr);
    }

    private void removeOwnerValue() {
        List list;
        if (this.m_ownerCPRule == null) {
            return;
        }
        if (this.m_ownerAssign != null && (list = this.m_ownerAssign.getCopyRules()) != null) {
            ArrayList newList = new ArrayList(list);
            newList.remove(this.m_ownerCPRule);
            this.m_ownerAssign.setCopyRules(newList);
        }
    }

    private void removeIdKeyValue() {
        this.removeValue(this.m_idKeyCPRule);
    }

    private void removeIdContextValue() {
        this.removeValue(this.m_idContextCPRule);
    }

    private void removeAppContextValue() {
        this.removeValue(this.m_AppContextCPRule);
    }

    private void removeValue(Copy pRule) {
        if (this.m_idKeyAssign == null) {
            return;
        }
        List list = this.m_idKeyAssign.getCopyRules();
        if (list == null) {
            return;
        }
        ArrayList nl = new ArrayList(list);
        nl.remove(pRule);
        this.m_idKeyAssign.setCopyRules(nl);
    }

    private void saveIdKeyValue(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_idKeyAssign == null) {
            this.m_idKeyAssign = this.getFirstAssign();
            if (this.m_idKeyAssign == null) {
                return;
            }
        }
        if (this.m_idKeyCPRule == null) {
            this.m_idKeyCPRule = this.createCopyRule();
            this.m_idKeyAssign.addCopyRule(this.m_idKeyCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:identificationKey", objs);
        this.m_idKeyCPRule.getFrom().setExpression(exp);
        this.m_idKeyCPRule.getTo().setVariable(taskVarName);
        this.m_idKeyCPRule.getTo().setPart("payload");
        this.m_idKeyCPRule.getTo().setQuery(queryStr);
    }

    private void saveIdentityContextKeyValue(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_idKeyAssign == null) {
            this.m_idKeyAssign = this.getFirstAssign();
            if (this.m_idKeyAssign == null) {
                return;
            }
        }
        if (this.m_idContextCPRule == null) {
            this.m_idContextCPRule = this.createCopyRule();
            this.m_idKeyAssign.addCopyRule(this.m_idContextCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:identityContext", objs);
        this.m_idContextCPRule.getFrom().setExpression(exp);
        this.m_idContextCPRule.getTo().setVariable(taskVarName);
        this.m_idContextCPRule.getTo().setPart("payload");
        this.m_idContextCPRule.getTo().setQuery(queryStr);
    }

    private void saveApplicationContextKeyValue(String exp, String taskVarName, String taskSvcPrefix, String msgName, String taskPrefix) {
        if (this.m_idKeyAssign == null) {
            this.m_idKeyAssign = this.getFirstAssign();
            if (this.m_idKeyAssign == null) {
                return;
            }
        }
        if (this.m_AppContextCPRule == null) {
            this.m_AppContextCPRule = this.createCopyRule();
            this.m_idKeyAssign.addCopyRule(this.m_AppContextCPRule);
        }
        Object[] objs = new Object[]{taskSvcPrefix, msgName, taskPrefix};
        String queryStr = MessageFormat.format("/{0}:{1}/{2}:task/{2}:applicationContext", objs);
        this.m_AppContextCPRule.getFrom().setExpression(exp);
        this.m_AppContextCPRule.getTo().setVariable(taskVarName);
        this.m_AppContextCPRule.getTo().setPart("payload");
        this.m_AppContextCPRule.getTo().setQuery(queryStr);
    }

    private Assign getFirstAssign() {
        if (this.m_task == null) {
            return null;
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return null;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return null;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            return (Assign)act;
        }
        return null;
    }

    private void loadOwnerFromTask() {
        String owner = this.m_ownerField.getText();
        if (owner == null || owner.trim().equalsIgnoreCase("")) {
            TaskDefinition def = this.mEditorData.getTaskDefinition();
            if (def == null) {
                return;
            }
            String defOwner = null;
            if (def.getRoutingSlip() != null && def.getRoutingSlip().getGlobalConfiguration() != null) {
                defOwner = def.getRoutingSlip().getGlobalConfiguration().getOwner();
            }
            if (defOwner != null) {
                this.m_ownerField.setText(defOwner);
            }
        }
    }

    private void loadIdentificationKeyFromTask() {
        if (this.m_task == null) {
            return;
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            List cpRules = ((Assign)act).getCopyRules();
            for (int j = 0; j < cpRules.size(); ++j) {
                Object c = cpRules.get(j);
                if (!(c instanceof Copy) || !this.loadIdentificationKeyFromCopyStatement((Copy)c, (Assign)act)) continue;
                return;
            }
        }
    }

    private void loadIdentityContextFromTask() {
        if (this.m_task == null) {
            return;
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            List cpRules = ((Assign)act).getCopyRules();
            for (int j = 0; j < cpRules.size(); ++j) {
                Object c = cpRules.get(j);
                if (!(c instanceof Copy) || !this.loadIdentityContextFromCopyStatement((Copy)c, (Assign)act)) continue;
                return;
            }
        }
    }

    private boolean loadIdentityContextFromCopyStatement(Copy c, Assign act) {
        To to = c.getTo();
        From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("identityContext") && from.getExpression() != null) {
            String exp = from.getExpression();
            this.m_idContextCPRule = c;
            this.m_idKeyAssign = act;
            this.mIdentityContext.setText(exp);
            bHandled = true;
        }
        return bHandled;
    }

    private void loadApplicationContextFromTask() {
        if (this.m_task == null) {
            return;
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            act = (Activity)actList.get(i);
            if (!(act instanceof Assign)) continue;
            List cpRules = ((Assign)act).getCopyRules();
            for (int j = 0; j < cpRules.size(); ++j) {
                Object c = cpRules.get(j);
                if (!(c instanceof Copy) || !this.loadApplicationContextFromCopyStatement((Copy)c, (Assign)act)) continue;
                return;
            }
        }
    }

    private boolean loadApplicationContextFromCopyStatement(Copy c, Assign act) {
        To to = c.getTo();
        From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("applicationContext") && from.getExpression() != null) {
            String exp = from.getExpression();
            this.m_AppContextCPRule = c;
            this.m_idKeyAssign = act;
            this.mApplicationContext.setText(exp);
            bHandled = true;
        }
        return bHandled;
    }

    private boolean loadIdentificationKeyFromCopyStatement(Copy c, Assign act) {
        To to = c.getTo();
        From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("identificationKey") && from.getExpression() != null) {
            String exp = from.getExpression();
            bHandled = true;
            this.m_idKeyCPRule = c;
            this.m_idKeyAssign = act;
            if (exp.startsWith("string(")) {
                MessageFormat fmt = new MessageFormat("string(''{0}''");
                try {
                    Object[] obj = fmt.parse(exp);
                    this.m_indentificationKeyField.setText((String)obj[0]);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            } else if (exp.startsWith("concat(") && exp.endsWith(")")) {
                this.m_indentificationKeyField.setText(this.parseConcatExp(exp));
            } else {
                this.m_indentificationKeyField.setText(this.parseConcatExp("<%" + exp.trim() + "%>"));
            }
        }
        return bHandled;
    }

    private void loadScopeNameAndGlobalVar() {
        if (this.m_task == null || this.m_task.getName() == null) {
            return;
        }
        String name = this.m_task.getName();
        this.m_scopeNameField.setText(name);
        if (this.m_incHistory.isSelected()) {
            int idx;
            String varName = this.m_task.getVariableName();
            this.m_globalTaskVarField.setText(varName);
            if (varName != null && (idx = varName.lastIndexOf("_globalVariable")) != -1) {
                String taskName = varName.substring(0, idx);
                ComboBoxModel model = this.m_historyCB.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    UserTaskItem item = (UserTaskItem)model.getElementAt(i);
                    if (!item.toString().equals(taskName)) continue;
                    this.m_historyCB.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.m_globalTaskVarField.setText(name + "_globalVariable");
        }
        this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
    }

    private boolean loadOwner(Copy c, Assign act) {
        To to = c.getTo();
        From from = c.getFrom();
        if (to == null || from == null) {
            return false;
        }
        String q = to.getQuery();
        String p = to.getPart();
        boolean bHandled = false;
        if (p != null && p.equals("payload") && q != null && q.endsWith("ownerUser") && from.getExpression() != null) {
            String exp = from.getExpression();
            bHandled = true;
            this.m_ownerCPRule = c;
            this.m_ownerAssign = act;
            if (exp.startsWith("concat(") && exp.endsWith(")")) {
                this.m_ownerField.setText(this.parseConcatExp(exp));
            } else {
                this.m_ownerField.setText("<%" + exp.trim() + "%>");
            }
        }
        return bHandled;
    }

    private boolean PayloadInitialized() {
        Assign assign;
        List list;
        if (this.m_task != null && (list = (assign = GeneralTaskEditPage.getAssignFromTaskActList(this.m_task.getActivityList())).getCopyRules()) != null) {
            for (Object copy : list) {
                if (!(copy instanceof Copy) || ((Copy)copy).getFrom() == null || ((Copy)copy).getFrom().getLiteral() == null || !((Copy)copy).getFrom().getLiteral().trim().startsWith("<payload") || ((Copy)copy).getTo() == null || !((Copy)copy).getTo().getPart().trim().equals("payload") || !((Copy)copy).getTo().getQuery().trim().endsWith("payload")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getCallback() {
        WorkflowConfigurationType wcft;
        boolean isCallback = false;
        TaskDefinition def = this.mEditorData.getTaskDefinition();
        if (def != null && (wcft = def.getWorkflowConfiguration()) != null) {
            isCallback = wcft.isBpelEventListener();
        }
        return isCallback;
    }

    private void loadReinitAndCallback() {
        if (this.m_task == null) {
            return;
        }
        List actList = this.m_task.getActivityList();
        if (actList == null || actList.size() == 0 || actList.size() > 1) {
            return;
        }
        Activity act = (Activity)actList.get(0);
        if (!(act instanceof Sequence)) {
            return;
        }
        actList = ((Sequence)act).getActivityList();
        for (int i = 0; i < actList.size(); ++i) {
            String pickName;
            Activity whileActcChild;
            Iterator iter;
            act = (Activity)actList.get(i);
            if (act instanceof Invoke) {
                String operation = ((Invoke)act).getOperation();
                boolean includeHistory = false;
                if (operation != null && operation.equalsIgnoreCase(REINITIATE_OPERATION)) {
                    this.m_bOrigIncHistory = true;
                    this.m_incHistory.setEnabled(true);
                    this.m_incHistory.setSelected(true);
                    includeHistory = true;
                }
                this.mEditorData.setIncludeHistory(includeHistory);
                continue;
            }
            if (!(act instanceof While) || !(iter = ((While)act).getActivities()).hasNext() || !((whileActcChild = (Activity)iter.next()) instanceof Pick) || !(pickName = whileActcChild.getName()).startsWith(PICK_NAME)) continue;
            this.m_bOrigAllowCallBack = true;
            this.mCallback = true;
        }
        if (this.m_incHistory.isSelected()) {
            if (this.PayloadInitialized()) {
                this.m_reInitPayload.setSelected(true);
                this.mEditorData.setReinitializePayload(this.m_reInitPayload.isSelected());
            } else {
                this.m_useOldPayload.setSelected(true);
                this.mEditorData.setReinitializePayload(!this.m_useOldPayload.isSelected());
            }
        }
    }

    private void handleSelectedUserTask() {
        if (this.m_incHistory.isSelected()) {
            if (this.m_historyCB.getModel().getSize() > 0) {
                UserTaskItem ut = (UserTaskItem)this.m_historyCB.getSelectedItem();
                this.m_globalTaskVarField.setText(ut.getVariableName());
                this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
                this.m_reInitPayload.setEnabled(true);
                this.m_useOldPayload.setEnabled(true);
            }
        } else {
            TaskDefinition def = this.mEditorData.getTaskDefinition();
            if (def != null) {
                String name = def.getName();
                String text = this.m_scopeNameField.getText();
                if (text == null || text.trim().equals("")) {
                    name = BPELModelUtil.generateUniqueName((Process)this.m_graphModel.getProcess(), (String)name, Scope.class);
                }
                if (text != null && !text.trim().equals("") && !name.equals(text)) {
                    name = text;
                }
                this.m_globalTaskVarField.setText(name + "_globalVariable");
                this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
            }
            this.m_reInitPayload.setEnabled(false);
            this.m_useOldPayload.setEnabled(false);
        }
    }

    private void updateGlobalVarField() {
        this.m_globalTaskVarField.setText(this.m_scopeNameField.getText() + "_globalVariable");
        this.mEditorData.setTaskVariableName(this.m_globalTaskVarField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_ownerCreateBtn) {
            this.handleGraphicBuilderForTextField(this.m_ownerField, (Activity)this.m_task);
        } else if (src == this.m_IdentificationKeyBtn) {
            this.handleGraphicBuilderForTextField(this.m_indentificationKeyField, (Activity)this.m_task);
        } else if (src == this.m_incHistory) {
            if (this.m_incHistory.isSelected()) {
                this.m_reInitPayload.setSelected(true);
            }
            this.handleSelectedUserTask();
            this.mEditorData.setIncludeHistory(this.m_incHistory.isSelected());
        } else if (src == this.m_historyCB) {
            if (this.m_incHistory.isSelected()) {
                this.handleSelectedUserTask();
            }
        } else if (src == this.m_allowCallback) {
            this.mEditorData.setAllowCallback(this.m_allowCallback.isSelected());
        } else if (src == this.m_reInitPayload) {
            this.mEditorData.setReinitializePayload(this.m_reInitPayload.isSelected());
        } else if (src == this.m_useOldPayload) {
            this.mEditorData.setReinitializePayload(!this.m_useOldPayload.isSelected());
        }
    }

    private Copy createCopyRule() {
        Element elem = this.m_task.getDOMElement();
        Copy c = (Copy)BPELParser.createImplementation(Copy.class);
        c.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        From from = (From)BPELParser.createImplementation(From.class);
        from.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        To to = (To)BPELParser.createImplementation(To.class);
        to.createDOMElement(elem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        c.setFrom(from);
        c.setTo(to);
        return c;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.m_incHistory.isSelected()) {
            this.updateGlobalVarField();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.m_incHistory.isSelected()) {
            this.updateGlobalVarField();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.m_incHistory.isSelected()) {
            this.updateGlobalVarField();
        }
    }

    @Override
    public boolean checkForValidity() {
        return this.validateEditorChanges();
    }

    class UserTaskItem {
        public UserTask m_userTask;

        public UserTaskItem(UserTask ut) {
            this.m_userTask = ut;
        }

        public String getVariableName() {
            return this.m_userTask.getKey();
        }

        public String toString() {
            return this.m_userTask.getName();
        }
    }
}

