/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor;

import java.awt.Component;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.UserTaskNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WFBPELCodeGen;
import org.w3c.dom.Node;

public class UserTaskPanelManager
extends AbstractActivityNodeEditor.PanelManager {
    protected UserTaskNode m_utNode;
    protected BPELGraphModel m_model;
    private UserTaskEditorData mData;

    public UserTaskPanelManager(UserTaskEditorData pData) {
        this.mData = pData == null ? new UserTaskEditorData() : pData;
    }

    public void setUserTaskNode(UserTaskNode n) {
        this.m_utNode = n;
    }

    public UserTaskNode getUserTaskNode() {
        return this.m_utNode;
    }

    public void setBPELGraphModel(BPELGraphModel model) {
        this.m_model = model;
    }

    @Override
    public void saveChanges() {
        super.saveChanges();
        boolean bReGen = this.mData.generateData();
        if (!bReGen) {
            return;
        }
        WFBPELCodeGen u = this.mData.getBPELCodeGen();
        if (this.m_pages != null && this.m_utNode != null && this.m_model != null) {
            UserTask ut = (UserTask)this.m_pages[0].getUserObject();
            Process process = this.mData.getProcess();
            String patternName = this.mData.getAllowCallbackPattern();
            try {
                Node docNode = u.generateBPELCode(patternName, process);
                if (docNode == null) {
                    GraphUtils.displayMessage((Component)this.m_pages[0].getPagePanel(), (String)"Failed to generate BPEL code, please make sure the template file existed.", (int)0);
                }
                ut.replaceScopeElem(process, docNode);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ModelBuilder mb = new ModelBuilder();
            this.m_utNode.clearChildren();
            mb.buildScopeNode(this.m_utNode, (Scope)ut);
            String varName = this.mData.getTaskVariableName();
            ut.setKey(varName);
        }
    }
}

