/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.General;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Property;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.UserTaskRoutingSlipModel;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.Participant;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.routingslip.participants.SequentialParticipant;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Switch;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizard;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.UserTaskView;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.UserTaskEditorData;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WFBPELCodeGen;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editor.WorkflowDialog;
import oracle.tip.tools.ide.pm.modules.workflow.util.WFUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WFDNDDropHandler
implements DNDDropHandler {
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        boolean bValidate = graph.getValidateOnLoad();
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        if (!(r instanceof DropZone)) {
            return false;
        }
        DropZone dropView = (DropZone)r;
        if (!dropView.isDropAllowed()) {
            return false;
        }
        dropView.setHighLightOn(false);
        return this.handleUserTaskDrop(taskName, r, process, bValidate, graph, model);
    }

    public boolean handleUserTaskDrop(String taskName, NodeRenderer r, Process process, boolean bValidate, BPELGraphPane graph, BPELGraphModel model) {
        oracle.tip.tools.ide.common.graph.model.Node dropNode = r.getNode();
        GraphNode newNode = null;
        Activity activity = null;
        UserTaskEditorData data = null;
        UserTask ut = null;
        if (taskName.equalsIgnoreCase("human_task_scope")) {
            newNode = ModelBuilder.createGraphNode(501, process, bValidate);
            oracle.tip.tools.ide.common.graph.model.Node parentNode = r.getParent().getNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            int index = parentNode.indexOf(dropNode);
            List actList = parentActivity.getActivityList();
            List usList = null;
            if (actList.size() > 0) {
                int position = index / 2;
                if (position == actList.size()) {
                    position = actList.size() - 1;
                }
                Activity siblAct = (Activity)actList.get(position);
                usList = WFUtil.findAllDefinedUserTaskFromParent((Activity)parentActivity, siblAct);
            } else {
                Activity parent = parentActivity.getParentActivity();
                if (parent != null) {
                    usList = WFUtil.findAllDefinedUserTaskFromParent(parent, (Activity)parentActivity);
                }
            }
            data = new UserTaskEditorData();
            data.setProcess(process);
            WorkflowDialog dlg = new WorkflowDialog(GraphUtils.getFrame((Component)((Object)graph)), graph, (oracle.tip.tools.ide.common.graph.model.Node)newNode, usList, data);
            if (dlg.create() == 0) {
                data = dlg.getUserTaskEditorData();
                ut = dlg.getUserTask();
                activity = (Activity)newNode.getUserObject();
            } else {
                newNode = null;
            }
        } else if (taskName.equalsIgnoreCase("Simple")) {
            newNode = ModelBuilder.createGraphNode(502, process, bValidate);
        } else if (taskName.equalsIgnoreCase("Sequential")) {
            newNode = ModelBuilder.createGraphNode(503, process, bValidate);
        }
        if (newNode != null) {
            Object obj;
            UserTaskRoutingSlipModel routingSlipModel = null;
            boolean bWorkflowFlowMode = false;
            NodeRenderer parentRenderer = r.getParent();
            if (parentRenderer instanceof UserTaskView) {
                UserTaskView uv = (UserTaskView)parentRenderer;
                bWorkflowFlowMode = uv.getWorkflowMode();
                ut = (UserTask)uv.getNode().getUserObject();
                routingSlipModel = ut.getUserTaskRoutingSlipModel(model.getBPELProject());
            }
            Object parentNode = r.getParent().getNode();
            int index = parentNode.indexOf(dropNode);
            if (bWorkflowFlowMode && routingSlipModel != null && ((obj = newNode.getUserObject()) instanceof Participant || obj instanceof SequentialParticipant)) {
                routingSlipModel.addParticipant(obj);
            }
            if (!bWorkflowFlowMode && activity != null) {
                ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
                if (parentActivity.getActivityList().size() < 2) {
                    Data d = this.insertSequence((oracle.tip.tools.ide.common.graph.model.Node)parentNode, graph, process);
                    parentActivity = d.getSequence();
                    parentNode = d.getNode();
                } else {
                    BPELDNDDropHandler.checkForSequenceInsertion(parentNode, (oracle.tip.tools.ide.common.graph.model.Node)newNode, graph, dropNode, process);
                }
                if (parentActivity != null && activity != null) {
                    try {
                        parentActivity.insertActivity(index / 2, activity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (data != null && ut != null) {
                WFDNDDropHandler.generateBPELCode(data, ut, process, graph, (oracle.tip.tools.ide.common.graph.model.Node)newNode);
            }
            model.insertChildNode((oracle.tip.tools.ide.common.graph.model.Node)parentNode, (oracle.tip.tools.ide.common.graph.model.Node)newNode, index);
            oracle.tip.tools.ide.common.graph.model.Node switchNode = WFDNDDropHandler.createSwitchNode(data, process.getDOMElement().getOwnerDocument());
            if (switchNode != null) {
                try {
                    BPELGraphUtils.insertActivityAfter(switchNode, (Activity)ut, graph);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)((Object)graph), (Throwable)e);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private static Collection removeDuplicateOutcomes(Collection<String> pOutcomes) {
        ArrayList<String> c = new ArrayList<String>();
        if (pOutcomes == null) {
            return c;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : pOutcomes) {
            String newStr;
            if ((str = str.trim()).length() == 0 || map.containsKey(newStr = str.toUpperCase())) continue;
            map.put(newStr, str);
            c.add(str);
        }
        return c;
    }

    public Data insertSequence(oracle.tip.tools.ide.common.graph.model.Node parentNode, GraphPane graph, Process p) {
        SequenceNode seqNode = new SequenceNode();
        Sequence seqModel = (Sequence)BPELParser.createImplementation(Sequence.class);
        seqModel.setName(BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class));
        seqNode.setUserObject(seqModel);
        Element processElem = p.getDOMElement();
        Element seqElem = seqModel.createDOMElement(processElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        seqModel.setDOMElement(seqElem);
        ContainerActivity containerModel = (ContainerActivity)parentNode.getUserObject();
        Iterator iterator = parentNode.getChildren().iterator();
        ArrayList<oracle.tip.tools.ide.common.graph.model.Node> activityLst = new ArrayList<oracle.tip.tools.ide.common.graph.model.Node>();
        while (iterator.hasNext()) {
            oracle.tip.tools.ide.common.graph.model.Node n = (oracle.tip.tools.ide.common.graph.model.Node)iterator.next();
            if (n.getNodeType() == 0) continue;
            activityLst.add(n);
        }
        ((DroppableBranchNode)parentNode).clearChildren();
        for (oracle.tip.tools.ide.common.graph.model.Node n : activityLst) {
            seqNode.addToEndOfBranch(n);
            Activity act = (Activity)n.getUserObject();
            try {
                containerModel.deleteActivity(act);
                seqModel.addActivity(act);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((DroppableBranchNode)parentNode).addToEndOfBranch((oracle.tip.tools.ide.common.graph.model.Node)seqNode);
        try {
            containerModel.addActivity((Activity)seqModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BPELGraphModel graphModel = (BPELGraphModel)graph.getModel();
        graphModel.fireGraphStructureChanged();
        NodeRenderer renderer = graph.getNodeRendererForNode(parentNode);
        if (renderer != null) {
            renderer.rebuildNodeRenderersFromModel();
        }
        graph.forceLayout();
        return new Data(seqModel, seqNode);
    }

    public static boolean inWorkflowView(NodeRenderer r) {
        while (r != null) {
            if (r instanceof UserTaskView) {
                UserTaskView v = (UserTaskView)r;
                return v.getWorkflowMode();
            }
            r = r.getParent();
        }
        return false;
    }

    protected void handleUserTask(DropTargetDropEvent e, NodeRenderer r, oracle.tip.tools.ide.common.graph.model.Node dropNode, GraphPane graph) {
        TaskFlowWizardContext.IS_STANDALONE_TESTING = true;
        oracle.tip.tools.ide.common.graph.model.Node parentNode = r.getParent().getNode();
        ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
        int index = parentNode.indexOf(dropNode);
        TaskFlowWizard tfWizard = new TaskFlowWizard(r, graph, index, new HashMap());
        tfWizard.display();
        oracle.tip.tools.ide.common.graph.model.Node newNode = tfWizard.getTaskFlowWizardContext().scopeNode;
        oracle.tip.tools.ide.common.graph.model.Node wfSwitchNode = tfWizard.getTaskFlowWizardContext().switchNode;
        if (newNode == null) {
            return;
        }
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, newNode, graph, dropNode, process)) {
            if (wfSwitchNode != null) {
                Activity wfSwithcActivity = (Activity)wfSwitchNode.getUserObject();
                int scopeIndex = parentNode.getChildNode(1).indexOf(newNode);
                ContainerActivity parentActivitySwitch = (ContainerActivity)parentNode.getChildNode(1).getUserObject();
                if (parentActivitySwitch != null && wfSwithcActivity != null) {
                    try {
                        parentActivitySwitch.insertActivity((scopeIndex + 1) / 2, wfSwithcActivity);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                model.insertChildNode(parentNode.getChildNode(1), wfSwitchNode, scopeIndex + 1);
            }
            e.dropComplete(true);
            return;
        }
        Activity activity = (Activity)newNode.getUserObject();
        index = parentNode.indexOf(dropNode);
        if (parentActivity != null && activity != null) {
            try {
                parentActivity.insertActivity(index / 2, activity);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        model.insertChildNode(parentNode, newNode, index);
        if (wfSwitchNode != null) {
            Activity wfSwithcActivity = (Activity)wfSwitchNode.getUserObject();
            if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, wfSwitchNode, graph, dropNode, process)) {
                e.dropComplete(true);
                return;
            }
            int scopeIndex = parentNode.indexOf(newNode);
            if (parentActivity != null && wfSwithcActivity != null) {
                try {
                    parentActivity.insertActivity((scopeIndex + 1) / 2, wfSwithcActivity);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            model.insertChildNode(parentNode, wfSwitchNode, scopeIndex + 1);
        }
        model.buildPartnerLinkConnections();
        e.dropComplete(true);
    }

    public static void generateBPELCode(UserTaskEditorData pData, UserTask ut, Process process, BPELGraphPane graph, oracle.tip.tools.ide.common.graph.model.Node newNode) {
        if (pData != null && ut != null) {
            TaskDefinition def = pData.getTaskDefinition();
            List list = def.getWorkflowConfiguration().getOutcomes().getOutcome();
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
            WFBPELCodeGen u = pData.getBPELCodeGen();
            if (u != null) {
                String patternName = pData.getAllowCallbackPattern();
                try {
                    Node docNode = u.generateBPELCode(patternName, process);
                    if (docNode == null) {
                        GraphUtils.displayMessage((Component)((Object)graph), (String)"Failed to generate BPEL code, please make sure the template file existed.", (int)0);
                    }
                    ut.replaceScopeElem(process, docNode);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ModelBuilder mb = new ModelBuilder();
                mb.buildScopeNode((ScopeNode)newNode, (Scope)ut);
                String varName = pData.getTaskVariableName();
                ut.setKey(varName);
            }
        }
    }

    public static oracle.tip.tools.ide.common.graph.model.Node createSwitchNode(UserTaskEditorData pData, Document doc) {
        oracle.tip.tools.ide.common.graph.model.Node switchNode = null;
        try {
            if (pData != null) {
                WFBPELCodeGen u = pData.getBPELCodeGen();
                Switch switchModel = (Switch)BPELParser.createImplementation(Switch.class);
                switchModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                switchModel.setName("taskSwitch");
                TaskDefinition def = pData.getTaskDefinition();
                Collection list = WFDNDDropHandler.removeDuplicateOutcomes(def.getWorkflowConfiguration().getOutcomes().getOutcome());
                List cpList = pData.getSwitchRuleList();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    SwitchCase c = (SwitchCase)BPELParser.createImplementation(SwitchCase.class);
                    c.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                    String outcome = (String)iter.next();
                    c.setCondition(u.getSwitchCondition(outcome));
                    String desc = "Task outcome is " + outcome;
                    c.setDescription(desc);
                    General general = (General)BPELParser.createImplementation(General.class);
                    c.getAnnotation().setGeneral(general);
                    Property prop = (Property)BPELParser.createImplementation(Property.class);
                    prop.setName("userLabel");
                    prop.setValue(desc);
                    ArrayList<Property> proplist = new ArrayList<Property>();
                    proplist.add(prop);
                    general.addProperty(prop);
                    Sequence s = (Sequence)BPELParser.createImplementation(Sequence.class);
                    s.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                    Assign a = (Assign)BPELParser.createImplementation(Assign.class);
                    a.setName("CopyPayloadFromTask");
                    a.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                    WFDNDDropHandler.addCopyRules(a, doc, cpList);
                    s.addActivity((Activity)a);
                    c.addActivity((Activity)s);
                    switchModel.addSwitchCase(c);
                }
                SwitchOtherwise o = (SwitchOtherwise)BPELParser.createImplementation(SwitchOtherwise.class);
                Sequence s = (Sequence)BPELParser.createImplementation(Sequence.class);
                s.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                Assign a = (Assign)BPELParser.createImplementation(Assign.class);
                a.setName("CopyPayloadFromTask");
                a.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                s.addActivity((Activity)a);
                o.setDescription("Task is outcome is EXPIRED, STALE, WITHDRAWN or ERRORED");
                o.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                WFDNDDropHandler.addCopyRules(a, doc, cpList);
                o.addActivity((Activity)s);
                switchModel.setSwitchOtherwise(o);
                ModelBuilder mb = new ModelBuilder();
                switchNode = mb.handleSwitch(switchModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return switchNode;
    }

    private static void addCopyRules(Assign a, Document doc, List cpList) {
        if (cpList == null) {
            return;
        }
        for (int j = 0; j < cpList.size(); ++j) {
            Copy cp = (Copy)cpList.get(j);
            Copy newCP = (Copy)BPELParser.createImplementation(Copy.class);
            newCP.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            From f = (From)BPELParser.createImplementation(From.class);
            f.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            f.setVariable(cp.getFrom().getVariable());
            f.setPart(cp.getFrom().getPart());
            f.setQuery(cp.getFrom().getQuery());
            f.setExpression(cp.getFrom().getExpression());
            f.setLiteral(cp.getFrom().getLiteral());
            f.setPartnerLink(cp.getFrom().getPartnerLink());
            newCP.setFrom(f);
            To t = (To)BPELParser.createImplementation(To.class);
            t.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            t.setVariable(cp.getTo().getVariable());
            t.setPart(cp.getTo().getPart());
            t.setQuery(cp.getTo().getQuery());
            t.setPartnerLink(cp.getTo().getPartnerLink());
            newCP.setTo(t);
            a.addCopyRule(newCP);
        }
    }

    class Data {
        Sequence sequence;
        SequenceNode node;

        public Data(Sequence pSequence, SequenceNode pNode) {
            this.sequence = pSequence;
            this.node = pNode;
        }

        public Sequence getSequence() {
            return this.sequence;
        }

        public SequenceNode getNode() {
            return this.node;
        }
    }
}

