/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf;

import java.awt.Component;
import java.awt.Image;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.UserTaskNode;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class UserTaskView
extends ScopeView {
    public UserTaskView(GraphPane pane, View parent, UserTaskNode n) {
        super(pane, parent, n);
        this.setAcceptsArrow(true);
    }

    public boolean getWorkflowMode() {
        return false;
    }

    @Override
    protected Image getImage() {
        return ImageCache.getImage("graph/extensions/humantask_bpel_dia.png");
    }

    @Override
    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            if (a instanceof UserTask) {
                ((UserTask)a).setWFDir(this.getBPELGraphPane().getBPELProject());
            }
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    @Override
    protected boolean hasWarning() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            ValidationReport r;
            if (a instanceof UserTask) {
                ((UserTask)a).setWFDir(this.getBPELGraphPane().getBPELProject());
            }
            if ((r = a.getValidationReport(this.createValidationContext(), false)) == null) {
                r = a.getValidationReport(this.createValidationContext(), true);
            }
            return r.getState() != 0;
        }
        return false;
    }

    public int showCustomDeleteConfirmationDialog() {
        int userTasks = this.findAllDefinedUserTasks().size();
        int retVal = userTasks == 1 ? GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this.getGraphPane()), (String)BPELStringTranslator.formatString("LAST_USERTASK_DELETE_GRAPH_ELEM", this.getModelElement().getDisplayTypeName()), (String)BPELStringTranslator.getString("COLLAXALAF_CONFIRM_DELETE")) : GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this.getGraphPane()), (String)BPELStringTranslator.formatString("DELETE_GRAPH_ELEM", this.getModelElement().getDisplayTypeName()), (String)BPELStringTranslator.getString("COLLAXALAF_CONFIRM_DELETE"));
        return retVal;
    }

    protected List findAllDefinedUserTasks() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        return BPELModelUtil.getAllActivitiesOfType((Process)model.getProcess(), UserTask.class);
    }
}

