/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.workflow.activityguide;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.pm.modules.workflow.activityguide.ActivityTask;
import oracle.tip.tools.ide.pm.modules.workflow.activityguide.WFActivity;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivityBuilder {
    protected static Hashtable s_taskTable = new Hashtable();
    static MyResolver nsr = new MyResolver();

    public static List parse(URL bpelFileURL) {
        ArrayList<WFActivity> wfActivityList = new ArrayList<WFActivity>();
        try {
            NodeList scopeNL = ActivityBuilder.getScopeNodes(bpelFileURL);
            int scopeNodeCount = scopeNL.getLength();
            if (scopeNodeCount == 0) {
                return null;
            }
            for (int i = 0; i < scopeNodeCount; ++i) {
                String activityNumStr;
                XMLNode scopeNode = (XMLNode)scopeNL.item(i);
                Node wfAnnotationNode = scopeNode.selectSingleNode("bpelx:annotation/bpelx:analysis/bpelx:property[@name='wf.activityNumber']", (NSResolver)nsr);
                if (wfAnnotationNode == null || (activityNumStr = ((Element)wfAnnotationNode).getTextContent()) == null || activityNumStr.equals("")) continue;
                int activityNumber = Integer.parseInt(activityNumStr);
                WFActivity wfActivity = new WFActivity();
                wfActivity.setActivityNumber(activityNumber);
                String wfName = ((Element)scopeNode).getAttribute("name");
                String taskName = ActivityBuilder.getTaskName(wfName);
                ActivityTask task = ActivityBuilder.getOrCreateTask(taskName, bpelFileURL);
                wfActivity.setActivityTask(task);
                wfActivity.setWfName(wfName);
                wfActivityList.add(wfActivity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Collections.sort(wfActivityList);
        return ActivityBuilder.convert(wfActivityList);
    }

    private static NodeList getScopeNodes(URL bpelFileURL) throws Exception {
        DOMParser parser = new DOMParser();
        parser.parse(bpelFileURL);
        XMLDocument doc = parser.getDocument();
        Element docElem = doc.getDocumentElement();
        return ((XMLNode)docElem).selectNodes("//proc:scope", (NSResolver)nsr);
    }

    private static List convert(List<WFActivity> wfActivityList) {
        ArrayList list = new ArrayList();
        if (wfActivityList == null) {
            return null;
        }
        int lastNum = 0;
        ArrayList<WFActivity> lastList = new ArrayList<WFActivity>();
        for (WFActivity wfActivity : wfActivityList) {
            int currentNum = wfActivity.getActivityNumber();
            ArrayList<WFActivity> currentList = lastList;
            if (wfActivity.getActivityNumber() != lastNum) {
                currentList = new ArrayList();
                list.add(currentList);
            }
            currentList.add(wfActivity);
            lastNum = currentNum;
            lastList = currentList;
        }
        return list;
    }

    public static ActivityTask getOrCreateTask(String taskName, URL bpelFileURL) throws Exception {
        ActivityTask task = (ActivityTask)s_taskTable.get(taskName);
        if (task == null) {
            task = new ActivityTask();
            URL parentURL = URLFileSystem.getParent((URL)bpelFileURL);
            URL taskURL = new URL(parentURL, taskName + ".task");
            DOMParser parser = new DOMParser();
            parser.parse(taskURL);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            String taskNamespace = docElem.getNamespaceURI();
            String targetNamespace = docElem.getAttribute("targetNamespace");
            task.setNamespace(targetNamespace);
            MyResolver nsr = new MyResolver();
            nsr.add("pref", taskNamespace);
            Node nameNode = ((XMLNode)docElem).selectSingleNode("pref:name", (NSResolver)nsr);
            String name = nameNode.getTextContent();
            task.setTaskName(name);
            Node idNode = ((XMLNode)docElem).selectSingleNode("pref:id", (NSResolver)nsr);
            String id = idNode.getTextContent();
            task.setTaskId(id);
            s_taskTable.put(taskName, task);
        }
        return task;
    }

    public static String getTaskName(String wfScopeName) {
        int index = wfScopeName.lastIndexOf("_");
        return wfScopeName.substring(0, index);
    }

    public static void main(String[] args) throws Exception {
        URL bpelURL = null;
        bpelURL = args.length > 0 ? new URL(args[0]) : new URL("file:///scratch/dthakkar/programs/jdev/jdevbpelhome/mywork/Application1/Project1/sca/BPELProcess1.bpel");
        List wfList = ActivityBuilder.parse(bpelURL);
        if (wfList != null) {
            for (int i = 0; i < wfList.size(); ++i) {
                Object obj = wfList.get(i);
                if (!(obj instanceof List)) continue;
                List listObj = (List)obj;
                for (int j = 0; j < listObj.size(); ++j) {
                    WFActivity activity = (WFActivity)listObj.get(j);
                    System.out.println("activity name is: " + activity.getWfName() + "    activity number is: " + activity.getActivityNumber());
                }
            }
        }
    }

    private static class MyResolver
    implements NSResolver {
        Properties map = new Properties();

        private MyResolver() {
        }

        public void add(String prefix, String namespace) {
            this.map.put(prefix, namespace);
        }

        public String resolveNamespacePrefix(String pref) {
            if (pref.equals("proc")) {
                return "http://schemas.xmlsoap.org/ws/2003/03/business-process/";
            }
            if (pref.equals("bpelx")) {
                return "http://schemas.oracle.com/bpel/extension";
            }
            return (String)this.map.get(pref);
        }
    }
}

