/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.xpathexplorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.ui.DialogCancelListener;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.uipatterns.xpathexplorer.XPathTree;
import oracle.tip.tools.ide.pm.modules.uipatterns.xpathexplorer.XPathTreeNode;
import org.w3c.dom.Element;

public class XPathTreeDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
DialogCancelListener {
    protected Element m_elem;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected XPathTree m_tree;
    protected int m_retVal = 2;

    public XPathTreeDialog(Element elem, JFrame frame, boolean flag) {
        super(frame, "Select XPath", flag);
        this.m_elem = elem;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
        UIHelper.attachDialogCancelListener((JDialog)this, (DialogCancelListener)this);
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_okBtn = new JButton("OK");
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton("Cancel");
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton("Help");
        this.m_helpBtn.addActionListener(this);
        this.m_tree = new XPathTree(this.m_elem);
        this.m_tree.setBorder(new TitledBorder("Generic Tree Explorer"));
        this.m_tree.addPropertyChangeListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)c, (Component)this.m_tree, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        UIHelper.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        UIHelper.centerInScreen((Component)this);
    }

    protected void updateButtons() {
        XPathTreeNode node = this.m_tree.getSelectedNode();
        this.m_okBtn.setEnabled(this.m_tree.isNodeSelected() && !node.hasChildren());
    }

    public void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    public void handleCancel() {
        this.m_retVal = 2;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "TYPE_SELECTION_CHANGED") {
            this.updateButtons();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }
}

