/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternFragment;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternFragmentUtil;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.PatternUtil;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.BindingXML;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.FieldsXML;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.GraphXML;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.NamespaceBindingXML;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.PLBindingXML;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternXML {
    public static void save(BPELPattern bpelPattern) {
        String patternDir = PatternFragmentUtil.getPatternDirectory();
        String templateFile = patternDir + File.separator + "template.xml";
        try {
            File file = new File(templateFile);
            FileInputStream is = new FileInputStream(file);
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)is);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            Node scopeNode = bpelPattern.getFragment().getDOMElement((Document)doc);
            Element anElem = PatternUtil.getAnnotationElem((Document)doc, (Element)scopeNode, false);
            if (anElem != null) {
                scopeNode.removeChild(anElem);
            }
            anElem = PatternUtil.getAnnotationElem((Document)doc, (Element)scopeNode, true);
            Element aElem = doc.createElementNS("http://schemas.oracle.com/bpel/extension", "bpelx:pattern");
            aElem.setAttribute("patternName", "bpelx:pattern");
            anElem.appendChild(aElem);
            Node templateFragmentNode = ((XMLElement)docElem).selectSingleNode("fragment");
            templateFragmentNode.appendChild(scopeNode);
            URL dirURL = bpelPattern.getDirURL();
            URL fileURL = new URL(dirURL, "pattern_old.xml");
            FileOutputStream out = new FileOutputStream(fileURL.getFile());
            XMLPrintDriver driver = new XMLPrintDriver((OutputStream)out);
            driver.setEncoding("UTF-8");
            driver.printElement((XMLElement)docElem);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BPELPattern load(URL fileURL) {
        BPELPattern pattern = new BPELPattern();
        DOMParser parser = new DOMParser();
        XMLElement fragmentNode = null;
        Element fieldsNode = null;
        Element graphNode = null;
        Element bindingNode = null;
        Element plBindingsNode = null;
        Element nsBindingsNode = null;
        try {
            pattern.setDirURL(URLFileSystem.getParent((URL)fileURL));
            parser.parse(fileURL);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            NodeList nl = docElem.getChildNodes();
            pattern.setName(docElem.getAttribute("name"));
            pattern.setPatternId(docElem.getAttribute("pattern"));
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                String nodeName = n.getNodeName();
                if (n.getNodeType() != 1 || nodeName == null) continue;
                if ("fragment".equals(nodeName)) {
                    fragmentNode = (XMLElement)n;
                    continue;
                }
                if ("fields".equals(nodeName)) {
                    fieldsNode = (Element)n;
                    continue;
                }
                if ("graph".equals(nodeName)) {
                    graphNode = (Element)n;
                    continue;
                }
                if ("binding".equals(nodeName)) {
                    bindingNode = (Element)n;
                    continue;
                }
                if ("partnerLinkBindings".equals(nodeName)) {
                    plBindingsNode = (Element)n;
                    continue;
                }
                if (!"namespaceBindings".equals(nodeName)) continue;
                nsBindingsNode = (Element)n;
            }
            pattern.setFieldList(FieldsXML.load(fieldsNode));
            PatternFragment patternFragment = new PatternFragment((Element)fragmentNode);
            pattern.setPatternFragment(patternFragment);
            pattern.setPatternGraph(GraphXML.load(graphNode));
            pattern.setBinding(BindingXML.load(bindingNode));
            pattern.setPLBindings(PLBindingXML.load(plBindingsNode));
            pattern.setNSBindings(NamespaceBindingXML.load(nsBindingsNode));
            return pattern;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getFragmentStr(XMLElement fragmentElem) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLPrintDriver driver = new XMLPrintDriver((OutputStream)out);
        driver.setEncoding("UTF-8");
        driver.printElement(fragmentElem);
        return out.toString("UTF-8");
    }
}

