/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PLBinding;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PLBindingXML {
    public static Map load(Element elem) {
        if (elem == null) {
            return null;
        }
        HashMap<String, PLBinding> plBindingMap = new HashMap<String, PLBinding>();
        try {
            String replace = elem.getAttribute("replace");
            NSResolver nsr = BPELPattern.getNSResolver();
            NodeList plBindingNodes = ((XMLNode)elem).selectNodes("pattern:partnerLinkBinding", nsr);
            if (plBindingNodes == null) {
                return plBindingMap;
            }
            int nPLBindings = plBindingNodes.getLength();
            if (nPLBindings == 0) {
                return plBindingMap;
            }
            for (int i = 0; i < nPLBindings; ++i) {
                int propCount;
                XMLElement plBindingNode = (XMLElement)plBindingNodes.item(i);
                ArrayList<PLProperties> plPropertiesList = new ArrayList<PLProperties>();
                String plName = plBindingNode.getAttribute("name");
                NodeList propertiesNodes = plBindingNode.selectNodes("pattern:property", nsr);
                PLBinding plBinding = new PLBinding(plName, plPropertiesList);
                plBinding.setReplace(replace);
                plBindingMap.put(plName, plBinding);
                if (propertiesNodes == null || (propCount = propertiesNodes.getLength()) == 0) continue;
                for (int j = 0; j < propCount; ++j) {
                    String name = ((XMLElement)propertiesNodes.item(i)).getAttribute("name");
                    String type = ((XMLElement)propertiesNodes.item(i)).getAttribute("type");
                    String value = ((XMLElement)propertiesNodes.item(i)).getText();
                    if (name.equals("wsdlLocation")) {
                        plBinding.setWSDLLocation(value);
                        continue;
                    }
                    PLProperties plProperties = new PLProperties(name, value, type);
                    plPropertiesList.add(plProperties);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return plBindingMap;
    }
}

