/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.TextManipulator;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.explorer.VariableExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;

public class UIUtils {
    protected BPELGraphPane m_graphPane;
    protected BPELGraphModel m_graphModel;
    protected Process m_processModel;
    Activity m_parent;

    public UIUtils(BPELGraphPane pane, Activity parentActivity) {
        this.m_graphPane = pane;
        this.m_graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        this.m_processModel = this.m_graphModel.getProcess();
        this.m_parent = parentActivity;
    }

    private void invokeGraphicalXPathBuilder(XPathEditorPane editorPane, Activity activity) {
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, activity);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graphPane, dataCallBack, VariableExplorerTreeNode.getNSResolver(activity, this.m_processModel));
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker()};
        XPathEditorPane pane = new XPathEditorPane();
        pane.initializeDocument();
        TextManipulator tm = new TextManipulator((JTextComponent)editorPane);
        String expression = tm.getExpression();
        ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (JTextComponent)pane, pickers);
        if (expression != null) {
            dlg.setExpressionText(expression);
        }
        if (dlg.display() == 0) {
            editorPane.setText(dlg.getExpressionText());
        }
    }

    public void handleGraphicBuilderForTextField(JTextComponent textField) {
        XPathEditorPane x = new XPathEditorPane();
        String inStr = this.getDelimiterString(textField);
        x.setText(inStr);
        this.invokeGraphicalXPathBuilder(x, this.m_parent);
        String s = x.getText();
        if (s != null && (s = s.trim()).length() > 0) {
            textField.setText(this.getText(textField, inStr, "<%" + s + "%>"));
        }
    }

    private String getDelimiterString(JTextComponent textField) {
        int caretPos = textField.getCaretPosition();
        String retStr = null;
        try {
            String text = textField.getText();
            int indexOfStartingDelimiter = text.lastIndexOf("<%", caretPos);
            int indexOfPrecedingEndingDelimiter = text.lastIndexOf("%>", caretPos - 1);
            int indexOfFollowingEndingDelimiter = text.indexOf("%>", caretPos);
            if (indexOfStartingDelimiter != -1 && indexOfStartingDelimiter > indexOfPrecedingEndingDelimiter) {
                retStr = indexOfFollowingEndingDelimiter == -1 ? text.substring(indexOfStartingDelimiter + 2) : text.substring(indexOfStartingDelimiter + 2, indexOfFollowingEndingDelimiter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retStr;
    }

    private String getText(JTextComponent textField, String initStr, String targetText) {
        String text;
        block7: {
            text = textField.getText();
            int textLength = textField.getDocument().getLength();
            if (text != null) {
                int caretPos = textField.getCaretPosition();
                if (caretPos > 0 && caretPos < textLength) {
                    try {
                        if (initStr != null) {
                            String subStr = textField.getDocument().getText(0, caretPos + 2);
                            int startIndex = subStr.lastIndexOf("<%");
                            int endIndex = text.indexOf("%>", caretPos);
                            text = startIndex == -1 || endIndex == -1 ? text + targetText : text.substring(0, startIndex) + targetText + text.substring(endIndex + 2, textLength);
                            break block7;
                        }
                        String startText = textField.getDocument().getText(0, caretPos);
                        int length = textLength - caretPos;
                        String endText = textField.getDocument().getText(caretPos, length);
                        text = startText + targetText + endText;
                    }
                    catch (BadLocationException bae) {
                        text = text + targetText;
                    }
                } else {
                    text = caretPos == 0 ? targetText + text : text + targetText;
                }
            } else {
                text = targetText;
            }
        }
        return text;
    }

    public static void add(Container ct, Component comp, int x, int y, int w, int h, double xw, double yw, int loc, int fill, Insets insets) {
        ct.add(comp, new GridBagConstraints(x, y, w, h, xw, yw, loc, fill, insets, 0, 0));
    }

    public String startLookupDialog(int lookupType) {
        return UIUtils.startLookupDialog((Component)((Object)this.m_graphPane), lookupType);
    }

    private static String startLookupDialog(Component comp, int lookupType) {
        LookupDialog dialog = new LookupDialog(lookupType, comp, LookupDialog.EMAIL_LOOKUP);
        boolean success = dialog.showDialog();
        if (success) {
            return dialog.getEmailAddress();
        }
        return "";
    }

    public PartnerLink handlePartnerLinkBrowse() {
        return UIUtils.handlePartnerLinkBrowse(this.m_graphPane);
    }

    private static PartnerLink handlePartnerLinkBrowse(BPELGraphPane pane) {
        Process process = ((BPELGraphModel)pane.getModel()).getProcess();
        PartnerLink pl = null;
        PartnerLinkChooser dlg = new PartnerLinkChooser(GraphUtils.getFrame((Component)((Object)pane)), pane, (Activity)process);
        if (dlg.display() == 0) {
            pl = dlg.getSelectedPartnerLink();
        }
        return pl;
    }

    public Variable handleVariableBrowse() {
        return UIUtils.handleVariableBrowse(this.m_graphPane);
    }

    private static Variable handleVariableBrowse(BPELGraphPane pane) {
        Process process = ((BPELGraphModel)pane.getModel()).getProcess();
        Variable v = null;
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)((Object)pane)), pane, (Activity)process);
        if (dlg.display() == 0) {
            v = dlg.getSelectedVariable();
        }
        return v;
    }
}

