/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.ide.util.FileCopyUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.notification.NotificationWizardContext;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PLBinding;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternUtil {
    public static final String ANNOTATION = "annotation";
    public static final String BPELX_NAMESPACE = "http://schemas.oracle.com/bpel/extension";
    public static final String BPELX_PREFIX = "bpelx";
    public static final String PATTERN_NAME_ATTR = "patternName";
    public static final String PATTERN = "bpelx:pattern";

    public static PartnerLink getPLByName(String plName, BPELGraphPane pane) {
        return PatternUtil.getPLByName(plName, (BPELGraphModel)pane.getModel());
    }

    public static PartnerLink getPLByName(String plName, BPELGraphModel model) {
        return PatternUtil.getPLByName(plName, model.getProcess());
    }

    public static PartnerLink getPLByName(String plName, Process processModel) {
        return PatternUtil.getPLByName(plName, processModel.getPartnerLinks());
    }

    public static PartnerLink getPLByName(String plName, PartnerLinks plinks) {
        return PatternUtil.getPLByName(plName, plinks.getPartnerLinks());
    }

    public static PartnerLink getPLByName(String plName, List plinkList) {
        if (plinkList != null && plName != null) {
            for (int i = 0; i < plinkList.size(); ++i) {
                if (!((PartnerLink)plinkList.get(i)).getName().equals(plName)) continue;
                return (PartnerLink)plinkList.get(i);
            }
        }
        return null;
    }

    public static Variable getVarByName(String varName, List varList) {
        if (varList != null && varName != null) {
            for (int i = 0; i < varList.size(); ++i) {
                if (!((Variable)varList.get(i)).getName().equals(varName)) continue;
                return (Variable)varList.get(i);
            }
        }
        return null;
    }

    public static String substitute(Map args, String str) {
        for (String key : args.keySet()) {
            String val = (String)args.get(key);
            int index = str.indexOf(key);
            while (index != -1) {
                str = str.substring(0, index) + val + str.substring(index + key.length(), str.length());
                index = str.indexOf(key);
            }
        }
        return str;
    }

    public static void addWSDLLocation(PLBinding plBinding, PartnerLink pl, BPELGraphPane pane) {
        if (plBinding == null || pl == null) {
            return;
        }
        String wsdlLocation = plBinding.getWSDLLocation();
        if (wsdlLocation == null || wsdlLocation.equals("")) {
            return;
        }
        try {
            URL url = new URL(pane.getBPELProject().getWSDLRoot(), wsdlLocation);
            pane.getBPELProject().addWSDLNode(url);
            pl.setWSDLLocation(url.toExternalForm());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createPLinks(BPELPattern bpelPattern, BPELGraphPane pane) {
        PatternUtil.createPLinks(bpelPattern, pane, null);
    }

    static void firePartnerLinkCreated(PartnerLink plink, Process process, String componentServiceName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutboundPartnerLink", Boolean.TRUE);
        map.put("CompSvcName", componentServiceName);
        process.fireModelChanged((Object)process, 5, (Object)plink, map);
    }

    public static void createPLinks(BPELPattern bpelPattern, BPELGraphPane pane, Map map) {
        BPELGraphModel graphModel = (BPELGraphModel)pane.getModel();
        Process processModel = graphModel.getProcess();
        String plinksText = bpelPattern.getFragment().getPLinks();
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        System.out.println(plinksText);
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        if (plinksText == null) {
            return;
        }
        if (map != null) {
            plinksText = PatternUtil.substitute(map, plinksText);
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(plinksText.getBytes("UTF-8"));
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in);
            XMLDocument doc = parser.getDocument();
            XMLElement docElem = (XMLElement)doc.getDocumentElement();
            NSResolver nsr = BPELPattern.getNSResolver();
            NodeList plinkNodes = docElem.selectNodes("proc:partnerLink", nsr);
            PartnerLinks plinks = processModel.getPartnerLinks();
            ParserContext ct = processModel.createParserContext();
            Document processDoc = processModel.getDOMElement().getOwnerDocument();
            int plinkCount = 0;
            if (plinkNodes != null && (plinkCount = plinkNodes.getLength()) != 0) {
                PLBinding plBinding;
                for (int i = 0; i < plinkCount; ++i) {
                    Element plinkElem = (Element)plinkNodes.item(i);
                    boolean isNewPL = true;
                    plBinding = bpelPattern.getPLBinding(plinkElem.getAttribute("name"));
                    String plName = plinkElem.getAttribute("name");
                    PartnerLink pLink = PatternUtil.getPLByName(plName, plinks);
                    if (pLink == null) {
                        pLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
                    } else {
                        isNewPL = false;
                        if (plBinding.getReplace() == "false") {
                            return;
                        }
                    }
                    Element newPlinkElem = (Element)processDoc.importNode(plinkElem, true);
                    pLink.readFromElement(newPlinkElem, ct);
                    PatternUtil.addWSDLLocation(plBinding, pLink, pane);
                    if (!isNewPL) continue;
                    plinks.addPartnerLink(pLink);
                    PatternUtil.firePartnerLinkCreated(pLink, ((BPELGraphModel)pane.getModel()).getProcess(), NotificationWizardContext.NS_PLINK_NAME);
                }
                processModel.saveToDOMElement();
                DeploymentFile depFile = pane.getBPELProject().getDeploymentFile();
                if (depFile != null) {
                    for (int i = 0; i < plinkCount; ++i) {
                        Element plinkElem = (Element)plinkNodes.item(i);
                        plBinding = bpelPattern.getPLBinding(plinkElem.getAttribute("name"));
                        depFile.getPLProperties(plBinding.getPLName());
                        depFile.setPLProperties(plBinding.getPLName(), plBinding.getPLProperties());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createVars(BPELPattern bpelPattern, BPELGraphPane pane) {
        BPELGraphModel graphModel = (BPELGraphModel)pane.getModel();
        Process processModel = graphModel.getProcess();
        String varText = bpelPattern.getFragment().getVars();
        if (varText == null) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(varText.getBytes("UTF-8"));
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in);
            XMLDocument doc = parser.getDocument();
            XMLElement docElem = (XMLElement)doc.getDocumentElement();
            NSResolver nsr = BPELPattern.getNSResolver();
            NodeList varNodes = docElem.selectNodes("a:variable", nsr);
            ParserContext ct = processModel.createParserContext();
            Document processDoc = processModel.getDOMElement().getOwnerDocument();
            String replace = docElem.getAttribute("replace");
            int varCount = 0;
            if (varNodes != null && (varCount = varNodes.getLength()) != 0) {
                for (int i = 0; i < varCount; ++i) {
                    Element varElem = (Element)varNodes.item(i);
                    boolean isNewVar = true;
                    String varName = varElem.getAttribute("name");
                    Variable var = PatternUtil.getVarByName(varName, processModel.getVariables().getVariables());
                    if (var == null) {
                        var = (Variable)BPELParser.createImplementation(Variable.class);
                    } else {
                        isNewVar = false;
                        if (replace.equals("false")) {
                            return;
                        }
                    }
                    varElem = (Element)processDoc.importNode(varElem, true);
                    var.readFromElement(varElem, ct);
                    if (!isNewVar) continue;
                    processModel.getVariables().addVariable(var);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Element getAnnotationElem(Document doc, Element e, boolean bCreate) {
        NodeList l = e.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            Element elem;
            Node n = l.item(i);
            if (n.getNodeType() != 1 || !(elem = (Element)n).getTagName().endsWith(ANNOTATION)) continue;
            return elem;
        }
        if (!bCreate) {
            return null;
        }
        Element anElem = doc.createElementNS(BPELX_NAMESPACE, "bpelx:annotation");
        if (e.getChildNodes().getLength() > 0) {
            e.insertBefore(anElem, e.getFirstChild());
        } else {
            e.appendChild(anElem);
        }
        return anElem;
    }

    public static Map importNamespaces(BPELPattern pattern, BPELGraphPane pane) {
        Properties properties = pattern.getNSBindings();
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String prefix = (String)enumeration.nextElement();
                String namespace = (String)properties.get(prefix);
                String bpelPrefix = ((BPELGraphModel)pane.getModel()).getProcess().addNamespace(namespace);
                map.put("'${" + prefix + "}':", bpelPrefix + ":");
            }
        }
        return map;
    }

    public static void copyPatternFilesToProject(BPELPattern pattern, BPELGraphPane pane) {
        File patternDir = new File(pattern.getDirURL().getFile());
        String[] files = patternDir.list();
        File wsdlRootDir = new File(pane.getBPELProject().getWSDLRoot().getFile());
        try {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".wsdl") && !files[i].endsWith(".xsd")) continue;
                File file = new File(patternDir, files[i]);
                FileCopyUtil.copyFile((File)file, (File)new File(wsdlRootDir, files[i]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copyFiles(File sourceDir, File targetDir) {
        if (sourceDir == null || targetDir == null) {
            return;
        }
        String srcDirPath = sourceDir.getPath();
        String[] files = sourceDir.list();
        if (files == null) {
            return;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                File file = new File(srcDirPath, files[i]);
                String fileName = file.getPath();
                String relativePath = fileName.substring(srcDirPath.length(), fileName.length());
                File destinationFile = new File(targetDir, relativePath);
                if (file.isDirectory()) {
                    destinationFile.mkdir();
                    PatternUtil.copyFiles(file, destinationFile);
                    continue;
                }
                FileCopyUtil.copyFile((File)file, (File)destinationFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

