/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFilter;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.LabelTextField;

public class FileTextField
extends LabelTextField
implements ActionListener {
    JButton m_browseButton;
    int m_type;
    String[] m_filter;
    String m_tooltip;

    public FileTextField(String label, String tooltip, String[] filter, int type) {
        super(label);
        this.m_browseButton = UIHelper.createBrowseButton((String)this.m_tooltip);
        this.m_browseButton.addActionListener(this);
        this.m_type = type;
        this.m_filter = filter;
        this.m_tooltip = tooltip;
    }

    @Override
    public void addToPanel(Container panel, int row) {
        super.addToPanel(panel, row);
        GraphUtils.addComponent((Container)panel, (Component)this.m_browseButton, (int)2, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_browseButton) {
            URLChooser chooser = DialogUtil.newURLChooser();
            chooser.setSelectionScope(this.m_type);
            int ret = chooser.showOpenDialog((Component)this.m_panel);
            if (this.m_filter != null) {
                chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(this.m_tooltip, this.m_filter));
            }
            if (ret == 0) {
                URL url = chooser.getSelectedURL();
                this.m_textField.setText(url.getFile());
            }
        }
    }
}

