/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.ui.jdev;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternFragment;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternGraph;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.FileTextField;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.LabelTextField;
import org.w3c.dom.Element;

public class CreatePatternDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected BPELPattern m_bpelPattern;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected LabelTextField m_nameField = new LabelTextField("Pattern Name:");
    protected LabelTextField m_idField = new LabelTextField("Pattern Id:");
    protected LabelTextField m_graphNameField = new LabelTextField("Graph Name:");
    protected LabelTextField m_paletteTooltipField = new LabelTextField("Palette Tooltip:");
    protected FileTextField m_paletteImage = new FileTextField("Palette Image File:", "Browse image files", new String[]{".png", ".gif", "*.jpg"}, 0);
    protected FileTextField m_dndImage = new FileTextField("Drag and Drop Image File:", "Browse image files", new String[]{".png", ".gif", "*.jpg"}, 0);
    protected FileTextField m_graphImage = new FileTextField("Graph Image File:", "Browse image files", new String[]{".png", ".gif", "*.jpg"}, 0);
    protected FileTextField m_outputDir = new FileTextField("Output Directory:", "Browse Directories", null, 1);
    protected int m_retVal = 1;
    protected Scope m_scope;

    public CreatePatternDialog(JFrame f, Scope scope) {
        super(f, "Create Pattern", true);
        this.m_scope = scope;
        this.createControls();
        this.layoutControls();
        this.setSize(350, 300);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void createControls() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        this.m_nameField.addToPanel(c, row++);
        this.m_idField.addToPanel(c, row++);
        this.m_graphNameField.addToPanel(c, row++);
        this.m_paletteTooltipField.addToPanel(c, row++);
        this.m_paletteImage.addToPanel(c, row++);
        this.m_graphImage.addToPanel(c, row++);
        this.m_outputDir.addToPanel(c, row++);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)3, (int)1, (int)14, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CreatePatternDialog.this.enableUserInput(true);
            }
        };
        new Thread(r).start();
    }

    protected void updateButtons() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOk();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void handleOk() {
        this.m_bpelPattern = new BPELPattern();
        this.m_bpelPattern.setName(this.m_nameField.getText());
        Element scopeElem = this.m_scope.getDOMElement();
        PatternFragment fragment = null;
        try {
            fragment = new PatternFragment(scopeElem);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_bpelPattern.setPatternFragment(fragment);
        PatternGraph graph = new PatternGraph();
        graph.setGraphName(this.m_graphNameField.getText());
        graph.setTooltip(this.m_paletteTooltipField.getText());
        graph.setPaletteIconFile(this.m_paletteImage.getText());
        graph.setGraphIconFile(this.m_graphImage.getText());
        graph.setDragIconFile(this.m_dndImage.getText());
        graph.setPalettePage("test");
        this.m_bpelPattern.setPatternGraph(graph);
        this.m_bpelPattern.setPatternId(this.m_idField.getText());
        try {
            URL dirURL = URLFactory.newDirURL((String)this.m_outputDir.getText());
            this.m_bpelPattern.setDirURL(dirURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_bpelPattern.register();
        this.m_bpelPattern.save();
        this.m_retVal = 0;
        this.dispose();
    }
}

