/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternConstants;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternField;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.UIUtils;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class UIField
extends PatternField
implements ActionListener {
    JToolBar m_tb;
    JLabel m_label;
    JTextField m_textField;
    JTextArea m_textArea;
    JButton m_varButton;
    JButton m_userButton;
    JButton m_xpathButton;
    JButton m_plButton;
    Activity m_parent;
    UIUtils m_uiutils;
    static int NW = 18;
    static int HR = 2;
    static int NONE = 0;
    static int BOTH = 1;
    Insets m_insets = new Insets(5, 5, 0, 5);
    static ImageIcon s_flashImage = new ImageIcon(UIHelper.loadImage((String)"images/flashlight14.png", UIHelper.class));

    public UIField(PatternField field, UIUtils uiutils) {
        this.m_name = field.getName();
        this.m_default = field.getDefault();
        this.m_labelStr = field.getLabelStr();
        this.b_use = field.isRequired();
        this.m_types = field.getTypes();
        this.m_uiutils = uiutils;
        this.initUI();
    }

    private void initUI() {
        this.m_label = new JLabel(this.m_labelStr);
        this.m_tb = new JToolBar();
        for (String type : this.m_types) {
            if (type.equals(PatternConstants.USER)) {
                this.addUserButton();
                continue;
            }
            if (type.equals(PatternConstants.XPATH)) {
                this.addXPathButton();
                continue;
            }
            if (type.equals(PatternConstants.PARTNERLINK)) {
                this.addPLButton();
                continue;
            }
            if (!type.equals(PatternConstants.VARIABLE)) continue;
            this.addVarButton();
        }
    }

    private void addUserButton() {
        this.m_userButton = new JButton(s_flashImage);
        this.m_userButton.setToolTipText("Select User");
        this.m_userButton.addActionListener(this);
        this.m_tb.add(this.m_userButton);
    }

    private void addXPathButton() {
        this.m_xpathButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_xpathButton.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_xpathButton.addActionListener(this);
        this.m_tb.add(this.m_xpathButton);
    }

    private void addPLButton() {
        this.m_plButton = new JButton(s_flashImage);
        this.m_plButton.setToolTipText("Select Partnerlink");
        this.m_plButton.addActionListener(this);
        this.m_tb.add(this.m_plButton);
    }

    private void addVarButton() {
        this.m_varButton = new JButton(s_flashImage);
        this.m_varButton.setToolTipText("Select Variable");
        this.m_varButton.addActionListener(this);
        this.m_tb.add(this.m_varButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_xpathButton) {
            if (this.isType(PatternConstants.MULTILINE)) {
                this.m_uiutils.handleGraphicBuilderForTextField(this.m_textArea);
            } else {
                this.m_uiutils.handleGraphicBuilderForTextField(this.m_textField);
            }
        } else if (src == this.m_userButton) {
            this.m_textField.setText(this.m_uiutils.startLookupDialog(0));
        } else if (src == this.m_plButton) {
            this.m_textField.setText(this.m_uiutils.handlePartnerLinkBrowse().getName());
        } else if (src == this.m_varButton) {
            this.m_textField.setText(this.m_uiutils.handleVariableBrowse().getName());
        }
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    public JTextField getTextField() {
        return this.m_textField;
    }

    public JTextArea getTextArea() {
        return this.m_textArea;
    }

    public JButton getVarButton() {
        return this.m_varButton;
    }

    public JButton getUserButton() {
        return this.m_userButton;
    }

    public JButton getXPathButton() {
        return this.m_xpathButton;
    }

    public JButton getPLButton() {
        return this.m_plButton;
    }

    public int addToPanel(JPanel panel, int row) {
        JComponent textComponent;
        int col = 0;
        double textYWeight = 0.0;
        int ht = 1;
        int resize = HR;
        UIUtils.add(panel, this.m_label, col++, row, 1, 1, 0.0, 0.0, NW, NONE, this.m_insets);
        if (this.isType(PatternConstants.MULTILINE)) {
            textComponent = this.m_textArea = new JTextArea();
            textComponent = new JScrollPane(textComponent, 20, 30);
            textYWeight = 1.0;
            resize = BOTH;
            ht = 4;
            ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_textArea, (String)this.m_labelStr);
        } else {
            this.m_textField = new JTextField();
            textComponent = this.m_textField;
            ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_textField, (String)this.m_labelStr);
        }
        UIUtils.add(panel, textComponent, col++, row, 1, ht, 1.0, textYWeight, NW, resize, this.m_insets);
        if (this.isType(PatternConstants.XPATH) || this.isType(PatternConstants.USER) || this.isType(PatternConstants.PARTNERLINK) || this.isType(PatternConstants.VARIABLE)) {
            UIUtils.add(panel, this.m_tb, col++, row, 1, 1, 0.0, 0.0, NW, HR, this.m_insets);
        }
        return ht;
    }

    public String getValue() {
        String value = "";
        value = !this.isType(PatternConstants.MULTILINE) ? this.m_textField.getText() : this.m_textArea.getText();
        return this.convertMixedStringToXPathCompliantForm(value);
    }

    private String convertMixedStringToXPathCompliantForm(String value) {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            if (value != null && value.trim().equals("")) {
                value = "<%string('')%>";
            }
            return parser.convertMixedStringToXPathCompliantForm(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
    }

    public void setValue(String val) {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        val = parser.convertXPathComplaintStringToMixedForm(val);
        if (!this.isType(PatternConstants.MULTILINE)) {
            this.m_textField.setText(val);
        } else {
            this.m_textArea.setText(val);
        }
    }

    private boolean isType(String type) {
        for (String typeStr : this.m_types) {
            if (!typeStr.equals(type)) continue;
            return true;
        }
        return false;
    }
}

