/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.ui;

import java.awt.Component;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Pattern;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternHandler;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternManager;
import oracle.tip.tools.ide.pm.modules.uipatterns.model.impl.BPELModelImpl;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternFieldsEditPage;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternNodeEditor
extends AbstractActivityNodeEditor {
    protected EditorPage[] m_pages;

    @Override
    public EditorPage[] getEditorPages(GraphPane pane, oracle.tip.tools.ide.common.graph.model.Node n) {
        if (this.m_pages == null) {
            this.m_pages = new EditorPage[1];
            Pattern pattern = (Pattern)n.getUserObject();
            if (pattern == null) {
                pattern = (Pattern)BPELParser.createImplementation(Pattern.class);
                BPELGraphModel model = (BPELGraphModel)pane.getModel();
                pattern.setName(BPELModelUtil.generateUniqueName((Process)model.getProcess(), (String)n.getName(), Scope.class));
                pattern.setPatternId(n.getName());
            }
            n.setUserObject((Object)pattern);
            this.m_pages[0] = new PatternFieldsEditPage((BPELGraphPane)pane, n);
        }
        return this.m_pages;
    }

    @Override
    public Component getNodeEditorComponent(GraphPane pane, oracle.tip.tools.ide.common.graph.model.Node n) {
        this.m_node = n;
        Pattern pattern = (Pattern)n.getUserObject();
        String activityName = pattern.getName();
        if (pattern != null) {
            PatternHandler handler;
            String patternId = pattern.getPatternId();
            BPELPattern bpelPattern = null;
            if (patternId != null) {
                bpelPattern = PatternManager.getPattern(patternId);
            }
            if (bpelPattern != null && (handler = bpelPattern.getPatternHandler()) != null) {
                Node node = handler.editNode(patternId, null, bpelPattern.getFragment(), pattern.getDOMElement(), new BPELModelImpl((BPELGraphPane)pane));
                Document doc = ((BPELGraphModel)pane.getModel()).getProcess().getDOMElement().getOwnerDocument();
                Element domElement = pattern.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                Node newNode = domElement.getOwnerDocument().importNode(node, true);
                pattern.setDOMElement((Element)newNode);
                BPELGraphModel graphModel = (BPELGraphModel)pane.getModel();
                Process processModel = graphModel.getProcess();
                String prefix = processModel.addNamespace("http://schemas.oracle.com/bpel/jdev/designer");
                ((XMLElement)newNode).setAttributeNS("http://schemas.oracle.com/bpel/jdev/designer", prefix + ":pattern", patternId);
                pattern.readFromElement((Element)newNode, processModel.createParserContext(), true);
                pattern.setName(activityName);
                return null;
            }
        }
        return super.getNodeEditorComponent(pane, n);
    }
}

