/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Pattern;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.PatternNode;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternManager;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternPanel;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternFieldsEditPage
extends BaseEditingPage
implements ActionListener {
    protected Pattern m_activity;
    protected PatternPanel m_panel;
    BPELPattern m_bpelPattern;
    protected String m_patternId;
    PatternNode m_patternNode;
    boolean b_cancelled = false;

    public PatternFieldsEditPage(BPELGraphPane pane, oracle.tip.tools.ide.common.graph.model.Node n) {
        super(pane);
        this.m_patternNode = (PatternNode)n;
        this.m_patternId = ((Pattern)n.getUserObject()).getPatternId();
    }

    protected void createControls() {
        Image image = null;
        this.m_bpelPattern = PatternManager.getPattern(this.m_patternId);
        try {
            String fileName = this.m_bpelPattern.getPatternGraph().getPaletteIconFile();
            URL url = new URL(this.m_bpelPattern.getDirURL(), fileName);
            image = GraphUtils.loadImage((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_activity.setImage(image);
        this.m_panel = this.m_bpelPattern.generatePanel(this.m_graphPane, this.m_activity);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_panel, (int)0, (int)0, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Pattern)model;
        this.createControls();
        this.layoutControls();
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void saveChanges() {
        Map valuesMap = this.m_panel.getValuesMap();
        try {
            Element domElement = this.m_activity.getDOMElement();
            Properties properties = this.m_bpelPattern.getNSBindings();
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String prefix = (String)enumeration.nextElement();
                    String namespace = (String)properties.get(prefix);
                    String bpelPrefix = this.m_processModel.addNamespace(namespace);
                    valuesMap.put("'${" + prefix + "}'", bpelPrefix);
                }
            }
            String prefix = this.m_processModel.addNamespace("http://schemas.oracle.com/bpel/jdev/designer");
            Node node = this.m_bpelPattern.getFragment().createNode(valuesMap);
            Node newNode = domElement.getOwnerDocument().importNode(node, true);
            ((XMLElement)newNode).setAttributeNS("http://schemas.oracle.com/bpel/jdev/designer", prefix + ":pattern", this.m_bpelPattern.getPatternId());
            this.m_activity.setDOMElement((Element)newNode);
            this.m_activity.readFromElement((Element)newNode, this.m_processModel.createParserContext(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void onCancel() {
        this.b_cancelled = true;
    }

    public boolean isCancelled() {
        return this.b_cancelled;
    }

    public oracle.tip.tools.ide.common.graph.model.Node getNode() {
        return this.m_patternNode;
    }
}

