/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns.model.impl;

import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.uipatterns.model.BPELModel;

public class BPELModelImpl
implements BPELModel {
    BPELGraphPane m_pane;

    public BPELModelImpl(BPELGraphPane pane) {
        this.m_pane = pane;
    }

    @Override
    public List getVariables() {
        return ((BPELGraphModel)this.m_pane.getModel()).getProcess().getVariables().getVariables();
    }

    @Override
    public void addVariable(Variable var) {
        ((BPELGraphModel)this.m_pane.getModel()).getProcess().getVariables().addVariable(var);
    }

    @Override
    public void removeVariable(Variable var) {
        ((BPELGraphModel)this.m_pane.getModel()).getProcess().getVariables().deleteVariable(var);
    }

    @Override
    public List getPartnerLinks() {
        return ((BPELGraphModel)this.m_pane.getModel()).getProcess().getPartnerLinks().getPartnerLinks();
    }

    @Override
    public void addPartnerLink(PartnerLink pl) {
        ((BPELGraphModel)this.m_pane.getModel()).getProcess().getPartnerLinks().addPartnerLink(pl);
    }

    @Override
    public void removePartnerLink(String plName) {
        Process proc = ((BPELGraphModel)this.m_pane.getModel()).getProcess();
        PartnerLink pl = BPELModelUtil.getPartnerLinkByName((String)plName, (Process)proc);
        this.removePartnerLink(pl);
    }

    @Override
    public void removePartnerLink(PartnerLink pl) {
        ((BPELGraphModel)this.m_pane.getModel()).getProcess().deletePartnerLink(pl);
    }

    @Override
    public List getPLProperties(PartnerLink pl) {
        List propList = null;
        BPELGraphModel model = (BPELGraphModel)this.m_pane.getModel();
        DeploymentFile depFile = model.getBPELProject().getDeploymentFile();
        if (depFile != null) {
            propList = depFile.getPLProperties(pl.getName());
        }
        return propList;
    }

    @Override
    public void addPLProperties(PartnerLink pl, PLProperties plProperties) {
        BPELGraphModel model = (BPELGraphModel)this.m_pane.getModel();
        DeploymentFile depFile = model.getBPELProject().getDeploymentFile();
        if (depFile != null) {
            depFile.addPLProperties(pl.getName(), plProperties.m_name, plProperties.m_value, plProperties.m_type);
        }
    }

    @Override
    public void removePLProperties(PartnerLink pl, String propertyName) {
        BPELGraphModel model = (BPELGraphModel)this.m_pane.getModel();
        DeploymentFile depFile = model.getBPELProject().getDeploymentFile();
        if (depFile != null) {
            depFile.removePLProperties(pl.getName(), propertyName);
        }
    }

    @Override
    public void removePLProperties(PartnerLink pl, PLProperties plProperties) {
        this.removePLProperties(pl, plProperties.m_name);
    }

    @Override
    public Variable createNewVariable() {
        return (Variable)BPELParser.createImplementation(Variable.class);
    }

    @Override
    public PartnerLink createNewPartnerLink() {
        return (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
    }

    @Override
    public JFrame getFrame() {
        return GraphUtils.getFrame((Component)((Object)this.m_pane));
    }
}

