/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.ide.Ide;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.PatternXML;

public class PatternManager {
    private static Hashtable s_patterns = new Hashtable();

    public static void loadPatterns() {
        File ideHomeDir = new File(Ide.getHomeDirectory());
        File ideRootDir = ideHomeDir.getParentFile();
        File patternsDir = new File(ideRootDir, "integration/bpm/pattern");
        PatternManager.loadPatterns(patternsDir);
    }

    private static void loadPatterns(File patternsDir) {
        if (s_patterns.size() > 0) {
            Collection patterns = s_patterns.values();
            for (BPELPattern pattern : patterns) {
                pattern.register();
            }
            return;
        }
        ArrayList fileList = new ArrayList();
        PatternManager.getFileList(patternsDir, fileList);
        File patternFile = null;
        for (int i = 0; i < fileList.size(); ++i) {
            try {
                patternFile = new File((String)fileList.get(i));
                BPELPattern bpelPattern = PatternXML.load(patternFile.toURL());
                bpelPattern.register();
                s_patterns.put(bpelPattern.getPatternId(), bpelPattern);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error reading pattern file:\n" + patternFile + "See stacktrace below.");
                ex.printStackTrace();
            }
        }
    }

    private static void getFileList(File dirFile, List fileList) {
        if (dirFile == null || fileList == null) {
            return;
        }
        String[] files = dirFile.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dirFile, files[i]);
            if (file.isDirectory()) {
                PatternManager.getFileList(file, fileList);
                continue;
            }
            if (!files[i].equalsIgnoreCase("pattern_old.xml")) continue;
            fileList.add(dirFile.getPath() + File.separator + files[i]);
        }
    }

    public static BPELPattern getPattern(String patternName) {
        return (BPELPattern)s_patterns.get(patternName);
    }

    public static boolean isPatternPage(String pageName) {
        Enumeration e = s_patterns.elements();
        if (e != null && e.hasMoreElements()) {
            BPELPattern pattern = (BPELPattern)e.nextElement();
            return pageName.equals(pattern.getPatternGraph().getPalettePage());
        }
        return false;
    }
}

