/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternFragmentUtil {
    private static boolean m_bInit;
    private static final char[] m_bLock;
    private static final String CHAR_ENC = "UTF-8";
    private static final String PATTERN_FILE_NAME = "pattern.xml";
    private static final String FRAGMENT_TAG_NAME = "fragment";
    private static final String FIELDS_TAG_NAME = "fields";
    private static final String PALETTE_TAG_NAME = "palette";
    private static final String[] dirArray;
    private static final Map m_fragmentMap;
    private static final Map m_fieldsMap;
    private static final Map m_patternsMap;
    static DOMParser s_domParser;

    private PatternFragmentUtil() {
    }

    public static Node getPatternFragementNode(String patternName, Map args) throws Exception {
        PatternFragmentUtil.init();
        Node retNode = (Node)m_fragmentMap.get(patternName);
        if (retNode != null && args != null && args.size() > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLPrintDriver driver = new XMLPrintDriver((OutputStream)out);
            driver.setEncoding(CHAR_ENC);
            if (!(retNode instanceof XMLElement)) {
                throw new Exception("Fragement has to be an XML element.");
            }
            driver.printElement((XMLElement)retNode);
            Iterator it = args.keySet().iterator();
            String retStr = out.toString(CHAR_ENC);
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)args.get(key);
                int index = retStr.indexOf(key);
                while (index != -1) {
                    retStr = retStr.substring(0, index) + val + retStr.substring(index + key.length(), retStr.length());
                    index = retStr.indexOf(key);
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(retStr.getBytes(CHAR_ENC));
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in);
            retNode = parser.getDocument().getDocumentElement();
        }
        return retNode;
    }

    public static Node getPatternFieldsNode(String patternName) throws Exception {
        return PatternFragmentUtil.getPatternFieldsNode(patternName, false);
    }

    public static Node getPatternFieldsNode(String patternName, boolean force) throws Exception {
        PatternFragmentUtil.init(force);
        return (Node)m_fieldsMap.get(patternName);
    }

    private static void init() throws Exception {
        PatternFragmentUtil.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init(boolean force) throws Exception {
        if (m_bInit && !force) return;
        char[] cArray = m_bLock;
        synchronized (m_bLock) {
            PatternFragmentUtil.loadPatterns(PatternFragmentUtil.getPatternDirectory());
            m_bInit = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void loadPatterns(String dir) throws Exception {
        ArrayList fileList = new ArrayList();
        PatternFragmentUtil.getFileList(dir, fileList);
        DOMParser parser = new DOMParser();
        for (int i = 0; i < fileList.size(); ++i) {
            URL url = (URL)fileList.get(i);
            parser.parse(url);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            NodeList nl = docElem.getChildNodes();
            String patternName = docElem.getAttribute("name");
            if (nl.getLength() <= 0) continue;
            Node fragment = null;
            Node fields = null;
            Node palette = null;
            for (int j = 0; j < nl.getLength(); ++j) {
                Node n = nl.item(j);
                String nodeName = n.getNodeName();
                if (n.getNodeType() != 1 || nodeName == null) continue;
                if (FRAGMENT_TAG_NAME.equals(nodeName)) {
                    NodeList nl1 = n.getChildNodes();
                    for (int k = 0; k < nl.getLength(); ++k) {
                        Node n1 = nl1.item(k);
                        if (n1.getNodeType() != 1) continue;
                        fragment = n1;
                        break;
                    }
                    fragment = n;
                    continue;
                }
                if (FIELDS_TAG_NAME.equals(nodeName)) {
                    fields = n;
                    continue;
                }
                if (!PALETTE_TAG_NAME.equals(nodeName)) continue;
                palette = n;
            }
        }
    }

    private static void getFileList(String dir, List fileList) throws Exception {
        if (dir == null || dir.equals("")) {
            return;
        }
        File dirFile = new File(dir);
        String[] fl = dirFile.list();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fl.length; ++i) {
            File file = new File(dir, fl[i]);
            if (file.isDirectory()) {
                PatternFragmentUtil.getFileList(file.getPath(), fileList);
                continue;
            }
            if (!fl[i].equalsIgnoreCase(PATTERN_FILE_NAME)) continue;
            fileList.add(new File(dirFile.getPath(), fl[i]).toURL());
        }
    }

    public static String getPatternDirectory() {
        File file = new File(Ide.getHomeDirectory());
        file = file.getParentFile();
        for (int i = 0; i < dirArray.length; ++i) {
            file = new File(file, dirArray[i]);
        }
        return file.getAbsolutePath();
    }

    static {
        m_bLock = new char[0];
        dirArray = new String[]{"integration", "bpm", "pattern"};
        m_fragmentMap = new HashMap();
        m_fieldsMap = new HashMap();
        m_patternsMap = new HashMap();
        s_domParser = new DOMParser();
    }
}

