/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.PatternXML;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternFragment {
    String m_fragment;
    String m_plinks;
    List m_plinkList = new ArrayList();
    String m_vars;

    public PatternFragment(Element fragmentElem) {
        try {
            Node scopeNode;
            Node varNode;
            String nodeName = fragmentElem.getNodeName();
            if (fragmentElem.getNodeName().endsWith("scope")) {
                this.m_fragment = PatternXML.getFragmentStr((XMLElement)fragmentElem);
                return;
            }
            NSResolver nsr = BPELPattern.getNSResolver();
            Node plinksNode = ((XMLElement)fragmentElem).selectSingleNode("proc:partnerLinks", nsr);
            if (plinksNode != null) {
                NodeList nodeList = ((XMLElement)plinksNode).selectNodes("proc:partnerLink", nsr);
                int plinkCount = 0;
                if (nodeList != null && (plinkCount = nodeList.getLength()) != 0) {
                    for (int i = 0; i < plinkCount; ++i) {
                        this.m_plinkList.add(PatternXML.getFragmentStr((XMLElement)nodeList.item(i)));
                    }
                }
                this.m_plinks = PatternXML.getFragmentStr((XMLElement)plinksNode);
            }
            if ((varNode = ((XMLElement)fragmentElem).selectSingleNode("proc:variables", nsr)) != null) {
                this.m_vars = PatternXML.getFragmentStr((XMLElement)varNode);
            }
            if ((scopeNode = ((XMLElement)fragmentElem).selectSingleNode("proc:scope", nsr)) != null) {
                this.m_fragment = PatternXML.getFragmentStr((XMLElement)scopeNode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Node getDOMElement(Document doc) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.m_fragment.getBytes("UTF-8"));
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in);
            Node fragmentNode = parser.getDocument().getDocumentElement();
            if (doc != null) {
                fragmentNode = doc.importNode(fragmentNode, true);
            }
            return fragmentNode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Map getFields(Node node) {
        if (node == null) {
            return null;
        }
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        String xpath = "";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.m_fragment.getBytes("UTF-8"));
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in);
            Element fragmentNode = parser.getDocument().getDocumentElement();
            NodeList fieldNodes = ((XMLNode)fragmentNode).selectNodes("//*[@*[starts-with(.,\"'${\")]]");
            if (fieldNodes == null || fieldNodes.getLength() == 0) {
                System.out.println("error: fragment has no substitution parameters");
                return null;
            }
            block2: for (int i = 0; i < fieldNodes.getLength(); ++i) {
                Node fieldNode = fieldNodes.item(i);
                String field = "";
                String val = "";
                NamedNodeMap map = fieldNode.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    Node attrNode = map.item(j);
                    field = attrNode.getNodeValue();
                    if (!field.startsWith("'${")) continue;
                    xpath = BPELPattern.getXPath(attrNode);
                    Node valueNode = ((XMLNode)node).selectSingleNode(xpath, BPELPattern.getNSResolver());
                    if (valueNode == null) continue block2;
                    val = valueNode.getNodeValue();
                    fieldsMap.put(field, val);
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fieldsMap;
    }

    public Node createNode(Map args) throws Exception {
        Iterator it = args.keySet().iterator();
        String retStr = this.m_fragment;
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)args.get(key);
            int index = retStr.indexOf(key);
            while (index != -1) {
                retStr = retStr.substring(0, index) + val + retStr.substring(index + key.length(), retStr.length());
                index = retStr.indexOf(key);
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(retStr.getBytes("UTF-8"));
        DOMParser parser = new DOMParser();
        parser.parse((InputStream)in);
        return parser.getDocument().getDocumentElement();
    }

    public String getPLinks() {
        return this.m_plinks;
    }

    public String getVars() {
        return this.m_vars;
    }
}

