/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.uipatterns;

import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Pattern;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.uipatterns.PLBinding;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternBinding;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternFragment;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternHandler;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternNSResolver;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternField;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternGraph;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternPanel;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.UIField;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.jdev.PatternPaletteContext;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.UIUtils;
import oracle.tip.tools.ide.pm.modules.uipatterns.xml.PatternXML;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPELPattern {
    URL m_dirURL;
    String m_name;
    List m_fieldList;
    PatternFragment m_fragment;
    PatternGraph m_patternGraph;
    String m_patternId;
    PatternBinding m_binding = null;
    Map m_plBindings = null;
    Properties m_nsBindings = null;
    private static final NSResolver nsr = new PatternNSResolver();

    public void setPLBindings(Map map) {
        this.m_plBindings = map;
    }

    public Map getPLBindings() {
        return this.m_plBindings;
    }

    public PLBinding getPLBinding(String plName) {
        if (this.m_plBindings == null) {
            return null;
        }
        return (PLBinding)this.m_plBindings.get(plName);
    }

    public void setNSBindings(Properties properties) {
        this.m_nsBindings = properties;
    }

    public Properties getNSBindings() {
        return this.m_nsBindings;
    }

    public String getNSBinding(String prefix) {
        if (this.m_nsBindings == null) {
            return null;
        }
        return (String)this.m_nsBindings.get(prefix);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setPatternFragment(PatternFragment frag) {
        this.m_fragment = frag;
    }

    public PatternFragment getFragment() {
        return this.m_fragment;
    }

    public void setPatternGraph(PatternGraph graph) {
        this.m_patternGraph = graph;
    }

    public Image getIcon(String iconFile) {
        Image image = null;
        try {
            URL url = new URL(this.m_dirURL, iconFile);
            image = GraphUtils.loadImage((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public void setFieldList(List fieldList) {
        this.m_fieldList = fieldList;
    }

    public void setDirURL(URL dirURL) {
        this.m_dirURL = dirURL;
    }

    public URL getDirURL() {
        return this.m_dirURL;
    }

    public void setPatternId(String patternId) {
        this.m_patternId = patternId;
    }

    public String getPatternId() {
        return this.m_patternId;
    }

    public void register() {
        if (this.m_patternGraph == null) {
            return;
        }
        PaletteManager paletteManager = PaletteManager.getPaletteManager();
        String pageName = this.m_patternGraph.getPalettePage();
        PalettePage palettePage = this.getPage(pageName);
        ArrayList paletteItems = palettePage.getPaletteItems();
        if (paletteItems != null) {
            for (int i = 0; i < paletteItems.size(); ++i) {
                PaletteItem pItem = (PaletteItem)paletteItems.get(i);
                if (!pItem.getShortLabel().equals(this.m_patternGraph.getGraphName())) continue;
                return;
            }
        }
        String imageFileName = this.m_dirURL.getFile() + this.m_patternGraph.getPaletteIconFile();
        String graphName = this.m_patternGraph.getGraphName();
        palettePage.addPaletteItem(imageFileName, this.m_patternId, false, "this is a test", graphName, "bpm", null, null);
    }

    private PalettePage getPage(String pageName) {
        PaletteManager paletteManager = PaletteManager.getPaletteManager();
        PalettePage palettePage = paletteManager.getPage(pageName);
        if (palettePage == null) {
            palettePage = paletteManager.getPalette().addPage(pageName, "bpm", "bpm", false, true, false);
            palettePage.setPaletteContext(PatternPaletteContext.class.getName());
        }
        return palettePage;
    }

    public PatternGraph getPatternGraph() {
        return this.m_patternGraph;
    }

    public PatternPanel generatePanel(BPELGraphPane pane, Pattern pattern) {
        PatternPanel panel = new PatternPanel(pane, (Activity)pattern);
        try {
            UIUtils uiutils = new UIUtils(pane, (Activity)pattern);
            if (this.m_fieldList != null) {
                for (int i = 0; i < this.m_fieldList.size(); ++i) {
                    PatternField field = (PatternField)this.m_fieldList.get(i);
                    UIField uiField = new UIField(field, uiutils);
                    panel.add(uiField);
                    this.setFieldValue(uiField, pattern);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return panel;
    }

    private void setFieldValue(UIField uiField, Pattern pattern) {
        String placeHolder = "'${" + uiField.getName() + "}'";
        try {
            Node scopeNode = this.m_fragment.createNode(new HashMap());
            NodeList fieldNodes = ((XMLNode)scopeNode).selectNodes("//*[@*[starts-with(.,\"" + placeHolder + "\")]]");
            if (fieldNodes == null || fieldNodes.getLength() != 1) {
                System.out.println("error BPELPattern.java, setFieldValue(), the filename node count is incorrect.");
                System.out.println("Fieldname is: " + uiField.getName());
                return;
            }
            Node fieldNode = fieldNodes.item(0);
            NamedNodeMap map = fieldNode.getAttributes();
            String xpath = "";
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrNode = map.item(i);
                if (!attrNode.getNodeValue().equals(placeHolder)) continue;
                xpath = BPELPattern.getXPath(attrNode);
            }
            XMLNode patternNode = (XMLNode)pattern.getDOMElement();
            Node bpelNode = patternNode.selectSingleNode(xpath, nsr);
            if (fieldNode == null) {
                System.out.println("error");
                return;
            }
            String val = "";
            if (bpelNode != null) {
                val = bpelNode.getNodeValue();
            }
            uiField.setValue(val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getXPath(Node node) {
        String xpath = "";
        if (node.getNodeType() == 2) {
            xpath = "/@" + node.getNodeName();
            node = ((Attr)node).getOwnerElement();
        }
        Node parentNode = node.getParentNode();
        while (parentNode != null) {
            String nodeName = node.getNodeName();
            int nodePos = 0;
            if (parentNode.getNodeType() == 9) {
                xpath = xpath.substring(1);
            } else {
                NodeList siblings = ((Element)parentNode).getElementsByTagName(nodeName);
                for (nodePos = 0; nodePos < siblings.getLength() && siblings.item(nodePos) != node; ++nodePos) {
                }
                xpath = "/proc:" + nodeName + "[" + ++nodePos + "]" + xpath;
            }
            node = parentNode;
            parentNode = node.getParentNode();
        }
        return xpath;
    }

    public PatternHandler getPatternHandler() {
        if (this.m_binding == null) {
            return null;
        }
        return this.m_binding.getPatternHandler();
    }

    public void setBinding(PatternBinding binding) {
        this.m_binding = binding;
    }

    public static NSResolver getNSResolver() {
        return nsr;
    }

    public void save() {
        PatternXML.save(this);
    }
}

