/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.util;

import java.awt.Component;
import java.net.URL;
import javax.xml.namespace.QName;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;

public class SCAProcessBuilderUtil {
    public static void createSCAComponents(ProcessData processData, BPELProject bpelProject, SCAProject m_scaProject, Project m_project) {
        String id = processData.m_templateID;
        String m_processName = processData.m_processName;
        if ("BPEL_ASYNC_PROCESS".equals(id) || "BPEL_SYNC_PROCESS".equals(id) || "BPEL_ONE_WAY_PROCESS".equals(id) || "BPEL_BASE_ON_WSDL".equals(id)) {
            try {
                QName requester;
                QName provider;
                URL u = null;
                if (!id.equals("BPEL_BASE_ON_WSDL")) {
                    u = URLFactory.newURL((URL)bpelProject.getWSDLRoot(), (String)(m_processName + ".wsdl"));
                    provider = new QName(processData.m_namespace, processData.m_processName);
                    requester = null;
                    if ("BPEL_ASYNC_PROCESS".equals(id)) {
                        requester = new QName(processData.m_namespace, processData.m_processName + "Callback");
                    }
                } else {
                    u = processData.m_wsdlURL;
                    provider = processData.m_inputPortQName;
                    requester = processData.m_outputPortQName;
                }
                String relativeURL = URLFileSystem.toRelativeSpec((URL)u, (URL)m_scaProject.getSCARoot());
                JDevSCAIntegrationUtil.createInboundComponentAndService(m_project, m_processName, "bpel", m_processName + ".bpel", processData.m_serviceName, relativeURL, provider, requester, processData.m_bExportAsService);
                JDevSCAIntegrationUtil.saveSCAComposite(m_project, m_processName);
            }
            catch (Exception ex) {
                GraphUtils.displayError((Component)Ide.getMainWindow(), (Throwable)ex);
            }
        } else if ("BPEL_EMPTY_PROCESS".equals(id)) {
            try {
                JDevSCAIntegrationUtil.createComponent(m_project, m_processName, "bpel", m_processName + ".bpel");
                JDevSCAIntegrationUtil.saveSCAComposite(m_project, m_processName);
            }
            catch (Exception ex) {
                GraphUtils.displayError((Component)Ide.getMainWindow(), (Throwable)ex);
            }
        } else if ("SUBSCRIBE_EVENTS".equals(id)) {
            try {
                JDevSCAIntegrationUtil.createComponent(m_project, m_processName, "bpel", m_processName + ".bpel");
                if (processData.m_eventInfo != null) {
                    for (int i = 0; i < processData.m_eventInfo.length; ++i) {
                        JDevSCAIntegrationUtil.createPubSubEvent(m_project, m_processName, processData.m_eventInfo[i], null, false);
                    }
                }
                JDevSCAIntegrationUtil.addWSDLToComposite(m_project, m_processName + ".wsdl");
                JDevSCAIntegrationUtil.saveSCAComposite(m_project, m_processName);
            }
            catch (Exception ex) {
                GraphUtils.displayError((Component)Ide.getMainWindow(), (Throwable)ex);
            }
        }
    }
}

