/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkTypeInfo;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.model.SCABaseObject;
import oracle.tip.tools.ide.fabric.model.SCAComponent;
import oracle.tip.tools.ide.fabric.model.SCAComponentType;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAImports;
import oracle.tip.tools.ide.fabric.model.SCAReference;
import oracle.tip.tools.ide.fabric.model.SCAService;
import oracle.tip.tools.ide.fabric.model.SCAWSDLOperation;
import oracle.tip.tools.ide.fabric.model.WSDLInterface;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;

public class SCAPartnerlinkInfo {
    public String m_scaName = null;
    public int m_scaMask = -1;
    public String m_sPartnerlinkTypeName = null;
    public String m_myRoleName = null;
    public String m_partnerRolenName = null;
    public URL m_wsdlURL = null;
    public boolean m_bIsNotImport = true;
    public SCABaseObject m_scaObject = null;
    boolean m_bOutOfProject = false;

    public static SCAPartnerlinkInfo handleSCAObject(Object returnVal, BPELProject prj) {
        SCAPartnerlinkInfo plinfo = new SCAPartnerlinkInfo();
        plinfo.handleSCAObjects(returnVal, prj);
        return plinfo;
    }

    public void handleSCAObjects(Object returnVal, BPELProject prj) {
        if (returnVal instanceof SCABaseObject) {
            SCAComponent comp;
            SCABaseObject p;
            if (returnVal instanceof SCAWSDLOperation && (p = ((SCABaseObject)returnVal).getOwnerObject()) != null) {
                returnVal = p.getOwnerObject();
            }
            this.m_bOutOfProject = SCAPartnerlinkInfo.isOutOfProject((SCABaseObject)returnVal, prj);
            if (this.m_bOutOfProject) {
                // empty if block
            }
            if (returnVal instanceof SCAReference) {
                SCAReference ref = (SCAReference)returnVal;
                WSDLInterface int_face = (WSDLInterface)ref.getReferenceInterface();
                this.m_scaName = ref.getName();
                this.m_scaMask &= 0xFFFFFFFD;
                this.processSCAInterface(int_face, ref.getName(), (SCABaseObject)ref, prj);
            } else if (returnVal instanceof SCAService) {
                SCAService svr = (SCAService)returnVal;
                WSDLInterface int_face = (WSDLInterface)svr.getServiceInterface();
                this.m_scaName = svr.getName();
                if (!this.m_bOutOfProject) {
                    this.m_scaMask &= 0xFFFFFFFD;
                }
                this.processSCAInterface(int_face, svr.getName(), (SCABaseObject)svr, prj);
            } else if (returnVal instanceof SCAComponent) {
                comp = (SCAComponent)returnVal;
                List refs = comp.getComponentType().getReferences();
                List srvs = comp.getComponentType().getServices();
                if (srvs.size() > 0) {
                    SCAService svr = (SCAService)srvs.get(0);
                    WSDLInterface int_face = (WSDLInterface)svr.getServiceInterface();
                    this.m_scaName = svr.getName();
                    this.m_scaMask &= 0xFFFFFFFD;
                    this.processSCAInterface(int_face, svr.getName(), (SCABaseObject)svr, prj);
                }
            } else if (returnVal instanceof SCAComposite) {
                comp = (SCAComposite)returnVal;
                List refs = comp.getReferences();
                List srvs = comp.getServices();
                if (srvs.size() > 0) {
                    SCAService svr = (SCAService)srvs.get(0);
                    WSDLInterface int_face = (WSDLInterface)svr.getServiceInterface();
                    this.m_scaName = svr.getName();
                    this.m_scaMask &= 0xFFFFFFFD;
                    this.processSCAInterface(int_face, svr.getName(), (SCABaseObject)svr, prj);
                }
            } else if (returnVal instanceof SCAImports) {
                String wsdlLoc = ((SCAImports)returnVal).getLocation();
                URL projURL = prj.getBPELDirectoryURL();
                this.m_wsdlURL = URLFactory.newURL((URL)projURL, (String)wsdlLoc);
                this.m_bIsNotImport = false;
            }
        }
    }

    public static boolean isOutOfProject(SCABaseObject sca, BPELProject prj) {
        String dir2;
        SCABaseObject parent;
        for (parent = sca; !(parent instanceof SCAComposite) && parent != null; parent = parent.getOwnerObject()) {
        }
        if (parent == null) {
            return false;
        }
        SCAComposite comp = (SCAComposite)parent;
        String dir1 = prj.getProjectURL().toExternalForm();
        boolean ret = !dir1.equals(dir2 = comp.getHomeDirectory());
        return ret;
    }

    public void processSCAInterface(WSDLInterface int_face, String partnerLinkName, SCABaseObject ref, BPELProject prj) {
        this.m_scaObject = ref;
        String pt = null;
        String callback_pt = null;
        String ns = null;
        String callbackNS = null;
        if (int_face != null) {
            URI intf1 = int_face.getInterfaceURI();
            URI callInf = int_face.getCallbackInterfaceURI();
            if (intf1 != null) {
                pt = intf1.getFragment();
                pt = pt.substring(pt.indexOf(40) + 1, pt.indexOf(41));
                ns = intf1.getSchemeSpecificPart().substring(2);
            }
            if (callInf != null) {
                callback_pt = callInf.getFragment();
                callback_pt = callback_pt.substring(callback_pt.indexOf(40) + 1, callback_pt.indexOf(41));
                callbackNS = callInf.getSchemeSpecificPart().substring(2);
            }
        } else {
            SCAComposite comp = (SCAComposite)ref.getOwnerObject();
            return;
        }
        String wsLoc = null;
        Project project = (Project)prj.getProjectContext();
        SCAController ctl = JDevSCAIntegrationUtil.getSCAController(project);
        SCABaseObject parent = ref.getOwnerObject();
        String linkName = partnerLinkName;
        String name = "";
        if (parent instanceof SCAComponentType) {
            name = ((SCAComponent)parent.getOwnerObject()).getName();
        } else if (parent instanceof SCAComposite) {
            name = partnerLinkName;
            linkName = null;
        }
        URL url = null;
        if (ref instanceof SCAReference) {
            url = ((SCAReference)ref).getWsdlUrl();
        } else if (ref instanceof SCAService) {
            url = ((SCAService)ref).getWsdlUrl();
        }
        try {
            wsLoc = url.toString();
            this.m_wsdlURL = url;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        PartnerLinkTypeInfo link = null;
        PartnerLinkTypeInfo.PartnerRolePortType partnerRole = null;
        PartnerLinkTypeInfo.PartnerRolePortType[] roles = null;
        boolean found = false;
        int index = 0;
        try {
            PartnerLinkTypeInfo[] pls = WSDLUtil.getPartLinkData((URI)new URI(URIUtil.escapeURIString((String)wsLoc)));
            if (pls != null) {
                for (int i = 0; i < pls.length; ++i) {
                    link = pls[i];
                    roles = link.getRole();
                    for (int j = 0; j < roles.length; ++j) {
                        if (!roles[j].getType().equals(pt)) continue;
                        found = true;
                        partnerRole = roles[j];
                        index = j;
                        break;
                    }
                    if (found) break;
                }
            }
            if (found) {
                this.m_partnerRolenName = partnerRole.getName();
                int n = index = index == 0 ? 1 : 0;
                if (roles.length > 1) {
                    this.m_myRoleName = roles[index].getName();
                }
                this.m_sPartnerlinkTypeName = link.getName();
            } else if (!found) {
                String roleName;
                ArrayList<PartnerLinkType> list = new ArrayList<PartnerLinkType>();
                Definition def = WSDLUtil.parseWSDLDocument((URI)new URI(URIUtil.escapeURIString((String)url.toExternalForm())));
                String ns2 = def.getQName().getNamespaceURI();
                QName qname = new QName(ns2, partnerLinkName);
                PartnerLinkType pltype = new PartnerLinkType(qname);
                this.m_sPartnerlinkTypeName = qname.toString();
                this.m_partnerRolenName = roleName = pt;
                PortType portType = def.getPortType(new QName(ns2, pt));
                Role role = new Role(roleName, portType);
                pltype.getRoles().put(roleName, role);
                if (callback_pt != null) {
                    roleName = callback_pt;
                    portType = def.getPortType(new QName(ns2, callback_pt));
                    role = new Role(roleName, portType);
                    pltype.getRoles().put(roleName, role);
                    this.m_myRoleName = callback_pt;
                }
                list.add(pltype);
                String newWSDL = PartnerLinkWSDLUtil.createWSDLAddPLTypes((BPELProject)prj, null, (String)URIUtil.escapeURIString((String)url.toExternalForm()), list, (boolean)true);
                this.m_wsdlURL = new URL(newWSDL);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (parent instanceof SCAComponentType) {
            name = ((SCAComponent)parent.getOwnerObject()).getName();
            this.m_scaName = name + "/" + this.m_scaName;
        } else if (parent instanceof SCAComposite && this.m_bOutOfProject) {
            name = ((SCAComposite)parent).getName();
            this.m_scaName = name + "_" + this.m_scaName;
        }
    }
}

