/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resourcepicker.uddi.UDDIService;
import oracle.tip.tools.ide.common.sca.SOAProjectSettings;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xsdgrammar.GrammarInfo;
import oracle.tip.tools.ide.events.util.EventsObject;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.BindingInfo;
import oracle.tip.tools.ide.fabric.api.EventInfo;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerBindingImpl;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.SCAInvalidFileNameException;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAException;

public class JDevSCAIntegrationUtil {
    public static final int NEUTRAL_COMP_TYPE = 0;
    public static final int INBOUND_COMP_TYPE = 1;
    public static final int OUTBOUND_COMP_TYPE = 2;
    public static final int UNDEFINED = -1;
    public static final int SERVICE = 0;
    public static final int REFERENCE = 1;
    private static final String UDDI_SERVICE_KEY_PROPERTY_NAME = "oracle.soa.uddi.serviceKey";

    public static boolean isNameUniqueWithinComposite(Project project, String name) throws SCAException {
        try {
            return JDevSCAIntegrationUtil.getSCAController(project).isNameUniqueWithinComposite(name);
        }
        catch (SCAInvalidFileNameException sce) {
            throw new SCAException((Exception)((Object)sce));
        }
    }

    public static boolean isNameUniqueWithinComposite(BPELProject project, String name) throws SCAException {
        return JDevSCAIntegrationUtil.isNameUniqueWithinComposite((Project)project.getProjectContext(), name);
    }

    public static void createComponent(Project project, String componentName, String componentType, String definitionInfo) throws SCAException {
        try {
            SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
            c.createComponent(componentName, componentType, definitionInfo);
        }
        catch (SCAInvalidFileNameException sce) {
            throw new SCAException((Exception)((Object)sce));
        }
    }

    public static void createInboundComponentAndService(Project project, String componentName, String componentType, String definitionInfo, String serviceName, String wsdlLocation, QName provider, QName requester, boolean isEntryService) throws SCAException {
        try {
            SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
            WsdlInfo wsdlInfo = new WsdlInfo(wsdlLocation, provider, requester);
            c.createComponent(componentName, componentType, definitionInfo, serviceName, (InterfaceInfo)wsdlInfo);
            if (isEntryService) {
                String sourceName = c.addServiceEntrypoint(componentName, serviceName + "_ep", (InterfaceInfo)wsdlInfo);
                c.addWire(sourceName, null, componentName + "/" + serviceName, null);
            }
        }
        catch (SCAInvalidFileNameException sce) {
            throw new SCAException((Exception)((Object)sce));
        }
    }

    public static void createService(Project project, String componentName, String serviceName, String wsdlLocation, QName provider, QName requester) {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = new WsdlInfo(wsdlLocation, provider, requester);
        c.addService(componentName, serviceName, (InterfaceInfo)wsdlInfo);
    }

    public static void createServiceFromPartnerLink(Project project, String componentName, String serviceName, PartnerLink pl, int mask, boolean isService) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, isService);
        if (wsdlInfo == null) {
            return;
        }
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (c.isNameUniqueWithinComponent(componentName, serviceName)) {
            c.addService(componentName, serviceName, (InterfaceInfo)wsdlInfo);
        } else {
            c.updateService(componentName, serviceName, serviceName, (InterfaceInfo)wsdlInfo);
        }
    }

    public static void partnerLinkReferenceToBPELService(Project project, String componentName, PartnerLink pl, String targetName, int mask) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null) {
            return;
        }
        c.addWire(targetName, null, componentName, pl.getName());
    }

    public static void serviceEntryToBPELService(Project project, String componentName, PartnerLink pl, String targetName, int mask) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null) {
            return;
        }
        String uniqueName = c.addServiceEntrypoint(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        c.addWire(uniqueName, null, componentName, pl.getName());
    }

    public static void partnerLinkReferenceToComponentService(Project project, String componentName, PartnerLink pl, String targetName, String targetSrcName, int mask) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null) {
            return;
        }
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (c.isNameUniqueWithinComponent(componentName, pl.getName())) {
            c.addReference(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        } else {
            c.updateReference(componentName, pl.getName(), pl.getName(), (InterfaceInfo)wsdlInfo);
        }
        if (targetSrcName == null) {
            targetSrcName = pl.getName();
        }
        c.addWire(componentName, pl.getName(), targetName, targetSrcName);
    }

    public static void addReferenceToComponentService(Project project, String componentName, PartnerLink pl, String targetCompName, String targetServiceName) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null || wsdlInfo.getRequestPorttype() == null) {
            return;
        }
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (c.isNameUniqueWithinComponent(componentName, pl.getName())) {
            c.addReference(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        } else {
            c.updateReference(componentName, pl.getName(), pl.getName(), (InterfaceInfo)wsdlInfo);
        }
        c.addWire(componentName, pl.getName(), targetCompName, targetServiceName);
    }

    public static void outboundParnerLinkCreated(Project project, String componentName, PartnerLink pl, int mask, String targetName, Object service) throws SCAException {
        String tmp;
        boolean addExtRef;
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null) {
            return;
        }
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (c.isNameUniqueWithinComponent(componentName, pl.getName())) {
            c.addReference(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        } else {
            c.updateReference(componentName, pl.getName(), pl.getName(), (InterfaceInfo)wsdlInfo);
        }
        boolean hasBinding = JDevSCAIntegrationUtil.wsdlHasConcreteBinding(project, wsdlInfo);
        boolean bl = addExtRef = (mask & 2) != 0;
        if (addExtRef && (hasBinding || service != null)) {
            if (service instanceof UDDIService) {
                UDDIService uddiService = (UDDIService)service;
                WsdlInfo concreteWsdlInfo = new WsdlInfo(URLUtil.toString((URL)uddiService.getImplementationWSDL()), wsdlInfo.getRequestPorttype(), wsdlInfo.getReplyPorttype());
                List bindingList = SCAControllerBindingImpl.getSoapBindingInfo((Project)project, (WsdlInfo)concreteWsdlInfo, (boolean)true, null);
                targetName = c.addExternalReference(pl.getName(), (InterfaceInfo)wsdlInfo, bindingList);
                if (uddiService.isResolveEndpoint()) {
                    for (BindingInfo bindingInfo : bindingList) {
                        if (bindingInfo.isCallbackBinding()) continue;
                        PropertyInfo propertyInfo = new PropertyInfo();
                        propertyInfo.setName(UDDI_SERVICE_KEY_PROPERTY_NAME);
                        propertyInfo.setValue(uddiService.getServiceKey());
                        c.addBindingProperty(targetName, bindingInfo, propertyInfo);
                    }
                }
                SOAProjectSettings projectSettings = SOAProjectSettings.getInstance((PropertyStorage)project);
                SOAProjectSettings.UDDIRegistry uddiRegistry = new SOAProjectSettings.UDDIRegistry(uddiService.getRegistry());
                projectSettings.setUDDIRegistry(uddiRegistry);
            } else {
                targetName = c.addExternalReference(pl.getName(), (InterfaceInfo)wsdlInfo);
            }
        }
        String refName = null;
        if (targetName == null) {
            targetName = pl.getName();
        }
        if ((tmp = targetName) != null && tmp.indexOf(47) > 0) {
            targetName = tmp.substring(0, tmp.indexOf(47));
            refName = tmp.substring(tmp.indexOf(47) + 1);
        }
        if (targetName != null && (hasBinding || !addExtRef || service != null)) {
            c.addWire(componentName, pl.getName(), targetName, refName);
        }
    }

    public static void addWireToExternalReference(Project project, String componentName, PartnerLink pl) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, false);
        if (wsdlInfo == null) {
            return;
        }
    }

    public static WsdlInfo getWSDLInfoFromURL(URL wsdlURL, QName partnerlinkType, String partnerRole, String myRole) throws SCAException {
        WsdlInfo wsdlInfo = null;
        if (!(partnerRole != null && partnerRole.trim().length() != 0 || myRole != null && myRole.trim().length() != 0)) {
            return null;
        }
        try {
            PartnerLinkType plType;
            Map map;
            QName provider = null;
            QName requester = null;
            Definition def = WSDLUtil.parseWSDL((URL)wsdlURL);
            URI wsdlUri = new URI(URIUtil.escapeURIString((String)URLUtil.toExternalForm((URL)wsdlURL)));
            String absWSDL = PartnerLinkWSDLUtil.getAbstractWsdlLocation((Definition)def, (URI)wsdlUri);
            if (absWSDL != null) {
                def = WSDLUtil.parseWSDLDocument((String)absWSDL);
            }
            if ((map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)def)) != null && map.size() > 0 && (plType = (PartnerLinkType)map.get(partnerlinkType)) != null) {
                Role role = null;
                if (myRole != null && (role = (Role)plType.getRoles().get(myRole)) != null) {
                    requester = role.getPortType().getQName();
                }
                if (partnerRole != null && (role = (Role)plType.getRoles().get(partnerRole)) != null) {
                    provider = role.getPortType().getQName();
                }
                if (provider == null) {
                    provider = requester;
                    requester = null;
                }
                wsdlInfo = new WsdlInfo(URLUtil.toString((URL)wsdlURL), provider, requester);
            }
        }
        catch (Exception ex) {
            throw new SCAException(ex);
        }
        return wsdlInfo;
    }

    public static void saveSCAComposite(Project project, String componentName) {
        JDevSCAIntegrationUtil.getSCAController(project).save(componentName);
    }

    public static void saveSCAComposite(BPELProject project, String componentName) {
        JDevSCAIntegrationUtil.getSCAController(project).save(componentName);
    }

    public static SCAController getSCAController(Project project) {
        return new SCAControllerImpl(project);
    }

    public static SCAController getSCAController(BPELProject bpelProject) {
        return JDevSCAIntegrationUtil.getSCAController((Project)bpelProject.getProjectContext());
    }

    public static WsdlInfo getWsdlInfoFromPartnerLink(Project project, PartnerLink pl, boolean isService) throws SCAException {
        URL u = null;
        String wsdlLoc = pl.getWSDLLocation();
        String dir = SCAProject.getSCAProject((Project)project).getBPELRoot().toExternalForm();
        if (wsdlLoc == null || wsdlLoc.trim().length() == 0 || wsdlLoc.equals(dir)) {
            return null;
        }
        try {
            u = new URL(wsdlLoc);
        }
        catch (Exception e) {
            throw new SCAException(e);
        }
        WsdlInfo wsdlInfo = null;
        wsdlInfo = isService ? JDevSCAIntegrationUtil.getWSDLInfoFromURL(u, pl.getPartnerLinkType(), pl.getMyRole(), pl.getPartnerRole()) : JDevSCAIntegrationUtil.getWSDLInfoFromURL(u, pl.getPartnerLinkType(), pl.getPartnerRole(), pl.getMyRole());
        if (wsdlInfo != null) {
            SCAProject scaPrj = SCAProject.getSCAProject((Project)project);
            try {
                if (URLFileSystem.isBaseURLFor((URL)scaPrj.getSCARoot(), (URL)u)) {
                    String uri = URLFileSystem.toRelativeSpec((URL)u, (URL)scaPrj.getSCARoot());
                    wsdlInfo.setWsdlLocation(uri);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return wsdlInfo;
    }

    public static WsdlInfo getWsdlInfoFromPartnerLink(BPELProject project, PartnerLink pl, boolean isService) throws SCAException {
        return JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink((Project)project.getProjectContext(), pl, isService);
    }

    public static void deleteService(Project project, String componentName, String serviceName) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        if (!c.isNameUniqueWithinComponent(componentName, serviceName)) {
            c.deleteService(componentName, serviceName);
        }
    }

    public static void deleteReference(Project project, String componentName, String refName) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        if (!c.isNameUniqueWithinComponent(componentName, refName)) {
            c.deleteReference(componentName, refName);
        }
    }

    public static void updateServiceOrReferenceFromPartnerLink(Project project, String componentName, PartnerLink pl, String oldName, int mask) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        boolean isService = JDevSCAIntegrationUtil.isService(project, componentName, oldName);
        int isNewServiceInt = JDevSCAIntegrationUtil.isService(pl);
        boolean isNewService = false;
        isNewService = isNewServiceInt != -1 ? isNewServiceInt == 0 : isService;
        WsdlInfo wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(project, pl, isNewService);
        if (wsdlInfo == null) {
            if (!c.isNameUniqueWithinComponent(componentName, oldName)) {
                if (isService) {
                    c.deleteService(componentName, oldName);
                } else {
                    c.deleteReference(componentName, oldName);
                }
            }
            return;
        }
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (isService && isNewService) {
            if (!c.isNameUniqueWithinComponent(componentName, oldName)) {
                c.updateService(componentName, oldName, pl.getName(), (InterfaceInfo)wsdlInfo);
            } else if (!c.isNameUniqueWithinComponent(componentName, pl.getName())) {
                c.updateService(componentName, pl.getName(), pl.getName(), (InterfaceInfo)wsdlInfo);
            } else {
                c.addService(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
            }
        } else if (!isService && !isNewService) {
            if (!c.isNameUniqueWithinComponent(componentName, oldName)) {
                c.updateReference(componentName, oldName, pl.getName(), (InterfaceInfo)wsdlInfo);
            } else if (!c.isNameUniqueWithinComponent(componentName, pl.getName())) {
                c.updateReference(componentName, pl.getName(), pl.getName(), (InterfaceInfo)wsdlInfo);
            } else {
                c.addReference(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
            }
        } else if (isService && !isNewService) {
            if (!c.isNameUniqueWithinComponent(componentName, oldName)) {
                c.deleteService(componentName, oldName);
            } else if (!c.isNameUniqueWithinComponent(componentName, pl.getName())) {
                c.deleteService(componentName, pl.getName());
            }
            c.addReference(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        } else if (!isService && isNewService) {
            if (!c.isNameUniqueWithinComponent(componentName, oldName)) {
                c.deleteReference(componentName, oldName);
            } else if (!c.isNameUniqueWithinComponent(componentName, pl.getName())) {
                c.deleteReference(componentName, pl.getName());
            }
            c.addService(componentName, pl.getName(), (InterfaceInfo)wsdlInfo);
        }
    }

    public static PartnerLink getPartnerlinkFromWSDLInfo(WsdlInfo wsdlInfo, String plinkName, JDevBPELProject prj) {
        return JDevSCAIntegrationUtil.getPartnerlinkFromWSDLInfo(wsdlInfo, plinkName, prj, null, null, null);
    }

    public static PartnerLink getPartnerlinkFromWSDLInfo(WsdlInfo wsdlInfo, String plinkName, JDevBPELProject prj, String plTypeName, String myRole, String partnerRole) {
        URL url = null;
        try {
            String wsLoc = wsdlInfo.getWsdlLocation();
            try {
                url = URLFactory.newURL((String)wsLoc);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (url == null) {
                url = URLFactory.newURL((URL)prj.getBPELDirectoryURL(), (String)wsLoc);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return JDevSCAIntegrationUtil.getPartnerlinkFromPortTypes(wsdlInfo.getRequestPorttype(), wsdlInfo.getReplyPorttype(), plinkName, url, prj, plTypeName, myRole, partnerRole);
    }

    public static PartnerLink getPartnerlinkFromPortTypes(QName pt, QName callback_pt, String plinkName, URL url, JDevBPELProject prj) {
        return JDevSCAIntegrationUtil.getPartnerlinkFromPortTypes(pt, callback_pt, plinkName, url, prj, null, null, null);
    }

    public static PartnerLink getPartnerlinkFromPortTypes(QName pt, QName callback_pt, String plinkName, URL url, JDevBPELProject prj, String plTypeName, String myRoleName, String partnerRoleName) {
        String wsdlLocation = URLUtil.toExternalForm((URL)url);
        PartnerLink plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        plink.setName(plinkName);
        plink.setWSDLLocation(wsdlLocation);
        try {
            String absWSDL;
            URI wsdlUri = new URI(URIUtil.escapeURIString((String)wsdlLocation));
            Definition def = WSDLUtil.parseWSDLDocument((URI)wsdlUri);
            PartnerLinkType plType = PartnerLinkWSDLUtil.findPartlinkFromPortTypes((QName)pt, (QName)callback_pt, (Definition)def);
            if (plType == null && (absWSDL = PartnerLinkWSDLUtil.getAbstractWsdlLocation((Definition)def, (URI)wsdlUri)) != null) {
                URL absUrl = null;
                try {
                    absUrl = URLFactory.newURL((String)absWSDL);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (absUrl == null) {
                    absUrl = URLFactory.newURL((URL)prj.getBPELDirectoryURL(), (String)absWSDL);
                    absWSDL = URLUtil.toExternalForm((URL)url);
                }
                def = WSDLUtil.parseWSDLDocument((URI)new URI(absWSDL));
                plType = PartnerLinkWSDLUtil.findPartlinkFromPortTypes((QName)pt, (QName)callback_pt, (Definition)def);
                plink.setWSDLLocation(absWSDL);
                wsdlLocation = absWSDL;
            }
            boolean found = false;
            if (plType != null) {
                String myRole = null;
                String partnerRole = null;
                Map roles = plType.getRoles();
                for (Object obj2 : roles.keySet()) {
                    Role role = (Role)roles.get(obj2);
                    if (role.getPortType().getQName().equals(pt)) {
                        if (callback_pt == null) {
                            found = true;
                            partnerRole = role.getName();
                        } else {
                            for (Object p : roles.keySet()) {
                                Role pRole = (Role)roles.get(p);
                                if (!pRole.getPortType().getQName().equals(callback_pt) || pRole == role) continue;
                                found = true;
                                partnerRole = role.getName();
                                myRole = pRole.getName();
                            }
                        }
                    }
                    if (!found) continue;
                    break;
                }
                plink.setPartnerLinkType(plType.getQName());
                plink.setPartnerRole(partnerRole);
                if (myRole != null && myRole.length() > 0) {
                    plink.setMyRole(myRole);
                }
            }
            if (!found) {
                ArrayList<PartnerLinkType> list = new ArrayList<PartnerLinkType>();
                String ns = def.getQName().getNamespaceURI();
                if (plTypeName == null) {
                    plTypeName = plinkName;
                }
                QName qname = new QName(ns, plTypeName);
                PartnerLinkType pltype = new PartnerLinkType(qname);
                plink.setPartnerLinkType(qname);
                String roleName = partnerRoleName == null ? pt.getLocalPart() : partnerRoleName;
                plink.setPartnerRole(roleName);
                PortType portType = def.getPortType(pt);
                Role role = new Role(roleName, portType);
                pltype.getRoles().put(roleName, role);
                if (callback_pt != null) {
                    roleName = myRoleName == null ? callback_pt.getLocalPart() : myRoleName;
                    plink.setMyRole(roleName);
                    portType = def.getPortType(callback_pt);
                    role = new Role(roleName, portType);
                    pltype.getRoles().put(roleName, role);
                }
                list.add(pltype);
                String newWSDL = PartnerLinkWSDLUtil.createWSDLAddPLTypes((BPELProject)prj, (String)plinkName, (String)URIUtil.escapeURIString((String)wsdlLocation), list, (boolean)true);
                plink.setWSDLLocation(newWSDL);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return plink;
    }

    public static boolean isService(Project project, String componentName, String name) {
        if (project == null) {
            Context context = Context.newIdeContext();
            project = context.getProject();
        }
        if (project == null) {
            return false;
        }
        try {
            SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
            List list = c.getComponentServices(componentName);
            for (Object o : list) {
                String svrName = (String)o;
                if (!name.equals(svrName)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int isService(PartnerLink pl) {
        if (pl == null) {
            return -1;
        }
        if (Helper.hasValue((String)pl.getMyRole()) && !Helper.hasValue((String)pl.getPartnerRole())) {
            return 0;
        }
        if (!Helper.hasValue((String)pl.getMyRole()) && Helper.hasValue((String)pl.getPartnerRole())) {
            return 1;
        }
        return -1;
    }

    public static void reWire(Project project, String srcCompName, String srcRefName, String oldTegartCompName, String oldTegartSrvName, String newTegartCompName, String newTegartCompSvrName, int mask) throws SCAException {
        if (newTegartCompName.equals(oldTegartCompName)) {
            return;
        }
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        c.deleteWire(srcCompName, srcRefName, oldTegartCompName, oldTegartSrvName);
        c.addWire(srcCompName, srcRefName, newTegartCompName, newTegartCompSvrName);
    }

    public static void validateNameDefined(Project project, String componentName) throws SCAException {
        if (JDevSCAIntegrationUtil.isNameUniqueWithinComposite(project, componentName)) {
            throw new SCAException(BPELStringTranslator.getString("SCA_COMPONENT_NAME_NOT_DEFINED", "Component not defined: ") + componentName);
        }
    }

    public static void validateNameNotDefined(Project project, String componentName) throws SCAException {
        if (!JDevSCAIntegrationUtil.isNameUniqueWithinComposite(project, componentName)) {
            throw new SCAException(BPELStringTranslator.getString("SCA_COMPONENT_NAME_ALREADY_EXISTS", "Component name alaready exists, please use a different name: ") + componentName);
        }
    }

    public static void validateNameDefined(Project project, String componentName, String name) throws SCAException {
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (JDevSCAIntegrationUtil.getSCAController(project).isNameUniqueWithinComponent(componentName, name)) {
            throw new SCAException(BPELStringTranslator.getString("SCA_SERVICE_NAME_NOT_DEFINED", "Service or Reference not defined: ") + name);
        }
    }

    public static void validateNameNotDefined(Project project, String componentName, String name) throws SCAException {
        JDevSCAIntegrationUtil.validateNameDefined(project, componentName);
        if (!JDevSCAIntegrationUtil.getSCAController(project).isNameUniqueWithinComponent(componentName, name)) {
            throw new SCAException(BPELStringTranslator.getString("SCA_SERVICE_NAME_ALREADY_EXISTS", "Service or Reference name alaready exists, please use a different name: ") + name);
        }
    }

    public static void deleteSCAComponent(Project project, String componentName, String scaType) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        String definitionInfo = c.getComponentImplemenation(componentName);
        c.deleteComponent(componentName);
    }

    public static boolean wsdlHasConcreteBinding(Project project, WsdlInfo wsdlInfo) {
        try {
            Definition def = WSDLUtil.parseWSDL((URL)wsdlInfo.getWsdlURL(project));
            List bindList = null;
            bindList = WsdlInfo.getConcreteSoapBindingInfo((WsdlInfo)wsdlInfo, (Definition)def, (QName)wsdlInfo.getRequestPorttype());
            if (bindList != null && bindList.size() > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void createPubSubEvent(Project project, String componentName, QName event, URL eventUrl, QName oldEvent, boolean isPublish) throws SCAException {
        EventsObject.Event e;
        URL url;
        EventInfo eInfo = null;
        EventInfo oeInfo = null;
        if (event != null) {
            eInfo = new EventInfo(event.getNamespaceURI(), event.getLocalPart());
            if (eventUrl != null) {
                eInfo.setEdlUrl(eventUrl);
            }
            if ((url = eInfo.getEdlUrl(project)) == null && (e = JDevSCAIntegrationUtil.getEventDef(Helper.getParent((URL)project.getURL()), event)) != null) {
                eInfo.setEdlUrl(e.getParent().getEdlURL());
            }
        }
        if (oldEvent != null && (url = (oeInfo = new EventInfo(oldEvent.getNamespaceURI(), oldEvent.getLocalPart())).getEdlUrl(project)) == null && (e = JDevSCAIntegrationUtil.getEventDef(Helper.getParent((URL)project.getURL()), oldEvent)) != null) {
            oeInfo.setEdlUrl(e.getParent().getEdlURL());
        }
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        if (isPublish) {
            if (eInfo != null) {
                c.addEventPublish(componentName, eInfo);
            }
            if (oeInfo != null) {
                c.deleteEventPublish(componentName, oeInfo);
            }
        } else {
            if (eInfo != null) {
                c.addEventSubscription(componentName, eInfo);
            }
            if (oeInfo != null) {
                c.deleteEventSubscription(componentName, oeInfo);
            }
        }
    }

    public static void createPubSubEvent(Project project, String componentName, EventInfo eInfo, QName oldEvent, boolean isPublish) throws SCAException {
        EventsObject.Event e;
        URL url;
        EventInfo oeInfo = null;
        if (oldEvent != null && (url = (oeInfo = new EventInfo(oldEvent.getNamespaceURI(), oldEvent.getLocalPart())).getEdlUrl(project)) == null && (e = JDevSCAIntegrationUtil.getEventDef(Helper.getParent((URL)project.getURL()), oldEvent)) != null) {
            oeInfo.setEdlUrl(e.getParent().getEdlURL());
        }
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        if (isPublish) {
            if (eInfo != null) {
                c.addEventPublish(componentName, eInfo);
            }
            if (oeInfo != null) {
                c.deleteEventPublish(componentName, oeInfo);
            }
        } else {
            if (eInfo != null) {
                c.addEventSubscription(componentName, eInfo);
            }
            if (oeInfo != null) {
                c.deleteEventSubscription(componentName, oeInfo);
            }
        }
    }

    public static EventsObject.Event getEventDef(URL projUrl, QName event) {
        try {
            File dir = new File(projUrl.getFile());
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String path;
                    return pathname != null && (path = pathname.getAbsolutePath()).endsWith(".edl");
                }
            });
            if (files.length == 0) {
                return null;
            }
            for (File file : files) {
                EventsObject eventsObj = new EventsObject(file.toURL());
                if (!eventsObj.getTargetNamespace().equals(event.getNamespaceURI())) continue;
                for (EventsObject.Event e : eventsObj.getEvents()) {
                    if (!e.getName().equals(event.getLocalPart())) continue;
                    return e;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static EventsObject.Event getEventDefByType(URL projUrl, QName type) {
        try {
            File dir = new File(projUrl.getFile());
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String path;
                    return pathname != null && (path = pathname.getAbsolutePath()).endsWith(".edl");
                }
            });
            if (files.length == 0) {
                return null;
            }
            for (File file : files) {
                EventsObject eventsObj = new EventsObject(file.toURL());
                for (EventsObject.Event e : eventsObj.getEvents()) {
                    if (!e.getNamespace().equals(type.getNamespaceURI()) || !e.getType().equals(type.getLocalPart())) continue;
                    return e;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static URL getEventSchemaUrl(URL projDir, QName eQName, List<URL> slist) {
        URL ret = null;
        if (eQName == null || slist.size() == 0) {
            return null;
        }
        if (slist.size() == 1) {
            ret = slist.get(0);
        } else {
            for (URL schemaURL : slist) {
                try {
                    GrammarInfo gInfo = new GrammarInfo(schemaURL);
                    List rootElemList = gInfo.getGlobalElementsQNames();
                    if (!rootElemList.contains(eQName)) continue;
                    ret = schemaURL;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!URLFileSystem.exists((URL)ret) && ret.getProtocol().equals("file")) {
            ret = URLFactory.newURL((URL)projDir, (String)ret.getPath());
        }
        return ret;
    }

    public static void addWSDLToComposite(Project proj, String wsdlLoc) {
        SCAControllerImpl c = (SCAControllerImpl)JDevSCAIntegrationUtil.getSCAController(proj);
    }
}

