/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.ide;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidatorCallback;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.monitor.MonitorFile;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAComponentAbstract;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.view.BPELDesignerGUI;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.designerplugins.rules.plugin.RulesBPELModelerPlugin;
import oracle.tip.tools.ide.pm.designerplugins.workflow.plugin.WorkflowBPELModelerPlugin;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.sca.ide.ScaBpelValidatorCallback;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.processbuilder.jdev.BPELWizardLauncher;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;

public class SCAComponentBPEL
extends SCAComponentAbstract {
    public static final String VALIDATION_IN_PROGRESS = "Validation in Progress";
    public static final String CONFIGURATION_MONITOR_LOCATION = "configuration.monitorLocation";
    public static final String BPEL = "bpel";
    Project m_project;
    String m_definitionInfo;
    URL m_bpelURL;
    String m_scaName;
    String m_bpelName;
    BPELNode m_pmNode;
    SCAProject m_scaProj;
    BPELXmlModel m_pmModel;
    boolean m_bIsDirty = false;
    boolean m_hasErrorOrWarning = true;
    String m_sValidationTip = null;
    boolean m_mustHaveService;
    boolean m_rightSwimLane = true;
    private boolean m_bIsService = false;
    BPELProject m_bpelProject = null;
    boolean validating_ = false;

    public String createImplementation(Project jdevProject, SCAController controller, boolean mustHaveService) {
        this.m_project = jdevProject;
        this._scaController = controller;
        this.m_scaName = this.m_project.getURL().toString();
        this.m_mustHaveService = mustHaveService;
        String bpelProcessName = null;
        try {
            ProcessData processData = new ProcessData();
            processData.m_bOpenEditor = false;
            BPELWizardLauncher.displayCreationDialog(jdevProject, processData);
            bpelProcessName = processData.m_processName;
        }
        catch (Exception wex) {
            wex.printStackTrace();
        }
        if (bpelProcessName != null) {
            String bpelFileName = bpelProcessName + ".bpel";
            this.setDefintionInfo(jdevProject, controller, bpelFileName);
        }
        return bpelProcessName;
    }

    protected URL getNewWorkspaceURL() {
        URL wspDirURL = NewWorkspacePanel.getDefaultWorkspaceDirURL();
        String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName((URL)wspDirURL);
        return URLFactory.newURL((URL)wspDirURL, (String)wspFileName);
    }

    public void setDefintionInfo(Project jdevProject, SCAController controller, String definitionInfo) {
        super.setDefintionInfo(jdevProject, controller, definitionInfo);
        this.m_project = jdevProject;
        if (!definitionInfo.endsWith(".bpel")) {
            definitionInfo = definitionInfo + ".bpel";
        }
        this.m_definitionInfo = definitionInfo;
        this.m_scaProj = SCAProject.getSCAProject((Project)this.m_project);
        String filepath = SCAProject.getScaFilePath((Project)this.m_project, (String)this.m_definitionInfo);
        this.m_bpelURL = URLFactory.newURL((String)filepath);
        this.m_pmNode = (BPELNode)NodeFactory.findInFolder((Folder)this.m_project, (URL)this.m_bpelURL);
        Iterator iter = this.m_project.getChildren();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String bpelFileName = URLFileSystem.getFileName((URL)node.getURL());
            if (!bpelFileName.equals(this.m_definitionInfo)) continue;
            this.m_pmNode = (BPELNode)node;
            break;
        }
        this.m_bpelName = this.m_definitionInfo;
        if (this.m_bpelName.endsWith(".bpel")) {
            this.m_bpelName = this.m_bpelName.substring(0, this.m_bpelName.length() - 5);
        }
        if (this.m_pmNode != null) {
            this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
        }
    }

    public void displayComponentEditor() {
        if (this.m_bpelURL == null) {
            String filepath = SCAProject.getScaFilePath((Project)this.m_project, (String)this.m_definitionInfo);
            this.m_bpelURL = URLFactory.newURL((String)filepath);
        }
        if (this.m_bpelURL != null) {
            if (!URLFileSystem.exists((URL)this.m_bpelURL)) {
                UIHelper.displayErrorMessage((Component)GraphUtils.getFrame((Component)EditorManager.getEditorManager().getDesktopComponent()), (String)BPELStringTranslator.formatString("SCA_BPEL_NO_FILE_FOUND", this.m_bpelURL.toExternalForm()));
                return;
            }
            EditorManager.getEditorManager().openDefaultEditorInFrame(this.m_bpelURL);
        }
    }

    public String referenceAdded(WsdlInfo wsdlInfo, String wireTargetName) {
        String loc;
        if (wsdlInfo == null) {
            return null;
        }
        String refNameBase = loc = wsdlInfo.getWsdlLocation();
        this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
        this.m_bpelProject = this.m_pmModel.getBPELProject();
        Process proc = this.m_pmModel.getProcess();
        PartnerLinks links = proc.getPartnerLinks();
        String refName = refNameBase = wireTargetName.replace('/', '.');
        int count = 1;
        try {
            this._scaController = JDevSCAIntegrationUtil.getSCAController(this.m_project);
            while (!this._scaController.isNameUniqueWithinComponent(this.m_bpelName, refName) || links != null && !BPELModelUtil.isUniquePartnerLinkName((List)links.getPartnerLinks(), (String)refName)) {
                refName = refNameBase + count;
                ++count;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_rightSwimLane = true;
        this.m_bIsService = false;
        this.addPartnerLink(wsdlInfo, refName, proc, wireTargetName);
        return refName;
    }

    public void referenceRemoved(String referenceName) {
        this.removePartnerLinkFromBPEL(referenceName);
    }

    public String serviceAdded(WsdlInfo wsdlInfo, String wireSourceName) {
        String loc;
        if (wsdlInfo == null) {
            return null;
        }
        String svrNameBase = loc = wsdlInfo.getWsdlLocation();
        String svrName = svrNameBase = wireSourceName.replace('/', '.');
        this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
        this.m_bpelProject = this.m_pmModel.getBPELProject();
        Process proc = this.m_pmModel.getProcess();
        PartnerLinks links = proc.getPartnerLinks();
        int count = 1;
        try {
            this._scaController = JDevSCAIntegrationUtil.getSCAController(this.m_project);
            while (!this._scaController.isNameUniqueWithinComponent(this.m_bpelName, svrName) || links != null && !BPELModelUtil.isUniquePartnerLinkName((List)links.getPartnerLinks(), (String)svrName)) {
                svrName = svrNameBase + count;
                ++count;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_rightSwimLane = false;
        this.m_bIsService = true;
        this.addPartnerLink(wsdlInfo, svrName, proc, wireSourceName);
        return svrName;
    }

    public void serviceRemoved(String serviceName) {
        this.removePartnerLinkFromBPEL(serviceName);
    }

    public void delete() {
        Editor editor;
        if (this.m_pmNode == null) {
            this.m_pmNode = (BPELNode)NodeFactory.findInFolder((Folder)this.m_project, (URL)this.m_bpelURL);
        }
        if ((editor = SCAComponentBPEL.findIdeNodeEditor((Node)this.m_pmNode, null)) != null) {
            ArrayList<Editor> edlist = new ArrayList<Editor>(1);
            edlist.add(editor);
            EditorManager.getEditorManager().closeEditors(edlist);
        }
        try {
            if (this.m_pmNode != null) {
                this.m_pmNode.save();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        new File(URLFileSystem.getPath((URL)this.m_bpelURL)).delete();
        new File(Helper.getParent((URL)this.m_bpelURL).getPath() + "/.designer/" + this.m_bpelName + "_graphics.xml").delete();
        URL wsdlURL = URLFactory.newURL((URL)Helper.getParent((URL)this.m_bpelURL), (String)(this.m_bpelName + ".wsdl"));
        if (this._scaController.getWsdlUsageCount(wsdlURL) <= 1) {
            new File(Helper.getParent((URL)this.m_bpelURL).getPath() + "/" + this.m_bpelName + ".wsdl").delete();
            new File(Helper.getParent((URL)this.m_bpelURL).getPath() + "/xsd/" + this.m_bpelName + ".xsd").delete();
        }
        this.deleteMonitorFiles(this.m_bpelName, this.m_bpelURL, this._scaController);
        BPELPlugInManager.notifyResourceDeleted(this.m_bpelURL, "");
    }

    private void deleteMonitorFiles(String bpelName, URL bpelURL, SCAController scaController) {
        PropertyInfo monitorFileLocationInfo = scaController.getCompositePropertyInfo(bpelName, CONFIGURATION_MONITOR_LOCATION);
        if (monitorFileLocationInfo != null) {
            String monitorFileLocation = monitorFileLocationInfo.getValue();
            MonitorFile.delete((URL)bpelURL, (String)monitorFileLocation);
        }
    }

    public ImageIcon getIcon() {
        return null;
    }

    public boolean canAddReferences() {
        return true;
    }

    public boolean canAddInterfaces() {
        return true;
    }

    protected synchronized String runValidation() {
        if (!this.validating_) {
            this.validating_ = true;
            this.validationTooltip = VALIDATION_IN_PROGRESS;
            if (this.m_pmNode != null) {
                this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
                Process proc = this.m_pmModel.getProcess();
                ScaBpelValidatorCallback vc = new ScaBpelValidatorCallback();
                BPELModelUtil.validateProcess((Process)proc, (ValidatorCallback)vc);
                this.validationTooltip = vc.m_errorCnt == 0 ? null : BPELStringTranslator.getString("SCA_INVALID_BPEL_COMPONENT");
            } else {
                this.validationTooltip = BPELStringTranslator.getString("SCA_INVALID_BPEL_COMPONENT");
            }
            this.componentIsValid = !Helper.hasValue((String)this.validationTooltip);
            this.validating_ = false;
        }
        return this.validationTooltip;
    }

    public boolean isDirty() {
        return this.m_bIsDirty;
    }

    public void addPartnerLink(WsdlInfo wsdlInfo, String plName, Process proc, String wireSrcTargetName) {
        PartnerLink plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        try {
            JDevBPELProject bpelProj = (JDevBPELProject)this.m_bpelProject;
            plink = JDevSCAIntegrationUtil.getPartnerlinkFromWSDLInfo(wsdlInfo, plName, bpelProj);
            String plinkWsdlLocation = plink.getWSDLLocation();
            URL plinkWsdlLocationURL = new URL(plinkWsdlLocation);
            if (plinkWsdlLocationURL.getProtocol().equalsIgnoreCase("file")) {
                plinkWsdlLocation = URLFileSystem.toRelativeSpec((URL)plinkWsdlLocationURL, (URL)this.m_bpelURL);
            }
            if (!plinkWsdlLocation.equals(wsdlInfo.getWsdlLocation())) {
                wsdlInfo.setWsdlLocation(plinkWsdlLocation);
                int index = wireSrcTargetName.indexOf("/");
                String compName = null;
                String srcTargetName = wireSrcTargetName;
                if (index > 0) {
                    compName = wireSrcTargetName.substring(0, index);
                    srcTargetName = wireSrcTargetName.substring(index + 1);
                }
            }
            String ns = proc.addNamespace(plink.getPartnerLinkType().getNamespaceURI());
            plink.setPartnerLinkType(new QName(plink.getPartnerLinkType().getNamespaceURI(), plink.getPartnerLinkType().getLocalPart(), ns));
            if (this.m_bIsService) {
                String t = plink.getMyRole();
                plink.setMyRole(plink.getPartnerRole());
                plink.setPartnerRole(t);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            proc.addPartnerLink(plink);
            this.m_pmModel.newDiagramTimeStamp();
            this.m_pmNode.markDirty(true);
            this.m_bIsDirty = true;
            this.addPartnerLinkToUI(this.m_pmModel, plink);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void addPartnerLinkToUI(BPELXmlModel model, PartnerLink plink) {
        BPELDesignerGUI gui = model.getGUI();
        if (gui != null && gui.getJDevBPELEditor() != null) {
            BPELGraphPane pane = gui.getJDevBPELEditor().getGraph();
            PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
            partnerLinkNode.setUserObject(plink);
            SwimLaneView swimLaneView = null;
            swimLaneView = this.m_rightSwimLane ? pane.getRightSwimLaneView() : pane.getLeftSwimLaneView();
            SwimLaneNode swimLaneNode = (SwimLaneNode)swimLaneView.getNode();
            BPELGraphModel gmodel = (BPELGraphModel)pane.getModel();
            gmodel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)swimLaneNode, (oracle.tip.tools.ide.common.graph.model.Node)partnerLinkNode);
        }
    }

    public void refreshEditor() {
    }

    public void removePartnerLinkFromUI(BPELXmlModel model, String plName) {
        BPELDesignerGUI gui = model.getGUI();
        if (gui != null && gui.getJDevBPELEditor() != null) {
            BPELGraphPane pane = gui.getJDevBPELEditor().getGraph();
            BPELGraphModel gmodel = (BPELGraphModel)pane.getModel();
            SwimLaneView swimLaneView = pane.getLeftSwimLaneView();
            View v = this.findPartnerLink(swimLaneView, plName);
            if (v == null) {
                swimLaneView = pane.getRightSwimLaneView();
                v = this.findPartnerLink(swimLaneView, plName);
            }
            if (v == null) {
                return;
            }
            gmodel.deleteNode(swimLaneView.getNode(), v.getNode());
        }
    }

    public PartnerLink removePartnerLinkFromModel(Process proc, String name) {
        PartnerLink plink = SCAComponentBPEL.findPartnerLinkByName(name, proc);
        if (plink == null) {
            return plink;
        }
        Scope s = BPELModelUtil.getScopeForPartnerLink((Process)proc, (PartnerLink)plink);
        if (s != null) {
            s.deletePartnerLink(plink);
            List lst = BPELModelUtil.updatePartnerLinkReference((Scope)s, (String)plink.getName(), null);
            BPELModelUtil.validateActivities((Process)proc, (List)lst);
        }
        return plink;
    }

    public static PartnerLink findPartnerLinkByName(String name, Process proc) {
        if (proc == null || name == null) {
            return null;
        }
        List l = BPELModelUtil.getAllPartnerLinks((Process)proc);
        if (l == null) {
            return null;
        }
        for (PartnerLink lnk : l) {
            if (lnk.getName() == null || !lnk.getName().equals(name)) continue;
            return lnk;
        }
        return null;
    }

    public View findPartnerLink(SwimLaneView parent, String name) {
        Iterator it = parent.getChildren();
        View v = null;
        while (it.hasNext()) {
            v = (View)it.next();
            PartnerLink link = (PartnerLink)v.getNode().getUserObject();
            if (!link.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public void removePartnerLinkFromBPEL(String plName) {
        try {
            BPELGraphPane pane;
            BPELDesignerGUI gui;
            this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
            Process proc = this.m_pmModel.getProcess();
            this.m_bIsDirty = true;
            if (RulesBPELModelerPlugin.isRulePartnerLink(proc, plName)) {
                gui = this.m_pmModel.getGUI();
                pane = null;
                if (gui != null && gui.getJDevBPELEditor() != null) {
                    pane = gui.getJDevBPELEditor().getGraph();
                }
                RulesBPELModelerPlugin.removeRuleActivityByPartnerLinkName(proc, plName, pane);
            }
            if (WorkflowBPELModelerPlugin.isWorkflowPartnerLink(proc, plName)) {
                gui = this.m_pmModel.getGUI();
                pane = null;
                if (gui != null && gui.getJDevBPELEditor() != null) {
                    pane = gui.getJDevBPELEditor().getGraph();
                }
                WorkflowBPELModelerPlugin.removeUserTaskActivityByPartnerLinkName(proc, plName, pane);
            }
            this.removePartnerLinkFromUI(this.m_pmModel, plName);
            this.removePartnerLinkFromModel(proc, plName);
            this.m_pmModel.newDiagramTimeStamp();
            this.m_pmNode.markDirty(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void displayComponentTestEditor(URL componentTestFile, URL componentBaseIncludeFile, String compositeTestName) {
    }

    public static Editor findIdeNodeEditor(Node node, Class guiComp) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List editors = editorManager.getAllEditors();
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = (Editor)editors.get(i);
            Node curnode = editor.getContext().getNode();
            if (!curnode.equals(node)) continue;
            Component guiObj = editor.getGUI();
            if (guiComp == null) {
                return editor;
            }
            if (!guiComp.isInstance(guiObj)) continue;
            return editor;
        }
        return null;
    }

    public void serviceUpdated(String serviceName, WsdlInfo wsdlInfo) {
        System.out.print("***** BPEL SCAComponent got service " + serviceName + " updated: " + wsdlInfo.getWsdlLocation() + "\n");
        this.updatePLWsdl(wsdlInfo, serviceName, true);
    }

    public void referenceUpdated(String referenceName, WsdlInfo wsdlInfo) {
        System.out.print("***** BPEL SCAComponent got reference " + referenceName + " updated: " + wsdlInfo.getWsdlLocation() + "\n");
        this.updatePLWsdl(wsdlInfo, referenceName, false);
    }

    private void updatePLWsdl(WsdlInfo wsdlInfo, String plName, boolean isService) {
        this.m_pmModel = (BPELXmlModel)this.m_pmNode.getModel(this.m_project);
        Process proc = this.m_pmModel.getProcess();
        this.m_pmModel.newDiagramTimeStamp();
        this.m_pmNode.markDirty(true);
        this.m_bIsDirty = true;
        PartnerLink pl = SCAComponentBPEL.findPartnerLinkByName(plName, proc);
        URL wsdlUrl = wsdlInfo.getWsdlURL(this.m_project);
        if (pl != null) {
            this.m_bpelProject = this.m_pmModel.getBPELProject();
            JDevBPELProject bpelProj = (JDevBPELProject)this.m_bpelProject;
            PartnerLink plTemp = JDevSCAIntegrationUtil.getPartnerlinkFromWSDLInfo(wsdlInfo, plName, bpelProj, pl.getPartnerLinkType().getLocalPart(), pl.getMyRole(), pl.getPartnerRole());
            if (plTemp.getWSDLLocation().equals(URLUtil.toExternalForm((URL)wsdlUrl))) {
                pl.setWSDLLocation(URLUtil.toExternalForm((URL)wsdlUrl));
            } else {
                pl.setWSDLLocation(plTemp.getWSDLLocation());
                QName plType = plTemp.getPartnerLinkType();
                pl.setPartnerLinkType(new QName(plType.getNamespaceURI(), plType.getLocalPart(), pl.getPartnerLinkType().getPrefix()));
                pl.setMyRole(plTemp.getMyRole());
                pl.setPartnerRole(plTemp.getPartnerRole());
                String newWSDL = URLFileSystem.toRelativeSpec((URL)URLFactory.newURL((String)plTemp.getWSDLLocation()), (URL)this.m_scaProj.getProjectRoot());
                wsdlInfo.setWsdlLocation(newWSDL);
                this._scaController = JDevSCAIntegrationUtil.getSCAController(this.m_project);
                wsdlInfo = new WsdlInfo(wsdlInfo.getWsdlLocation(), wsdlInfo.getRequestPorttype(), wsdlInfo.getReplyPorttype());
                if (isService) {
                    this._scaController.updateService(this.m_bpelName, plName, plName, (InterfaceInfo)wsdlInfo);
                } else {
                    this._scaController.updateReference(this.m_bpelName, plName, plName, (InterfaceInfo)wsdlInfo);
                }
            }
        }
    }
}

