/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.ide;

import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessEvent;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAException;

public class JDevScaProcessListener
implements ProcessListener {
    protected Project m_project;

    public JDevScaProcessListener(Project project) {
        this.m_project = project;
    }

    public void modelChanged(ProcessEvent event) {
        try {
            if (event.getID() == 5) {
                PartnerLink link = (PartnerLink)event.getChangeObject();
                Boolean bComponentSvc = (Boolean)event.getEventData("CompSvcPartnerLink");
                int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
                Boolean bAdapter = (mask & 0x80) == 0;
                Boolean bInboundWSDL = (Boolean)event.getEventData("InboundPartnerLink");
                if (bComponentSvc != null && bComponentSvc.booleanValue()) {
                    this.createComponentService(event);
                } else if (bAdapter != null && bAdapter.booleanValue() && bInboundWSDL != null && bInboundWSDL.booleanValue()) {
                    this.createAdapterBPELService(event);
                } else if (bInboundWSDL != null && bInboundWSDL.booleanValue()) {
                    this.createBPELService(event);
                } else {
                    this.createOutboundPartnerLink(event);
                }
            } else if (event.getID() == 6) {
                this.removeServiceFromComposite(event);
            } else if (event.getID() == 25) {
                this.updateServiceOrReference(event);
            } else if (event.getID() == 29) {
                this.changeWireTarget(event);
            } else if (event.getID() == 30) {
                this.pubSubEventChange(event);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    protected void updateServiceOrReference(ProcessEvent event) throws SCAException {
        String processName = event.getProcess().getName();
        PartnerLink pl = (PartnerLink)event.getChangeObject();
        String oldName = (String)event.getEventData("PL_OldName");
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        JDevSCAIntegrationUtil.updateServiceOrReferenceFromPartnerLink(this.m_project, processName, pl, oldName, mask);
    }

    private int getPartnerLinkMask(Object obj) {
        if (obj != null && obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    protected void createComponentService(ProcessEvent event) throws SCAException {
        String svcCompName;
        String processName = event.getProcess().getName();
        PartnerLink pl = (PartnerLink)event.getChangeObject();
        if (pl == null) {
            return;
        }
        String svcName = (String)event.getEventData("CompSvcName");
        if (svcName == null) {
            svcName = pl.getName();
        }
        if ((svcCompName = (String)event.getEventData("CompName")) == null) {
            svcCompName = svcName;
        }
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        JDevSCAIntegrationUtil.createServiceFromPartnerLink(this.m_project, svcCompName, svcName, pl, mask, false);
        JDevSCAIntegrationUtil.partnerLinkReferenceToComponentService(this.m_project, processName, pl, svcCompName, svcName, mask);
    }

    protected void createAdapterBPELService(ProcessEvent event) throws SCAException {
        String processName = event.getProcess().getName();
        PartnerLink pl = (PartnerLink)event.getChangeObject();
        String svcName = (String)event.getEventData("CompSvcName");
        if (svcName == null) {
            svcName = pl.getName();
        }
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        JDevSCAIntegrationUtil.createServiceFromPartnerLink(this.m_project, processName, svcName, pl, mask, true);
        String srcName = svcName;
        JDevSCAIntegrationUtil.partnerLinkReferenceToBPELService(this.m_project, processName, pl, srcName, mask);
    }

    protected void createBPELService(ProcessEvent event) throws SCAException {
        String processName = event.getProcess().getName();
        PartnerLink pl = (PartnerLink)event.getChangeObject();
        String svcName = (String)event.getEventData("CompSvcName");
        if (svcName == null) {
            svcName = pl.getName();
        }
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        JDevSCAIntegrationUtil.createServiceFromPartnerLink(this.m_project, processName, svcName, pl, mask, true);
        JDevSCAIntegrationUtil.serviceEntryToBPELService(this.m_project, processName, pl, svcName, mask);
    }

    protected void createOutboundPartnerLink(ProcessEvent event) throws SCAException {
        Object obj;
        String t;
        String wsdl;
        boolean bAdapter;
        String processName = event.getProcess().getName();
        PartnerLink pl = (PartnerLink)event.getChangeObject();
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        String refName = (String)event.getEventData("Reference_Name");
        boolean bl = bAdapter = (mask & 0x80) == 0;
        if (bAdapter && refName == null && Helper.hasValue((String)(wsdl = pl.getWSDLLocation())) && Helper.hasValue((String)(t = Helper.getFileName((URL)URLFactory.newURL((String)wsdl))))) {
            refName = t.substring(0, t.lastIndexOf("."));
        }
        if ((obj = event.getEventData("scaObject")) == null) {
            obj = event.getEventData("uddiService");
        }
        JDevSCAIntegrationUtil.outboundParnerLinkCreated(this.m_project, processName, pl, mask, refName, obj);
    }

    protected void removeServiceFromComposite(ProcessEvent event) throws SCAException {
        PartnerLink pl;
        String processName = event.getProcess().getName();
        boolean isService = JDevSCAIntegrationUtil.isService(this.m_project, processName, (pl = (PartnerLink)event.getChangeObject()).getName());
        if (isService) {
            JDevSCAIntegrationUtil.deleteService(this.m_project, processName, pl.getName());
        } else {
            JDevSCAIntegrationUtil.deleteReference(this.m_project, processName, pl.getName());
        }
    }

    protected void changeWireTarget(ProcessEvent event) throws SCAException {
        String processName = event.getProcess().getName();
        String srcRefName = (String)event.getChangeObject();
        String newTegartCompName = (String)event.getEventData("TargetComponentName");
        String oldTegartCompName = (String)event.getEventData("OldTargetComponentName");
        String newTegartCompSrvName = (String)event.getEventData("TargetComponentSrvName");
        String oldTegartCompSrvName = (String)event.getEventData("OldTargetComponentSrvName");
        int mask = this.getPartnerLinkMask(event.getEventData("PartnerLinkSCAMask"));
        if (oldTegartCompName == null || newTegartCompName == null) {
            return;
        }
        JDevSCAIntegrationUtil.reWire(this.m_project, processName, srcRefName, oldTegartCompName, oldTegartCompSrvName, newTegartCompName, newTegartCompSrvName, mask);
    }

    protected void pubSubEventChange(ProcessEvent event) throws SCAException {
        Object src = event.getSource();
        boolean isPub = src instanceof Invoke || src instanceof Reply;
        String processName = event.getProcess().getName();
        QName eventQN = (QName)event.getChangeObject();
        QName oldEventQN = (QName)event.getEventData("OldEventNAME");
        URL eventUrl = (URL)event.getEventData("EventURL");
        if (oldEventQN != null) {
            List list = BPELModelUtil.getAllActivities((Scope)event.getProcess());
            int count = 0;
            for (Activity a : list) {
                QName e = null;
                if (isPub) {
                    if (a instanceof Invoke) {
                        e = ((Invoke)a).getEventName();
                    } else if (a instanceof Reply) {
                        e = ((Reply)a).getEventName();
                    }
                } else if (a instanceof Receive) {
                    e = ((Receive)a).getEventName();
                } else if (a instanceof OnMessage) {
                    e = ((OnMessage)a).getEventName();
                }
                if (e == null || !e.equals(oldEventQN)) continue;
                ++count;
            }
            if (count > 0) {
                oldEventQN = null;
            }
        }
        JDevSCAIntegrationUtil.createPubSubEvent(this.m_project, processName, eventQN, eventUrl, oldEventQN, isPub);
    }
}

