/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.ide;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.SCAComponentAbstract;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.util.RuleBuilderLauncherCommand;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.editor.util.UIMessageGenerator;
import oracle.tip.tools.ide.rules.extension.RuleBuilderLauncher;
import oracle.tip.tools.ide.rules.extension.RulesRepositoryNode;
import oracle.tip.tools.ide.rules.sdkmodel.SDKModel;

public class DecisionServiceSCAComponent
extends SCAComponentAbstract {
    private static final boolean SHOULD_OPEN_EDITOR = false;
    public static final String VALIDATION_IN_PROGRESS = "Validation in Progress";
    public static final String VALIDATION_FAILED = "Validation Failed";
    private Project m_project;
    private SDKModel m_sdkModel = null;
    private WizardData data;
    private URL rulesFileURL;
    private RulesRepositoryNode m_ruleNode = null;
    boolean validating_ = false;

    public String createImplementation(Project project, SCAController pController, boolean mustHaveService) {
        this.m_project = project;
        this._scaController = pController;
        String decisionName = this.createDesisionService(project, pController);
        if (decisionName != null) {
            String decisionFileName = decisionName + ".decs";
            this.setDefintionInfo(project, pController, decisionFileName);
        }
        return decisionName;
    }

    private String createDesisionService(Project project, SCAController pController) {
        this.m_project = project;
        this._scaController = pController;
        RuleBuilderLauncherCommand command = new RuleBuilderLauncherCommand();
        this.data = command.execute(this.m_project, false);
        if (this.data != null) {
            this.m_sdkModel = this.data.getSDKModel();
        }
        if (this.m_sdkModel != null) {
            return this.m_sdkModel.getDictionaryName();
        }
        return null;
    }

    public void setDefintionInfo(Project project, SCAController controller, String definitionInfo) {
        super.setDefintionInfo(project, controller, definitionInfo);
        this.m_project = project;
        SCAProject scaProject = SCAProject.getSCAProject((Project)project);
        URL scaRoot = scaProject.getSCARoot();
        URL decisionFileURL = URLFactory.newFileURL((String)(scaRoot.getPath() + definitionInfo));
        DecisionServices _services = null;
        try {
            RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
            Unmarshaller unmarshaller = rpi_factory.createUnmarshaller();
            _services = (DecisionServices)unmarshaller.unmarshal(decisionFileURL);
            String p = Helper.getFileName((URL)Helper.getParent((URL)project.getURL())) + "/";
            URL parent = URLFileSystem.getParent((URL)project.getURL());
            for (int count = 0; count < _services.getRuleEngineProviders().size(); ++count) {
                TRuleEngineProvider ruleEngineProvider = (TRuleEngineProvider)_services.getRuleEngineProviders().get(0);
                if (ruleEngineProvider == null || ruleEngineProvider.getRepository() == null) continue;
                String ruleFilePath = ruleEngineProvider.getRepository().getPath();
                this.rulesFileURL = ruleFilePath.startsWith(p) ? URLFactory.newURL((URL)parent, (String)ruleFilePath.substring(p.length())) : URLFactory.newURL((URL)parent, (String)ruleFilePath.substring(ruleFilePath.indexOf("/") + 1));
                if (this.m_sdkModel != null || !URLFileSystem.exists((URL)this.rulesFileURL)) continue;
                this.m_ruleNode = (RulesRepositoryNode)NodeFactory.findInFolder((Folder)project, (URL)this.rulesFileURL);
                Iterator iter = project.getChildren();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    if (!node.getURL().equals(this.rulesFileURL)) continue;
                    this.m_ruleNode = (RulesRepositoryNode)node;
                    break;
                }
                this.m_sdkModel = this.m_ruleNode.getSDKModel();
                this.m_sdkModel.initFromProject(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayComponentEditor() {
        if (this.rulesFileURL != null) {
            RuleBuilderLauncher.openDecisionService((URL)this.rulesFileURL, null);
        }
    }

    public String referenceAdded(WsdlInfo wsdlInfo, String wireTargetName) {
        return null;
    }

    public void referenceRemoved(String referenceName) {
    }

    public String serviceAdded(WsdlInfo pInfo, String pWireSourceName) {
        return null;
    }

    public void serviceRemoved(String serviceName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.m_sdkModel == null) {
            return;
        }
        SDKModel sDKModel = this.m_sdkModel;
        synchronized (sDKModel) {
            if (this.rulesFileURL == null) {
                this.rulesFileURL = this.m_sdkModel.getDictionaryURL();
            }
            URL graphsURL = this.m_sdkModel.getGraphicsFileURL();
            String rulesFileName = this.m_sdkModel.getDictionaryName();
            DecisionServices services = null;
            try {
                services = this.m_sdkModel.getDecisionServiceModel().getDecisionServices();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_sdkModel = null;
            this.data = null;
            if (!this.deleteGraphicsFile(graphsURL)) {
                this.logError("Could not delete _graphics.xml file");
            }
            if (!this.deleteDescriptionFile(rulesFileName)) {
                this.logError("Could not delete .desc file");
            }
            if (!this.deleteRulesFile()) {
                this.logError("Could not delete .rules file");
            }
            if (!this.deleteWSDLFile(services, rulesFileName)) {
                this.logError("Could not delete .wsdl or .xsd file");
            }
        }
    }

    private boolean deleteRulesFile() {
        this.closeEditor(this.rulesFileURL);
        NodeFactory.uncache((URL)this.rulesFileURL);
        File ruleFile = new File(URLFileSystem.getPath((URL)this.rulesFileURL));
        if (null == ruleFile) {
            return false;
        }
        return ruleFile.delete();
    }

    private boolean deleteGraphicsFile(URL rulesGraphicsURL) {
        this.closeEditor(rulesGraphicsURL);
        NodeFactory.uncache((URL)rulesGraphicsURL);
        File ruleGraphicsFile = new File(URLFileSystem.getPath((URL)rulesGraphicsURL));
        if (null == ruleGraphicsFile) {
            return false;
        }
        return ruleGraphicsFile.delete();
    }

    private boolean deleteWSDLFile(DecisionServices services, String dictName) {
        SCAProject scaProject = SCAProject.getSCAProject((Project)this.m_project);
        URL projectRoot = scaProject.getProjectRoot();
        try {
            List slist = services.getDecisionServices();
            Iterator i$ = slist.iterator();
            if (i$.hasNext()) {
                TDecisionService s = (TDecisionService)i$.next();
                String name = s.getName();
                List entries = this._scaController.getComponentServiceSources(dictName, name);
                if (entries != null && entries.size() > 0 && ((String)entries.get(0)).indexOf("/") < 0) {
                    this._scaController.deleteServiceEntrypoint((String)entries.get(0));
                }
                String wsdlFileName = name + ".wsdl";
                URL wsdlFileURL = URLFactory.newURL((URL)projectRoot, (String)wsdlFileName);
                this.closeEditor(wsdlFileURL);
                NodeFactory.uncache((URL)wsdlFileURL);
                File wsdlFile = new File(URLFileSystem.getPath((URL)wsdlFileURL));
                if (null == wsdlFile) {
                    return false;
                }
                if (!wsdlFile.delete()) {
                    return false;
                }
                String xsdFileName = name + "Types.xsd";
                URL xsdFileURL = URLFactory.newURL((URL)scaProject.getXSDRoot(), (String)xsdFileName);
                this.closeEditor(xsdFileURL);
                NodeFactory.uncache((URL)xsdFileURL);
                File xsdFile = new File(URLFileSystem.getPath((URL)xsdFileURL));
                if (null == xsdFile) {
                    return false;
                }
                return xsdFile.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private boolean deleteDescriptionFile(String rulesFileName) {
        SCAProject scaProject = SCAProject.getSCAProject((Project)this.m_project);
        URL projectRoot = scaProject.getProjectRoot();
        String ruleDescFileName = rulesFileName + ".decs";
        URL ruleDescFileURL = URLFactory.newURL((URL)projectRoot, (String)ruleDescFileName);
        this.closeEditor(ruleDescFileURL);
        NodeFactory.uncache((URL)ruleDescFileURL);
        File ruleDescFile = new File(URLFileSystem.getPath((URL)ruleDescFileURL));
        if (null == ruleDescFile) {
            return false;
        }
        return ruleDescFile.delete();
    }

    public void closeEditor(final URL editorURL) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Editor editor = DecisionServiceSCAComponent.this.getEditor(editorURL);
                if (editor != null) {
                    ArrayList<Editor> edlist = new ArrayList<Editor>(1);
                    edlist.add(editor);
                    EditorManager.getEditorManager().closeEditors(edlist);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public Editor getEditor(URL editorURL) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List editors = editorManager.getAllEditors();
        Node ruleNode = NodeFactory.find((URL)editorURL);
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = (Editor)editors.get(i);
            Node curnode = editor.getContext().getNode();
            if (!curnode.equals(ruleNode)) continue;
            return editor;
        }
        return null;
    }

    private void logError(String err) {
        System.out.println(err);
    }

    public ImageIcon getIcon() {
        return null;
    }

    public boolean canAddReferences() {
        return false;
    }

    public boolean canAddInterfaces() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runValidation() {
        if (!this.validating_) {
            this.validating_ = true;
            this.validationTooltip = VALIDATION_IN_PROGRESS;
            try {
                if (this.m_ruleNode != null) {
                    this.m_sdkModel = this.m_ruleNode.getSDKModel();
                    if (this.m_sdkModel != null) {
                        if (URLFileSystem.exists((URL)this.rulesFileURL)) {
                            if (this.m_sdkModel.getDictionary() == null) {
                                this.m_sdkModel.loadDictionary();
                            }
                            ArrayList warnings = new ArrayList();
                            ArrayList exceptions = new ArrayList();
                            this.m_sdkModel.getDictionary().validate(exceptions, warnings);
                            this.validationTooltip = UIMessageGenerator.getWarningMsg(warnings);
                            this.componentIsValid = !Helper.hasValue((String)this.validationTooltip);
                        }
                    } else {
                        this.validationTooltip = BPELStringTranslator.getString("SCA_INVALID_RULE_COMPONENT");
                        this.componentIsValid = false;
                    }
                } else {
                    this.validationTooltip = BPELStringTranslator.getString("SCA_INVALID_RULE_COMPONENT");
                    this.componentIsValid = false;
                }
            }
            catch (Exception ex) {
                this.validationTooltip = VALIDATION_FAILED;
                this.componentIsValid = false;
                ex.printStackTrace();
            }
            finally {
                this.validating_ = false;
            }
        }
        return this.validationTooltip;
    }

    public boolean isDirty() {
        return false;
    }

    public void refreshEditor() {
    }

    public void displayComponentTestEditor(URL componentTestFile, URL componentBaseIncludeFile, String compositeTestName) {
    }
}

