/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.sca.ide;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.deploy.ActivitationAgent;
import oracle.tip.tools.ide.common.utils.deploy.DeployPropertyNode;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;

public class BPELDesignerDeploymentFile
implements DeploymentFile {
    public static QName STRINGTYPE = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    public static final String CONFIG_PROPERTY = "configuration";
    public static final String PARTNER_LINK_PROPERTY = "partnerLink";
    public static final String SENSOR_LOC_NAME = "sensorLocation";
    public static final String SENSOR_ACT_LOC_NAME = "sensorActionLocation";
    public static final String SENSOR_XML = "sensor.xml";
    public static final String SENSOR_ACTION_XML = "sensorAction.xml";
    public static final String ACT_AGENT = "activationAgent";
    protected String m_processName;
    protected SCAProject m_scaProject;
    protected SCAController m_scaController;
    protected boolean m_bSensorActionWritten = false;
    protected boolean m_bSensorWritten = false;

    public BPELDesignerDeploymentFile(String processName, Project project) {
        this.m_processName = processName;
        this.m_scaProject = SCAProject.getSCAProject((Project)project);
        this.m_scaController = JDevSCAIntegrationUtil.getSCAController(project);
    }

    public void addActivitationAgent(String partnerLinkName, ActivitationAgent ag) {
        String base = "activationAgent." + partnerLinkName + ".";
        PropertyInfo pro = new PropertyInfo(base + "className", STRINGTYPE, false, null, null, ag.getClassName());
        this.m_scaController.addComponentProperty(this.m_processName, pro);
        Collection pros = ag.getPropertyMap().values();
        for (Object obj : pros) {
            PLProperties plprop = (PLProperties)obj;
            pro = new PropertyInfo(base + plprop.m_name, STRINGTYPE, false, null, null, plprop.m_value);
            this.m_scaController.addComponentProperty(this.m_processName, pro);
        }
    }

    public void addPLProperties(String partnerLinkName, String propName, String propValue, String type) {
        PropertyInfo pro = new PropertyInfo("partnerLink." + partnerLinkName + "." + propName, STRINGTYPE, false, null, null, propValue);
        this.m_scaController.addComponentProperty(this.m_processName, pro);
    }

    public void addSensorActionConfig() {
        if (!this.m_bSensorActionWritten) {
            String base = "configuration.sensorActionLocation";
            PropertyInfo pro = new PropertyInfo(base, STRINGTYPE, false, null, null, this.m_processName + "_" + SENSOR_ACTION_XML);
            this.m_bSensorActionWritten = true;
            PropertyInfo o = this.m_scaController.getCompositePropertyInfo(this.m_processName, base);
            if (o != null) {
                this.m_scaController.deleteCompositeProperty(this.m_processName, base);
            }
            this.m_scaController.addComponentProperty(this.m_processName, pro);
        }
    }

    public void removeSensorActionConfig() {
        String base = "configuration.sensorActionLocation";
        PropertyInfo info = this.m_scaController.getCompositePropertyInfo(this.m_processName, base);
        if (info != null) {
            this.m_scaController.deleteCompositeProperty(this.m_processName, base);
        }
    }

    public void addSensorConfig() {
        if (!this.m_bSensorWritten) {
            this.m_bSensorWritten = true;
            String base = "configuration.sensorLocation";
            PropertyInfo pro = new PropertyInfo(base, STRINGTYPE, false, null, null, this.m_processName + "_" + SENSOR_XML);
            PropertyInfo o = this.m_scaController.getCompositePropertyInfo(this.m_processName, base);
            if (o != null) {
                this.m_scaController.deleteCompositeProperty(this.m_processName, base);
            }
            this.m_scaController.addComponentProperty(this.m_processName, pro);
        }
    }

    public void removeSensorConfig() {
        String base = "configuration.sensorLocation";
        PropertyInfo info = this.m_scaController.getCompositePropertyInfo(this.m_processName, base);
        if (info != null) {
            this.m_scaController.deleteCompositeProperty(this.m_processName, base);
        }
    }

    public ActivitationAgent getActivitationAgent(String partnerLinkName) {
        if (partnerLinkName == null || partnerLinkName.length() == 0) {
            return null;
        }
        String base = "activationAgent." + partnerLinkName + ".";
        List<PropertyInfo> lst = null;
        try {
            lst = BPELDesignerDeploymentFile.filterList(base, this.m_scaController.getCompositeProperties(this.m_processName));
        }
        catch (Throwable ex) {
            return null;
        }
        ActivitationAgent ag = null;
        PropertyInfo pro = null;
        if (lst.size() > 0) {
            pro = lst.get(0);
            ag = new ActivitationAgent(BPELDesignerDeploymentFile.stripName(base, pro.getName()));
            if (lst.size() > 1) {
                for (int i = 1; i < lst.size(); ++i) {
                    pro = lst.get(i);
                    ag.addProperty(BPELDesignerDeploymentFile.stripName(base, pro.getName()), pro.getValue(), pro.getType().toString());
                }
            }
        }
        return ag;
    }

    public List<DeployPropertyNode> getExtraConfig() {
        List<PropertyInfo> lst = this.m_scaController.getCompositeProperties(this.m_processName);
        String base = "configuration.";
        lst = BPELDesignerDeploymentFile.filterList(base, lst);
        ArrayList<DeployPropertyNode> ret = new ArrayList<DeployPropertyNode>();
        Iterator<PropertyInfo> i$ = lst.iterator();
        while (i$.hasNext()) {
            PropertyInfo o;
            PropertyInfo pro = o = i$.next();
            DeployPropertyNode propNode = new DeployPropertyNode(BPELDesignerDeploymentFile.stripName(base, pro.getName()), pro.getValue(), false);
            ret.add(propNode);
        }
        return ret;
    }

    public List<PLProperties> getPLProperties(String partnerLinkName) {
        if (partnerLinkName == null || partnerLinkName.length() == 0) {
            return null;
        }
        List<PropertyInfo> lst = null;
        String base = "partnerLink." + partnerLinkName + ".";
        try {
            lst = this.m_scaController.getCompositeProperties(this.m_processName);
            lst = BPELDesignerDeploymentFile.filterList(base, lst);
        }
        catch (Throwable ex) {
            return null;
        }
        PLProperties p = null;
        ArrayList<PLProperties> ret = new ArrayList<PLProperties>();
        Iterator<PropertyInfo> i$ = lst.iterator();
        while (i$.hasNext()) {
            PropertyInfo o;
            PropertyInfo pro = o = i$.next();
            p = new PLProperties(BPELDesignerDeploymentFile.stripName(base, pro.getName()), pro.getValue(), pro.getType().toString());
            ret.add(p);
        }
        return ret;
    }

    public String getWSDLLocation(String partnerLinkName) {
        WsdlInfo wsdlInfo = this.m_scaController.getWsdlInfoForName(this.m_processName, partnerLinkName);
        String loc = null;
        if (wsdlInfo != null) {
            try {
                loc = wsdlInfo.getWsdlLocation();
                URI u = new URI(URIUtil.escapeURIString((String)loc));
                if (!u.isAbsolute()) {
                    loc = URLFactory.newURL((URL)this.m_scaProject.getWSDLRoot(), (String)loc).toString();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return wsdlInfo != null ? loc : null;
    }

    public void removeActivitationAgent(String partnerLinkName) {
        String base = "activationAgent." + partnerLinkName + ".";
        this.m_scaController.deleteCompositeProperty(this.m_processName, base);
    }

    public void removePLProperties(String partnerLinkName, String propName) {
        this.m_scaController.deleteCompositeProperty(this.m_processName, "partnerLink." + partnerLinkName + "." + propName);
    }

    public void save() {
        this.m_scaController.save(this.m_processName);
    }

    public void setExtraConfig(List<DeployPropertyNode> extraConfigNodeList) {
        String base = "configuration.";
        this.removeProperties(base);
        for (DeployPropertyNode propNode : extraConfigNodeList) {
            PropertyInfo pro = new PropertyInfo(base + propNode.getName(), STRINGTYPE, false, null, null, propNode.getValue());
            this.m_scaController.addComponentProperty(this.m_processName, pro);
        }
    }

    public void setPLProperties(String partnerLinkName, List<PLProperties> list) {
        String pro;
        PLProperties propName;
        PLProperties o;
        List<PLProperties> olds = this.getPLProperties(partnerLinkName);
        Iterator<PLProperties> i$ = olds.iterator();
        while (i$.hasNext()) {
            propName = o = i$.next();
            if (list.contains(o)) continue;
            pro = "partnerLink." + partnerLinkName + "." + propName.m_name;
            this.m_scaController.deleteCompositeProperty(this.m_processName, pro);
        }
        i$ = list.iterator();
        while (i$.hasNext()) {
            propName = o = i$.next();
            pro = new PropertyInfo("partnerLink." + partnerLinkName + "." + propName.m_name, STRINGTYPE, false, null, null, propName.m_value);
            this.m_scaController.addComponentProperty(this.m_processName, (PropertyInfo)pro);
        }
    }

    public static List<PropertyInfo> filterList(String start, List src) {
        ArrayList<PropertyInfo> ret = new ArrayList<PropertyInfo>();
        if (src == null) {
            return ret;
        }
        for (Object o : src) {
            PropertyInfo pro = (PropertyInfo)o;
            if (!pro.getName().startsWith(start)) continue;
            ret.add(pro);
        }
        return ret;
    }

    public static String stripName(String start, String src) {
        if (src.startsWith(start)) {
            return src.substring(start.length());
        }
        return src;
    }

    public void removeProperties(String base) {
        List<PropertyInfo> lst = this.m_scaController.getCompositeProperties(this.m_processName);
        lst = BPELDesignerDeploymentFile.filterList(base, lst);
        Iterator<PropertyInfo> i$ = lst.iterator();
        while (i$.hasNext()) {
            PropertyInfo o;
            PropertyInfo pro = o = i$.next();
            this.m_scaController.deleteCompositeProperty(this.m_processName, pro.getName());
        }
    }

    public void setProperty(String name, String value, QName type) {
        try {
            if (!this.m_scaController.isNameUniqueWithinComposite(this.m_processName)) {
                PropertyInfo pro = new PropertyInfo(name, type, false, null, null, value);
                PropertyInfo o = this.m_scaController.getCompositePropertyInfo(this.m_processName, name);
                if (o != null) {
                    this.m_scaController.deleteCompositeProperty(this.m_processName, name);
                }
                this.m_scaController.addComponentProperty(this.m_processName, pro);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, value, STRINGTYPE);
    }

    public String getProperty(String name) {
        PropertyInfo info = this.m_scaController.getCompositePropertyInfo(this.m_processName, name);
        if (info == null) {
            return null;
        }
        return info.getValue();
    }

    public void deleteProperty(String name) {
        PropertyInfo info = this.m_scaController.getCompositePropertyInfo(this.m_processName, name);
        if (info != null) {
            this.m_scaController.deleteCompositeProperty(this.m_processName, name);
        }
    }
}

