/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.bpel.services.rules.rpi.model.TParameter;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.FileUtils;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleExplorerTree;
import oracle.tip.tools.ide.pm.modules.rules.wizard.AbstractDecisionServiceWizardHelper;
import oracle.tip.tools.ide.pm.modules.rules.wizard.FunctionPanel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.FunctionParamTableModel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.PatternPage;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetPanel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetParamTableModel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.SchemaImportPage;

public class ServiceNamePage
extends JPanel
implements ActionListener,
DocumentListener,
WizardValidateListener,
TableModelListener {
    private AbstractDecisionServiceWizardHelper m_wcontext;
    private Wizard m_wizard;
    private ImageWizardPage m_page;
    private SchemaImportPage m_schemaImportPage = null;
    private JTextField m_nameField = new JTextField();
    private JTextField m_namespaceField = new JTextField();
    private JTextField m_rulesetField = new JTextField();
    JComboBox m_patternCB;
    JButton m_ruleBrowseBtn;
    JPanel m_funcPanel;
    JTextField m_retField = new JTextField();
    JLabel m_funcDescLabel = new JLabel();
    JTable m_functionFactTable;
    JTable m_rulesetFactTable;
    JLabel m_rulesetLbl = new JLabel();
    JLabel m_functionLbl = new JLabel();
    String m_functionLblStr = BPELStringTranslator.getString("DLG_LBL_FUNCTION");
    String m_rulesetLblStr = BPELStringTranslator.getString("DLG_LBL_RULESET");
    RulesetPanel m_rulesPanel;
    RulesetParamTableModel m_model;
    PatternName m_patternName = PatternName.CALL_FUNCTION_STATEFUL;

    public ServiceNamePage(AbstractDecisionServiceWizardHelper wcontext, ImageWizardPage iwp) {
        this(wcontext, iwp, false);
    }

    public ServiceNamePage(AbstractDecisionServiceWizardHelper wcontext, ImageWizardPage iwp, boolean isEditing) {
        this.m_wcontext = wcontext;
        this.m_patternCB = new JComboBox(PatternName.getPatternNames());
        this.m_wizard = this.m_wcontext.getWizard();
        this.m_page = iwp;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "bpmjdev_dec_wizard");
        this.m_wizard.addPage((WizardPage)this.m_page);
        this.m_wcontext.addFinishPage();
        this.m_page.setInteractiveArea((Component)this);
        this.m_page.addWizardValidateListener((WizardValidateListener)this);
        this.jbInit(isEditing);
        if (isEditing) {
            this.parseContext();
        }
    }

    private void parseContext() {
        this.m_patternName = (PatternName)this.m_wcontext.getPatternList().get(0);
        this.m_patternCB.setSelectedItem(this.m_patternName);
        if (this.m_patternName == PatternName.CALL_FUNCTION_STATEFUL || this.m_patternName == PatternName.CALL_FUNCTION_STATELESS) {
            this.handleFunctionSelected(this.m_wcontext.getFunction());
        } else {
            this.handleRulesetSelected(this.m_wcontext.getRuleSet());
        }
    }

    private void jbInit(boolean isEditing) {
        String serviceName;
        JLabel nameLbl = new JLabel(BPELStringTranslator.getString("DLG_LBL_SERVICE_NAME"));
        JLabel namespaceLbl = new JLabel(BPELStringTranslator.getString("BPEL_NAMESPACE"));
        JLabel patternLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)this.m_rulesetLbl, (Component)this.m_rulesetField, (String)this.m_rulesetLblStr);
        ResourceUtils.resLabel((JLabel)this.m_functionLbl, (Component)this.m_rulesetField, (String)this.m_functionLblStr);
        this.m_rulesetField.setEditable(false);
        this.m_ruleBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BTN_TOOLTIP_BROWSE_RULESET"));
        this.m_ruleBrowseBtn.addActionListener(this);
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)patternLbl, (Component)this.m_patternCB, (String)BPELStringTranslator.getString("DLG_LBL_RULESET_PATTERN"));
        ResourceUtils.resLabel((JLabel)nameLbl, (Component)this.m_nameField, (String)BPELStringTranslator.getString("DLG_LBL_SERVICE_NAME"));
        ResourceUtils.resLabel((JLabel)namespaceLbl, (Component)this.m_namespaceField, (String)BPELStringTranslator.getString("BPEL_NAMESPACE"));
        this.m_patternCB.setSelectedItem(this.m_patternName);
        this.m_patternCB.addActionListener(this);
        this.m_rulesetLbl.setVisible(false);
        this.m_funcPanel = this.createFuncPanel();
        this.m_funcPanel.setVisible(false);
        this.m_rulesPanel = this.createRulesPanel();
        this.m_rulesPanel.setNextPageSelected(this.m_wcontext.getPatternList().size() > 1);
        this.m_rulesPanel.setVisible(false);
        int y = 0;
        this.add((Component)nameLbl, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 5, 5), 0, 0));
        this.add((Component)this.m_nameField, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)namespaceLbl, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_namespaceField, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)patternLbl, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_patternCB, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_rulesetLbl, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_functionLbl, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_rulesetField, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_ruleBrowseBtn, new GridBagConstraints(4, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)this.m_funcPanel, new GridBagConstraints(0, ++y, 0, 0, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_rulesPanel, new GridBagConstraints(0, y, 0, 0, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
        JLabel dummy = new JLabel(" ");
        this.add((Component)dummy, new GridBagConstraints(0, ++y, 0, 0, 1.0, 1.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        String fileName = FileUtils.generateUniqFilename((String)this.m_wcontext.getPrjURL().getFile(), (String)"DecisionService.wsdl");
        if (!isEditing) {
            serviceName = fileName.substring(0, fileName.indexOf("."));
        } else {
            serviceName = this.m_wcontext.getName();
            this.m_nameField.setEnabled(false);
            this.m_namespaceField.setEnabled(false);
        }
        this.m_nameField.setText(serviceName);
        this.m_wcontext.setNameSpace(this.m_wcontext.getProcessNamespace() + "/" + serviceName);
        this.m_namespaceField.setText(this.m_wcontext.getNameSpace());
        this.m_nameField.getDocument().addDocumentListener(this);
        this.m_page.setCanAdvance(false);
    }

    private void setFuncDescription() {
        TFunction func = this.m_wcontext.getFunction();
        FunctionParamTableModel model = (FunctionParamTableModel)this.m_functionFactTable.getModel();
        model.setFunction(func);
        TParameter retParam = func.getReturn();
        if (retParam != null) {
            this.m_retField.setText(retParam.getType().getDisplayName());
        } else {
            this.m_retField.setText("void");
        }
    }

    private JPanel createFuncPanel() {
        FunctionPanel panel = new FunctionPanel();
        this.m_functionFactTable = panel.getFactTable();
        this.m_retField = panel.getReturnField();
        return panel;
    }

    private RulesetPanel createRulesPanel() {
        RulesetPanel panel = new RulesetPanel(true);
        this.m_rulesetFactTable = panel.getFactTable();
        this.m_model = (RulesetParamTableModel)this.m_rulesetFactTable.getModel();
        this.m_model.addTableModelListener(this);
        return panel;
    }

    private void checkDoc() {
        String serviceName = this.m_nameField.getText().trim();
        this.m_page.setCanAdvance(!serviceName.equals(""));
        this.m_wcontext.setNameSpace(this.m_wcontext.getProcessNamespace() + "/" + serviceName);
        this.m_namespaceField.setText(this.m_wcontext.getNameSpace());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.m_page.setCanAdvance(this.m_model.isFactSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RuleExplorerTree frame;
        this.m_patternName = (PatternName)this.m_patternCB.getSelectedItem();
        this.m_wcontext.getPatternList().remove(0);
        this.m_wcontext.getPatternList().insertElementAt(this.m_patternName, 0);
        if (e.getSource() == this.m_patternCB) {
            this.handlePatternSelectionChange();
        } else if (e.getSource() == this.m_ruleBrowseBtn && (frame = this.m_wcontext.getRuleExplorerTree(this.m_patternName, GraphUtils.getFrame((Component)this))).display() == 0) {
            this.m_wcontext.setCatalog(frame.getRuleCatalog());
            this.m_wcontext.clearDataModel();
            this.m_wcontext.repoDir = frame.getRuleRepositoryLocation();
            if (this.m_patternName == PatternName.CALL_FUNCTION_STATELESS || this.m_patternName == PatternName.CALL_FUNCTION_STATEFUL) {
                this.handleFunctionSelected(frame.getFunction());
            } else {
                this.handleRulesetSelected(frame.getRuleSet());
            }
        }
    }

    private void handleRulesetSelected(IRuleSet ruleSet) {
        this.m_wcontext.setRuleSet(ruleSet);
        this.m_rulesetField.setText(this.m_wcontext.getRuleSet().getName());
        this.setRulesetFacts();
        this.m_rulesPanel.setVisible(true);
        if (!this.m_wcontext.isEditMode()) {
            this.m_wcontext.getPatternList().clear();
            this.m_wcontext.getPatternList().add(this.m_patternName);
        }
        this.m_wcontext.removePages();
        ImageWizardPage iwp = new ImageWizardPage(null, AbstractDecisionServiceWizardHelper._image, BPELStringTranslator.getString("WIZARD_PAGE_TITLE_XSD_FILES"));
        new SchemaImportPage(this.m_wcontext, iwp);
    }

    private void handleFunctionSelected(TFunction function) {
        this.m_wcontext.setFunction(function);
        this.m_rulesetField.setText(this.m_wcontext.getFunction().getName());
        this.setFuncDescription();
        this.m_funcPanel.setVisible(true);
        this.m_page.setCanAdvance(true);
    }

    private void handlePatternSelectionChange() {
        this.m_page.setCanAdvance(false);
        if (this.m_patternName == PatternName.CALL_FUNCTION_STATELESS || this.m_patternName == PatternName.CALL_FUNCTION_STATEFUL) {
            this.m_rulesetLbl.setVisible(false);
            this.m_functionLbl.setVisible(true);
            this.m_rulesPanel.setVisible(false);
            this.m_wcontext.getPatternList().clear();
            this.m_wcontext.getPatternList().add(this.m_patternName);
        } else {
            this.m_rulesetLbl.setVisible(true);
            this.m_functionLbl.setVisible(false);
            this.m_funcPanel.setVisible(false);
            this.setRulesetFacts();
        }
    }

    private void setRulesetFacts() {
        if (this.m_wcontext.getRuleSet() == null) {
            return;
        }
        this.m_model = this.m_wcontext.getDataModel(this.m_patternName);
        if (this.m_model == null) {
            this.m_model = new RulesetParamTableModel(this.m_patternName);
            this.m_rulesetFactTable.setModel(this.m_model);
            this.m_rulesPanel.setRulesetFacts(this.m_wcontext.getRuleSet());
        } else {
            RulesFact fact;
            String assertXPath;
            this.m_rulesetFactTable.setModel(this.m_model);
            Vector data = this.m_model.getData();
            boolean flag = false;
            if (data.size() > 0 && (assertXPath = (fact = (RulesFact)data.get(0)).getAssertXPath()) != null && assertXPath.equals("//*")) {
                flag = true;
            }
            this.m_rulesPanel.setAssertXPath(flag);
        }
        this.m_model.removeTableModelListener(this);
        this.m_model.addTableModelListener(this);
        this.m_page.setCanAdvance(this.m_model.isFactSelected());
    }

    public void wizardValidatePage(WizardEvent p1) {
        ImageWizardPage iwp;
        this.m_wcontext.setName(this.m_nameField.getText());
        this.m_wcontext.setDataModel(this.m_patternName, this.m_model);
        if (!this.m_wcontext.isEditMode()) {
            this.m_wcontext.getPatternList().clear();
            this.m_wcontext.getPatternList().add(this.m_patternName);
        }
        this.m_wcontext.removePages();
        if (this.m_rulesPanel.isNextPage()) {
            iwp = new ImageWizardPage(null, AbstractDecisionServiceWizardHelper._image, BPELStringTranslator.getString("WIZARD_PAGE_TITLE_ADD_PATTERN"));
            new PatternPage(this.m_wcontext, iwp, 2);
        } else {
            iwp = new ImageWizardPage(null, AbstractDecisionServiceWizardHelper._image, BPELStringTranslator.getString("WIZARD_PAGE_TITLE_XSD_FILES"));
            this.m_schemaImportPage = new SchemaImportPage(this.m_wcontext, iwp);
        }
        String assertXPath = null;
        if (this.m_rulesPanel.isAssertXPath()) {
            assertXPath = "//*";
        }
        Vector factData = this.m_model.getData();
        for (int i = 0; i < factData.size(); ++i) {
            RulesFact fact = (RulesFact)factData.get(i);
            fact.setAssertXPath(assertXPath);
        }
    }
}

