/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.model.TFactType;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.model.TRuleEngineRepositoryType;
import oracle.bpel.services.rules.rpi.model.TXmlFactType;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.wizard.AbstractDecisionServiceWizardHelper;

public class SchemaImportPage
extends JPanel
implements ActionListener,
WizardValidateListener {
    private AbstractDecisionServiceWizardHelper m_wcontext;
    private Wizard m_wizard;
    private ImageWizardPage m_page;
    private Icon browseIcon = null;
    JTable jNotFoundTable = null;
    String dependentFilesCopyStr;
    String notFoundStr;
    JLabel notFoundLbl;
    JLabel importLbl;
    JList jSchemaList = null;

    public SchemaImportPage(AbstractDecisionServiceWizardHelper wcontext, ImageWizardPage iwp) {
        this.m_wcontext = wcontext;
        this.m_wizard = this.m_wcontext.getWizard();
        this.m_page = iwp;
        this.m_wizard.addPage((WizardPage)this.m_page);
        this.m_page.setCanAdvance(false);
        this.m_wcontext.addFinishPage();
        this.m_page.setInteractiveArea((Component)this);
        this.m_page.addWizardValidateListener((WizardValidateListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "bpm_jdev_wizard_xsd");
        this.setSchemaFileLists();
        this.m_wcontext.initRulesXSDDir();
        this.createControls();
        this.layoutControls();
        if (this.jNotFoundTable != null) {
            ((XSDFilesTableModel)this.jNotFoundTable.getModel()).fireTableDataChanged();
        }
    }

    private void createControls() {
        this.browseIcon = GlobalImageCache.getIcon((String)"browse16");
        this.notFoundStr = BPELStringTranslator.formatString("DLG_MSG_RULE_XSD_NOT_FOUND", this.m_wcontext.getTargetURL().getFile());
        this.dependentFilesCopyStr = BPELStringTranslator.formatString("DLG_MSG_RULE_XSD_IMPORT_INSTR", this.m_wcontext.getTargetURL().getFile());
        this.notFoundLbl = new JLabel(this.notFoundStr);
        this.importLbl = new JLabel(this.dependentFilesCopyStr);
        if (this.m_wcontext.getXsdFilesNotFound() != null && this.m_wcontext.getXsdFilesNotFound().size() > 0) {
            XSDFilesTableModel model = new XSDFilesTableModel(this.m_wcontext.getXsdFilesNotFound());
            this.jNotFoundTable = new JTable(model);
            this.setColumnSizes(this.jNotFoundTable);
            this.jNotFoundTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point origin = e.getPoint();
                    int row = SchemaImportPage.this.jNotFoundTable.rowAtPoint(origin);
                    int column = SchemaImportPage.this.jNotFoundTable.columnAtPoint(origin);
                    if (row == -1) {
                        return;
                    }
                    if (column == 1) {
                        SchemaImportPage.this.handleChooserSelected(row);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        if (this.m_wcontext.getXsdFiles() != null && this.m_wcontext.getXsdFiles().size() > 0) {
            this.jSchemaList = new JList(this.m_wcontext.getXsdFiles());
            this.jSchemaList.setVisibleRowCount(Math.max(this.m_wcontext.getXsdFiles().size() + 1, 4));
        }
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        if (this.jSchemaList != null) {
            GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.jSchemaList), (int)0, (int)y++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        }
        if (this.jNotFoundTable != null) {
            GraphUtils.addComponent((Container)this, (Component)this.notFoundLbl, (int)0, (int)y++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
            JScrollPane pane = new JScrollPane(this.jNotFoundTable);
            pane.setAutoscrolls(true);
            GraphUtils.addComponent((Container)this, (Component)pane, (int)0, (int)y++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        }
        GraphUtils.addComponent((Container)this, (Component)this.importLbl, (int)0, (int)y++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private void setColumnSizes(JTable table) {
        TableColumnModel colModel = table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setPreferredWidth(120);
                continue;
            }
            if (i != 1) continue;
            col.setMinWidth(30);
            col.setMaxWidth(30);
            ImageColumnTableCellRenderer renderer = new ImageColumnTableCellRenderer(this.browseIcon);
            renderer.setToolTipText(BPELStringTranslator.getString("RULE_XSD_IMPORT_TOOLTIP"));
            col.setCellRenderer((TableCellRenderer)renderer);
        }
    }

    protected void handleChooserSelected(int row) {
    }

    private void setFileCopied(int row) {
        XSDFilesTableModel model = (XSDFilesTableModel)this.jNotFoundTable.getModel();
        model.setFileCopiedAtRow(row);
    }

    private void setSchemaFileLists() {
        List factNameList = this.m_wcontext.getFacts();
        URL repoDirURL = null;
        if (factNameList == null || factNameList.size() == 0) {
            return;
        }
        Hashtable<URL, URL> fileHash = new Hashtable<URL, URL>();
        Hashtable<String, String> notFoundFileHash = new Hashtable<String, String>();
        TRuleEngineProvider provider = this.m_wcontext.getCatalog().getRuleEngine().getProvider();
        try {
            if (provider.getRepository().getType().value().equals(TRuleEngineRepositoryType.FILE.value())) {
                URL repoURL = new File(provider.getRepository().getFile()).toURL();
                repoDirURL = URLFileSystem.getParent((URL)repoURL);
            }
            IDataModel dataModel = this.m_wcontext.getCatalog().getDataModel();
            List factList = dataModel.getFactTypes();
            block2: for (int i = 0; i < factNameList.size(); ++i) {
                String factName = (String)factNameList.get(i);
                for (int j = 0; j < factList.size(); ++j) {
                    TFactType fact = (TFactType)factList.get(j);
                    String dataModelFactName = fact.getName();
                    if (!dataModelFactName.equals(factName) || !(fact instanceof TXmlFactType)) continue;
                    TXmlFactType xmlFact = (TXmlFactType)fact;
                    String srcSchemaLocation = xmlFact.getSchemaLocation();
                    URL srcURL = new URL(srcSchemaLocation);
                    if (URLFileSystem.exists((URL)srcURL)) {
                        fileHash.put(srcURL, srcURL);
                        continue block2;
                    }
                    if (repoDirURL == null) {
                        this.m_wcontext.getXsdFilesNotFound().add(srcSchemaLocation);
                        continue;
                    }
                    File file = new File(srcSchemaLocation);
                    String fileName = file.getName();
                    srcURL = new URL(repoDirURL, fileName);
                    if (URLFileSystem.exists((URL)srcURL)) {
                        fileHash.put(srcURL, srcURL);
                        continue block2;
                    }
                    notFoundFileHash.put(srcSchemaLocation, srcSchemaLocation);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_wcontext.setXsdFilesNotFound(new Vector(notFoundFileHash.values()));
        this.m_wcontext.setXsdFiles(new Vector(fileHash.values()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void wizardValidatePage(WizardEvent p1) {
    }

    public void updateNextButton(boolean b) {
        this.m_page.setCanAdvance(b);
    }

    private boolean fileExists(URL targeturl, String name) {
        if (targeturl == null || name == null) {
            return false;
        }
        try {
            boolean exists = URLFileSystem.exists((URL)new URL(targeturl, name));
            return exists;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private URL showResourcePicker(int type) {
        int filter = 12;
        switch (type) {
            case 0: {
                filter = 0;
                break;
            }
        }
        return UIHelper.showResourcePicker((Component)this, (int)filter);
    }

    class FileData {
        String name;
        boolean xsdCopied = false;

        public FileData(String name) {
            this(name, false);
        }

        public void setXSDCopied(boolean b) {
            this.xsdCopied = b;
        }

        public FileData(String fileName, boolean copied) {
            this.name = fileName;
            this.xsdCopied = copied;
        }

        public String getName() {
            File file = new File(this.name);
            return file.getName();
        }
    }

    class XSDFilesTableModel
    extends AbstractTableModel {
        private static final int NAME_COL = 0;
        private static final int CHOOSER_COL = 1;
        private static final String DUMMY_STRING = " ";
        protected Vector m_data = new Vector();

        public XSDFilesTableModel(Vector data) {
            this.loadTableModel(data);
        }

        public void setFileCopiedAtRow(int row) {
            FileData data = (FileData)this.m_data.get(row);
            data.setXSDCopied(true);
            this.updateTableRow(data, row);
        }

        public Vector getData() {
            return this.m_data;
        }

        public void setData(Vector v) {
            this.m_data = v;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.m_data.size();
        }

        public void removeRows(int[] rows) {
            if (rows != null && rows.length > 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.m_data.removeElementAt(rows[i]);
                }
                this.fireTableDataChanged();
            }
        }

        private void loadTableModel(Vector data) {
            for (int count = 0; count < data.size(); ++count) {
                this.m_data.add(new FileData(data.get(count).toString()));
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BPELStringTranslator.getString("RULE_XSD_SCHEMA_COL_NAME");
                }
                case 1: {
                    return "";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int pRowIndex, int pColumnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileData value = (FileData)this.m_data.get(row);
            if (col == 0) {
                if (value == null) {
                    return DUMMY_STRING;
                }
                return value.getName();
            }
            return "";
        }

        public void deleteRow(int row) {
            this.m_data.remove(row);
            this.fireTableDataChanged();
        }

        private void updateTableRow(FileData s, int row) {
            this.m_data.removeElementAt(row);
            this.m_data.add(row, s);
            this.fireTableDataChanged();
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            boolean b = this.areAllXSDSCopied();
            SchemaImportPage.this.updateNextButton(b);
        }

        private boolean areAllXSDSCopied() {
            for (int count = 0; count < this.m_data.size(); ++count) {
                FileData data = (FileData)this.m_data.get(count);
                if (data == null || SchemaImportPage.this.fileExists(SchemaImportPage.this.m_wcontext.getTargetURL(), data.getName())) continue;
                return false;
            }
            return true;
        }
    }
}

