/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;

public class RulesetParamTableModel
extends AbstractTableModel {
    private Vector m_data;
    public static int INPUT = 1;
    public static int OUTPUT = 2;
    public static int INOUT = 3;
    private int m_type = INOUT;

    public RulesetParamTableModel(PatternName patternName) {
        int type = INOUT;
        if (patternName == PatternName.ASSERT || patternName == PatternName.ASSERT_EXECUTE) {
            type = INPUT;
        } else if (patternName == PatternName.WATCH) {
            type = OUTPUT;
        }
        this.m_data = new Vector();
        this.m_type = type;
    }

    public RulesetParamTableModel(int type) {
        this.m_data = new Vector();
        this.m_type = type;
    }

    public Vector getData() {
        return this.m_data;
    }

    public void setData(Vector v) {
        this.m_data = v;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0;
    }

    public boolean isFactSelected() {
        boolean isInput = false;
        boolean isOutput = false;
        int rowCount = this.getRowCount();
        for (int j = 0; j < rowCount; ++j) {
            isInput = isInput || ((RulesFact)this.m_data.get(j)).isInput();
            boolean bl = isOutput = isOutput || ((RulesFact)this.m_data.get(j)).isOutput();
            if (!isInput || !isOutput) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        if (this.m_type == 1 || this.m_type == 2) {
            return 2;
        }
        return 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return ((RulesFact)this.m_data.get(row)).getFact().getDisplayName();
        }
        if (col == 1 && this.m_type != OUTPUT) {
            return ((RulesFact)this.m_data.get(row)).isInput();
        }
        return ((RulesFact)this.m_data.get(row)).isOutput();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (col == 1 && this.m_type != OUTPUT) {
            ((RulesFact)this.m_data.get(row)).setInput((Boolean)obj);
        } else {
            ((RulesFact)this.m_data.get(row)).setOutput((Boolean)obj);
        }
        this.fireTableCellUpdated(row, col);
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return BPELStringTranslator.getString("DLG_COL_TITLE_FACT_NAME");
        }
        if (col == 2 || this.m_type == OUTPUT) {
            return BPELStringTranslator.getString("DLG_COL_TITLE_FACT_OUTPUT");
        }
        if (col == 1) {
            return BPELStringTranslator.getString("DLG_COL_TITLE_FACT_INPUT");
        }
        return "Column " + col;
    }
}

