/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.model.TFactType;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetParamTableModel;

public class RulesetPanel
extends JPanel {
    private Vector m_factVector = new Vector();
    private JTable m_factTable = new JTable(new RulesetParamTableModel(RulesetParamTableModel.INOUT)){

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                if (vColIndex == 0) {
                    jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                }
            }
            return c;
        }
    };
    private JCheckBox m_addNextBox = new JCheckBox(BPELStringTranslator.getString("DLG_CHK_ADD_MORE_PATTERNS"), false);
    private JCheckBox m_assertXPathBox = new JCheckBox(BPELStringTranslator.getString("DLG_CHK_USE_ASSERTXPATH"), false);

    public RulesetPanel(boolean isNextPageAllowed) {
        this.setLayout(new GridBagLayout());
        this.add((Component)GraphUtils.getScrollPane((Component)this.m_factTable), new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 11, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_assertXPathBox, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
    }

    public boolean isNextPage() {
        return this.m_addNextBox.isSelected();
    }

    public boolean isAssertXPath() {
        return this.m_assertXPathBox.isSelected();
    }

    public void setAssertXPath(boolean flag) {
        this.m_assertXPathBox.setSelected(flag);
    }

    public void setNextPageSelected(boolean flag) {
        this.m_addNextBox.setSelected(flag);
    }

    public JTable getFactTable() {
        return this.m_factTable;
    }

    public void setRulesetFacts(IRuleSet ruleSet) {
        try {
            this.m_factVector.clear();
            IDataModel dataModel = ruleSet.getDataModel();
            List factList = dataModel.getFactTypes();
            for (int i = 0; i < factList.size(); ++i) {
                TFactType fact = (TFactType)factList.get(i);
                this.m_factVector.add(new RulesFact(fact));
            }
            ((RulesetParamTableModel)this.m_factTable.getModel()).setData(this.m_factVector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

