/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;
import oracle.tip.tools.ide.pm.modules.rules.wizard.AbstractDecisionServiceWizardHelper;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetPanel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetParamTableModel;
import oracle.tip.tools.ide.pm.modules.rules.wizard.SchemaImportPage;

public class PatternPage
extends JPanel
implements ActionListener,
WizardValidateListener,
TableModelListener {
    private AbstractDecisionServiceWizardHelper m_wcontext;
    private Wizard m_wizard;
    private ImageWizardPage m_page;
    private JComboBox m_patternCB;
    private PatternName m_patternName;
    private RulesetPanel m_rulesPanel;
    private JTable m_rulesetFactTable;
    private RulesetParamTableModel m_model;
    private int m_pageNum;

    public PatternPage(AbstractDecisionServiceWizardHelper wcontext, ImageWizardPage iwp, int pageNum) {
        this.m_pageNum = pageNum;
        this.m_wcontext = wcontext;
        Vector patternNames = this.m_wcontext.getPatternNames();
        patternNames.remove(PatternName.CALL_FUNCTION_STATELESS);
        patternNames.remove(PatternName.CALL_FUNCTION_STATEFUL);
        this.m_patternCB = new JComboBox(patternNames);
        this.m_patternCB.addActionListener(this);
        this.m_patternName = (PatternName)this.m_patternCB.getItemAt(0);
        this.m_wizard = this.m_wcontext.getWizard();
        this.m_page = iwp;
        this.m_wizard.addPage((WizardPage)this.m_page);
        this.m_wcontext.addFinishPage();
        this.m_page.setInteractiveArea((Component)this);
        this.m_page.addWizardValidateListener((WizardValidateListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "bpm_jdev_wizard_patten");
        this.jbInit(this.m_wcontext.isEditMode());
    }

    private void jbInit(boolean isEditing) {
        this.setLayout(new GridBagLayout());
        JLabel patternLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)patternLbl, (Component)this.m_patternCB, (String)BPELStringTranslator.getString("DLG_LBL_INVOKE_PATTERN"));
        this.m_rulesPanel = this.createRulesPanel();
        this.add((Component)patternLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(15, 10, 5, 5), 0, 0));
        this.add((Component)this.m_patternCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 10, 5, 5), 0, 0));
        this.add((Component)this.m_rulesPanel, new GridBagConstraints(0, 1, 0, 0, 1.0, 1.0, 11, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.setRulesetFacts();
        if (this.m_wcontext.isEditMode() && this.m_wcontext.getPatternList().size() >= this.m_pageNum) {
            this.m_patternCB.addItem(this.m_wcontext.getPatternList().get(this.m_pageNum - 1));
            this.m_patternCB.setSelectedItem(this.m_wcontext.getPatternList().get(this.m_pageNum - 1));
            if (this.m_wcontext.getPatternList().size() > this.m_pageNum) {
                this.m_rulesPanel.setNextPageSelected(true);
            }
        }
    }

    private RulesetPanel createRulesPanel() {
        RulesetPanel panel = new RulesetPanel(this.m_patternCB.getItemCount() > 1);
        this.m_rulesetFactTable = panel.getFactTable();
        this.m_model = (RulesetParamTableModel)this.m_rulesetFactTable.getModel();
        return panel;
    }

    private void setRulesetFacts() {
        if (this.m_wcontext.getRuleSet() == null) {
            return;
        }
        this.m_model = this.m_wcontext.getDataModel(this.m_patternName);
        if (this.m_model == null) {
            this.m_model = new RulesetParamTableModel(this.m_patternName);
            this.m_wcontext.setDataModel(this.m_patternName, this.m_model);
            this.m_rulesetFactTable.setModel(this.m_model);
            this.m_rulesPanel.setRulesetFacts(this.m_wcontext.getRuleSet());
        } else {
            RulesFact fact;
            String assertXPath;
            this.m_rulesetFactTable.setModel(this.m_model);
            Vector data = this.m_model.getData();
            boolean flag = false;
            if (data.size() > 0 && (assertXPath = (fact = (RulesFact)data.get(0)).getAssertXPath()) != null && assertXPath.equals("//*")) {
                flag = true;
            }
            this.m_rulesPanel.setAssertXPath(flag);
            this.m_page.setCanAdvance(true);
        }
        this.m_model.removeTableModelListener(this);
        this.m_model.addTableModelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_patternCB) {
            this.m_patternName = (PatternName)this.m_patternCB.getSelectedItem();
            if (this.m_wcontext.getPatternList().size() > this.m_pageNum - 1) {
                this.m_wcontext.getPatternList().remove(this.m_pageNum - 1);
            }
            this.m_wcontext.getPatternList().insertElementAt(this.m_patternName, this.m_pageNum - 1);
            this.setRulesetFacts();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean canAdvance = false;
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            canAdvance = (Boolean)this.m_model.getValueAt(i, 1);
            if (this.m_model.getColumnCount() > 2) {
                boolean bl = canAdvance = canAdvance || (Boolean)this.m_model.getValueAt(i, 2) != false;
            }
            if (canAdvance) break;
        }
        this.m_page.setCanAdvance(canAdvance);
    }

    public void wizardValidatePage(WizardEvent p1) {
        ImageWizardPage iwp;
        if (!this.m_wcontext.isEditMode()) {
            for (int i = this.m_pageNum - 1; i < this.m_wcontext.getPatternList().size(); ++i) {
                this.m_wcontext.getPatternList().remove(i);
            }
            this.m_wcontext.getPatternList().add(this.m_patternName);
        }
        this.m_wcontext.removePages();
        if (this.m_rulesPanel.isNextPage()) {
            iwp = new ImageWizardPage(null, AbstractDecisionServiceWizardHelper._image, BPELStringTranslator.getString("WIZARD_PAGE_TITLE_ADD_PATTERN"));
            new PatternPage(this.m_wcontext, iwp, this.m_pageNum + 1);
        } else {
            iwp = new ImageWizardPage(null, AbstractDecisionServiceWizardHelper._image, BPELStringTranslator.getString("WIZARD_PAGE_TITLE_XSD_FILES"));
            new SchemaImportPage(this.m_wcontext, iwp);
        }
        String assertXPath = null;
        if (this.m_rulesPanel.isAssertXPath()) {
            assertXPath = "//*";
        }
        Vector factData = this.m_model.getData();
        for (int i = 0; i < factData.size(); ++i) {
            RulesFact fact = (RulesFact)factData.get(i);
            fact.setAssertXPath(assertXPath);
        }
    }
}

