/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.bpel.services.rules.rpi.model.TParameter;
import oracle.bpel.services.rules.rpi.model.TParameterList;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class FunctionParamTableModel
extends AbstractTableModel {
    private List paramList;

    public FunctionParamTableModel(TFunction func) {
        if (func != null) {
            TParameterList list = func.getParameters();
            this.paramList = list.getParameters();
        }
    }

    public void setFunction(TFunction func) {
        TParameterList list = func.getParameters();
        this.paramList = list.getParameters();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.paramList != null) {
            return this.paramList.size();
        }
        return 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        assert (this.paramList != null);
        if (this.paramList == null) {
            return null;
        }
        TParameter param = (TParameter)this.paramList.get(row);
        if (col == 0) {
            return param.getDisplayName();
        }
        return param.getType().getDisplayName();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return BPELStringTranslator.getString("DLG_LBL_IN_PARAM");
        }
        return BPELStringTranslator.getString("DLG_LBL_RET_PARAM");
    }
}

