/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TArgumentList;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProviderName;
import oracle.bpel.services.rules.util.DecisionServiceBuilder;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAInvalidFileNameException;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.DecisionServiceConstants;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleExplorerTree;
import oracle.tip.tools.ide.pm.modules.rules.wizard.AbstractDecisionServiceWizardHelper;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetParamTableModel;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAException;

public class BPELWizardContext
extends AbstractDecisionServiceWizardHelper {
    public BPELGraphPane m_pane;
    public BPELProject m_prj;
    public SwimLaneNode m_swimLaneNode;
    public URL m_targetURL;
    private PartnerLink m_partnerLink;
    protected String partnerLinkUrl;
    public TitledWizardPage _finish_page;

    public BPELWizardContext(TDecisionService service, DecisionServices services, BPELGraphPane pane) {
        this.b_edit = true;
        try {
            String rulesetName = service.getRuleset();
            DecisionServiceBuilder ds = new DecisionServiceBuilder(services);
            String providerRef = service.getRuleEngineProviderReference();
            TRuleEngineProvider provider = ds.getRuleEngineProvider(providerRef);
            RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
            IRuleEngine ruleEngine = rpi_factory.createRuleEngine(provider);
            String catalogName = service.getCatalog();
            String catalogVersion = service.getCatalogVersion();
            this.m_catalog = ruleEngine.getRuleCatalog(catalogName, catalogVersion);
            this.m_ruleSet = this.m_catalog.getRuleSet(rulesetName);
            List patternList = service.getPatterns();
            for (TPattern tPattern : patternList) {
                PatternName patternName = PatternName.getPatternName(tPattern);
                if (tPattern.getName().value() == PatternName.CALL_FUNCTION_STATELESS.getXMLName()) {
                    TArgumentList tArgList = tPattern.getArguments();
                    String functionName = tArgList.getCall();
                    this.m_function = this.m_catalog.getDataModel().getFunction(functionName);
                    this.m_patternList.add(patternName);
                    continue;
                }
                if (tPattern.getName().value() != PatternName.ASSERT_EXECUTE_WATCH_STATEFUL.getXMLName()) continue;
                this.setRuleSetPattern(tPattern);
                this.m_patternList.add(PatternName.ASSERT_EXECUTE_WATCH_STATEFUL);
            }
            this.m_patternName = (PatternName)this.m_patternList.get(0);
            this.m_name = service.getName();
            this.m_pane = pane;
            this.m_swimLaneNode = ((BPELGraphModel)this.m_pane.getModel()).getLeftSwimLaneNode();
            List plList = ((BPELGraphModel)this.m_pane.getModel()).getProcess().getPartnerLinks().getPartnerLinks();
            List propList = null;
            boolean found = false;
            for (PartnerLink pl : plList) {
                BPELProject prj = ((BPELGraphModel)this.m_pane.getModel()).getBPELProject();
                DeploymentFile depFile = prj.getDeploymentFile();
                if (depFile != null) {
                    propList = depFile.getPLProperties(pl.getName());
                }
                if (propList == null) continue;
                for (int i = 0; i < propList.size(); ++i) {
                    PLProperties prop = (PLProperties)propList.get(i);
                    if (!prop.m_name.equals("DecisionService") || !prop.m_value.equals(this.m_name)) continue;
                    this.m_partnerLink = pl;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BPELWizardContext() {
        this.m_patternList.add(PatternName.CALL_FUNCTION_STATELESS);
    }

    @Override
    public void removePages() {
        int rcnt = this._wizard.getCurrentPageIndex();
        for (int pcnt = this._wizard.getPageCount() - 1; rcnt < pcnt; --pcnt) {
            WizardPage temppage = this._wizard.getPageAt(pcnt);
            this._wizard.removePage(temppage);
        }
    }

    @Override
    public void addFinishPage() {
        this._finish_page = new TitledWizardPage(null, _image, BPELStringTranslator.getString("WIZARD_FINISH"), null);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._finish_page.getContent(), "bpmjdev_dec_wizard_finish");
        this._wizard.addPage((WizardPage)this._finish_page);
        String finishPageStr1 = BPELStringTranslator.getString("RULE_FINISH_MSG");
        try {
            URL wsdlURL = new URL(this.m_prjURL, "decision/" + this.m_name + ".wsdl");
            String msgStr = BPELStringTranslator.formatString("RULE_FINISH_INSTRUCTION", wsdlURL.toString());
            msgStr = msgStr + "\n\n";
            this.setFinishPageContents(finishPageStr1, msgStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setFinishPageContents(String title, Object contents) {
        TitledWizardPage twp = this._finish_page;
        twp.setTitle(title);
        if (contents instanceof String) {
            MultiLineLabel jLabel1 = new MultiLineLabel(WordWrapper.getTextWrapper(), (String)contents);
            twp.setInteractiveArea((Component)jLabel1);
        } else {
            twp.setInteractiveArea((Component)contents);
        }
    }

    @Override
    public void createSCAComponent() {
        try {
            QName requester = null;
            QName provider = new QName(this.m_namespace, "IDecisionService");
            if (JDevSCAIntegrationUtil.isNameUniqueWithinComposite(this.m_prj, this.m_name)) {
                this.createInboundComponent(this.m_prj, this.m_name, "decision", this.m_name + ".decs", this.m_prj.getProcessName(), this.m_name, provider, requester);
                JDevSCAIntegrationUtil.saveSCAComposite(this.m_prj, this.m_name);
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initRulesXSDDir() {
        BPELProject prj = this.m_pane.getBPELProject();
        URL dirURL = prj.getBPELDirectoryURL();
        try {
            this.setTargetURL(URLFactory.newDirURL((URL)dirURL, (String)"xsd/"));
            File file = new File(this.getTargetURL().getFile());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getProcessNamespace() {
        String m_processNamespace = ((BPELGraphModel)this.m_pane.getModel()).getProcess().getTargetNamespace();
        return m_processNamespace;
    }

    @Override
    public String getPartnerLinkUrl() {
        return this.partnerLinkUrl;
    }

    @Override
    public void setPartnerLinkUrl(String partnerLinkUrl) {
        this.partnerLinkUrl = partnerLinkUrl;
    }

    @Override
    public void wizardFinished() {
        try {
            RulesUtil.removeService(this.m_pane, this.getName());
            this.initEngine();
            DecisionServiceBuilder dsBuilder = new DecisionServiceBuilder(this.m_name);
            TRuleEngineProvider provider = this.getCatalog().getRuleEngine().getProvider();
            if (provider.getProvider() == TRuleEngineProviderName.ORACLE_11_0_0_0_0) {
                File dictFile = new File(this.repoDir);
                InputStreamReader dictReader = new InputStreamReader(new FileInputStream(dictFile));
                RuleDictionary ruleDictionary = RuleDictionary.readDictionary((Reader)dictReader, null);
                dsBuilder.addOracleRuleEngineProvider(provider.getName(), this.repoDir, ruleDictionary);
            } else {
                provider = dsBuilder.addOrSelectRuleEngineProvider(provider);
            }
            String providerName = provider.getName();
            TDecisionService service = this.m_factory.createTDecisionService();
            service.setName(this.getName());
            service.setRuleEngineProviderReference(providerName);
            service.setCatalog(this.getCatalog().getName());
            service.setCatalogVersion(this.getCatalog().getVersion());
            service.setTargetNamespace(this.getNameSpace());
            this.importSchema();
            List patternList = service.getPatterns();
            if (this.getPatternList().get(0) == PatternName.CALL_FUNCTION_STATELESS || this.getPatternList().get(0) == PatternName.CALL_FUNCTION_STATEFUL) {
                TPattern pattern = this.setFunctionPattern(PatternName.CALL_FUNCTION_STATELESS);
                patternList.add(pattern);
                pattern = this.setFunctionPattern(PatternName.CALL_FUNCTION_STATEFUL);
                patternList.add(pattern);
            } else {
                ArrayList<String> ruleSetList = new ArrayList<String>();
                IRuleSet ruleSet = this.getRuleSet();
                ruleSetList.add(ruleSet.getName());
                RulesetParamTableModel model = this.getDataModel((PatternName)this.getPatternList().get(0));
                List assertList = this.getAssertList(model);
                List watchList = this.getWatchList(model);
                dsBuilder.addDecisionService(this.m_name, this.m_namespace, provider.getName(), this.m_catalog.getName(), null, ruleSetList, assertList, watchList, true);
            }
            dsBuilder.createDecisionServiceComponent(this.getPrjURL().getFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            URL outURL = new URL(this.getPrjURL(), this.getName() + ".wsdl");
            this.createPL(outURL.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createSCAComponent();
    }

    private List getWatchList(RulesetParamTableModel model) {
        ArrayList<String> list = new ArrayList<String>();
        int rowCount = model.getRowCount();
        Vector data = model.getData();
        for (int j = 0; j < rowCount; ++j) {
            RulesFact fact = (RulesFact)data.get(j);
            if (!fact.isOutput()) continue;
            list.add(fact.getFact().getName());
        }
        return list;
    }

    private List getAssertList(RulesetParamTableModel model) {
        ArrayList<String> list = new ArrayList<String>();
        int rowCount = model.getRowCount();
        Vector data = model.getData();
        for (int j = 0; j < rowCount; ++j) {
            RulesFact fact = (RulesFact)data.get(j);
            if (!fact.isInput()) continue;
            list.add(fact.getFact().getName());
        }
        return list;
    }

    private void createPL(String wsdlName) throws Exception {
        PartnerLinkWSDLUtil.addPLTypesIntoWSDL((String)wsdlName, null);
        if (this.isEditMode()) {
            this.editPartnerLink(wsdlName);
            return;
        }
        PartnerLink pLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        pLink.setName(this.getName() + "PL");
        BPELGraphModel graphModel = (BPELGraphModel)this.m_pane.getModel();
        Process processModel = graphModel.getProcess();
        pLink.setProcessURL(this.m_prj.getBPELFileURL());
        pLink.setWSDLLocation(wsdlName);
        pLink.setInbound(false);
        pLink.setPortType("IDecisionService");
        pLink.setPartnerRole("IDecisionService_Role");
        String prefix = processModel.addNamespace(this.getNameSpace());
        QName qname = new QName(this.getNameSpace(), "IDecisionService_PL", prefix);
        pLink.setPartnerLinkType(qname);
        this.setPLProperties(pLink);
        PartnerLinks pLinks = processModel.getPartnerLinks();
        pLinks.addPartnerLink(pLink);
        PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
        partnerLinkNode.setUserObject(pLink);
        partnerLinkNode.setIcon(DecisionServiceConstants.PARTNERLINK_ICON);
        partnerLinkNode.setIconName("application/rules/decision_service_16x16.png");
        this.m_pane.getModel().addChildNode((Node)this.m_swimLaneNode, (Node)partnerLinkNode);
        this.setPartnerLinkUrl(wsdlName);
        this.firePartnerLinkCreated(pLink, false);
    }

    private void editPartnerLink(String wsdlName) throws Exception {
        PartnerLink pLink = RulesUtil.getPL(this.m_pane, this.getName());
        pLink.setWSDLLocation(wsdlName);
    }

    private void setPLProperties(PartnerLink pLink) {
        ArrayList<PLProperties> propertyList = pLink.getPropertyList();
        if (propertyList == null) {
            propertyList = new ArrayList<PLProperties>();
        }
        PLProperties prop = new PLProperties("DecisionService", this.getName(), null);
        propertyList.add(prop);
        prop = new PLProperties("wsdlRuntimeLocation", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/" + this.getName() + "?WSDL", null);
        propertyList.add(prop);
        prop = new PLProperties("decisionServiceDetails", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/public_html/" + "GetDecisionServiceInfo.jsp", null);
        propertyList.add(prop);
        propertyList.add(new PLProperties("optSoapShortcut", "False", null));
        pLink.setPropertyList(propertyList);
        DeploymentFile depFile = this.m_prj.getDeploymentFile();
        depFile.setPLProperties(pLink.getName(), propertyList);
    }

    @Override
    protected void init() {
        BPELProject prj = this.m_pane.getBPELProject();
        this.setPrjURL(prj.getBPELDirectoryURL());
        this.m_prj = prj;
    }

    @Override
    protected RuleExplorerTree getRuleExplorerTree(PatternName m_patternName, JFrame frame) {
        RuleExplorerTree tree = m_patternName == PatternName.CALL_FUNCTION_STATELESS || m_patternName == PatternName.CALL_FUNCTION_STATEFUL ? new RuleExplorerTree(frame, this.m_prj, RuleExplorerTree.FUNCTION) : new RuleExplorerTree(frame, this.m_prj, RuleExplorerTree.RULESET);
        return tree;
    }

    private void createInboundComponent(BPELProject m_prj, String componentName, String componentType, String definitionInfo, String serviceName, String wsdlLocation, QName provider, QName requester) throws SCAException {
        try {
            SCAController c = JDevSCAIntegrationUtil.getSCAController(m_prj);
            c.createComponent(componentName, componentType, definitionInfo);
        }
        catch (SCAInvalidFileNameException sce) {
            throw new SCAException((Exception)((Object)sce));
        }
    }

    private void firePartnerLinkCreated(PartnerLink plink, boolean bAddPartnerLink) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompSvcPartnerLink", Boolean.TRUE);
        map.put("OutboundPartnerLink", bAddPartnerLink);
        map.put("CompSvcName", this.getName());
        Process process = ((BPELGraphModel)this.m_pane.getModel()).getProcess();
        process.fireModelChanged((Object)process, 5, (Object)plink, map);
    }
}

