/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.wizard;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.bind.Unmarshaller;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.IRuleCatalog;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.ObjectFactory;
import oracle.bpel.services.rules.rpi.model.TArgumentList;
import oracle.bpel.services.rules.rpi.model.TAssert;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpel.services.rules.rpi.model.TFactType;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.bpel.services.rules.rpi.model.TParameter;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.pm.modules.rules.DecisionServiceConstants;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RulesFact;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleExplorerTree;
import oracle.tip.tools.ide.pm.modules.rules.wizard.RulesetParamTableModel;

public abstract class AbstractDecisionServiceWizardHelper {
    public Wizard _wizard;
    protected ObjectFactory m_factory;
    protected RuleEngineFactory m_rpi_factory;
    protected Unmarshaller m_unmarshaller;
    protected String m_namespace;
    protected List factList;
    public PatternName m_patternName = PatternName.CALL_FUNCTION_STATELESS;
    protected URL m_targetURL;
    protected Vector m_xsdFilesNotFound = new Vector();
    protected boolean b_edit = false;
    protected IRuleSet m_ruleSet;
    public String repoDir;
    public String m_name = "";
    protected URL m_prjURL;
    protected IRuleCatalog m_catalog;
    private Hashtable m_hash = new Hashtable();
    protected Vector m_xsdFiles = new Vector();
    protected Vector m_patternList = new Vector();
    protected TFunction m_function;
    public static Image _image = DecisionServiceConstants.WIZARD_IMAGE;

    public RulesetParamTableModel getDataModel(PatternName pattern) {
        return (RulesetParamTableModel)this.m_hash.get(pattern);
    }

    public Vector getPatternNames() {
        Vector allPatterns = PatternName.getPatternNames();
        allPatterns.removeAll(this.m_patternList);
        return allPatterns;
    }

    public abstract void removePages();

    public abstract void addFinishPage();

    public abstract void setFinishPageContents(String var1, Object var2);

    public abstract void createSCAComponent();

    public abstract void initRulesXSDDir();

    public abstract String getProcessNamespace();

    public abstract String getPartnerLinkUrl();

    public abstract void setPartnerLinkUrl(String var1);

    public abstract void wizardFinished();

    protected void initEngine() throws Exception {
        this.m_rpi_factory = RuleEngineFactory.getInstance();
        this.m_unmarshaller = this.m_rpi_factory.createUnmarshaller();
        this.m_factory = new ObjectFactory();
    }

    protected void copyXSD() {
        try {
            ClassLoader cl = AbstractDecisionServiceWizardHelper.getClassLoader();
            URL targetURL = new URL(this.getPrjURL(), "common.xsd");
            InputStream in = cl.getResourceAsStream("oracle/bpel/services/rules/wsdl/common.xsd");
            URLFileSystem.copy((InputStream)in, (URL)targetURL);
            targetURL = new URL(this.getPrjURL(), "DecisionService.xsd");
            in = cl.getResourceAsStream("oracle/bpel/services/rules/wsdl/DecisionService.xsd");
            URLFileSystem.copy((InputStream)in, (URL)targetURL);
            targetURL = new URL(this.getPrjURL(), "BpelProcess.xsd");
            in = cl.getResourceAsStream("oracle/bpel/services/rules/wsdl/BpelProcess.xsd");
            URLFileSystem.copy((InputStream)in, (URL)targetURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }

    protected TPattern setFunctionPattern(PatternName patternName) throws Exception {
        TDecisionServicePatternName decisionPatternName = TDecisionServicePatternName.fromValue((String)patternName.getXMLName());
        TPattern pattern = this.m_factory.createTPattern();
        pattern.setName(decisionPatternName);
        TArgumentList argList = this.m_factory.createTArgumentList();
        argList.setCall(this.getFunction().getName());
        pattern.setArguments(argList);
        return pattern;
    }

    protected void importSchema() throws IOException {
        for (int i = 0; i < this.getXsdFiles().size(); ++i) {
            URL srcURL = (URL)this.getXsdFiles().get(i);
            String fileName = URLFileSystem.getFileName((URL)srcURL);
            URL targetFileURL = new URL(this.getTargetURL(), fileName);
            if (URLFileSystem.equals((URL)srcURL, (URL)targetFileURL)) continue;
            URLFileSystem.copy((URL)srcURL, (URL)targetFileURL);
        }
    }

    protected TPattern getRulesetPattern(PatternName patternName) throws Exception {
        TDecisionServicePatternName decisionPatternName = TDecisionServicePatternName.fromValue((String)patternName.getXMLName());
        TPattern pattern = this.m_factory.createTPattern();
        pattern.setName(decisionPatternName);
        TArgumentList argList = this.m_factory.createTArgumentList();
        List assertList = argList.getAsserts();
        List watchList = argList.getWatches();
        RulesetParamTableModel model = this.getDataModel(PatternName.ASSERT_EXECUTE_WATCH_STATEFUL);
        int rowCount = model.getRowCount();
        Vector data = model.getData();
        for (int j = 0; j < rowCount; ++j) {
            RulesFact fact = (RulesFact)data.get(j);
            if (fact.isInput() && this.isAssertPattern(patternName)) {
                TAssert assertArg = this.m_factory.createTAssert();
                assertArg.setValue(fact.getFact().getName());
                assertArg.setXpath(fact.getAssertXPath());
                assertList.add(assertArg);
            }
            if (!fact.isOutput() || !this.isWatchPattern(patternName)) continue;
            watchList.add(fact.getFact().getName());
        }
        pattern.setArguments(argList);
        return pattern;
    }

    private boolean isWatchPattern(PatternName patternName) {
        return patternName != PatternName.ASSERT && patternName != PatternName.ASSERT_EXECUTE;
    }

    private boolean isAssertPattern(PatternName patternName) {
        return patternName != PatternName.WATCH;
    }

    protected void setRuleSetPattern(TPattern tPattern) {
        TArgumentList argList = tPattern.getArguments();
        List assertList = argList.getAsserts();
        List watchList = argList.getWatches();
        this.m_patternName = PatternName.ASSERT_EXECUTE_WATCH_STATEFUL;
        RulesetParamTableModel model = new RulesetParamTableModel(this.m_patternName);
        Vector data = model.getData();
        try {
            IDataModel dataModel = this.m_ruleSet.getDataModel();
            List factList = dataModel.getFactTypes();
            for (int i = 0; i < factList.size(); ++i) {
                TFactType fact = (TFactType)factList.get(i);
                RulesFact rulesFact = new RulesFact(fact);
                data.add(rulesFact);
                for (int j = 0; j < assertList.size(); ++j) {
                    TAssert assertArg = (TAssert)assertList.get(j);
                    String factName = assertArg.getValue();
                    if (factName.equals(fact.getName())) {
                        rulesFact.setInput(true);
                    }
                    rulesFact.setAssertXPath(assertArg.getXpath());
                }
                for (int k = 0; k < watchList.size(); ++k) {
                    String factName = (String)watchList.get(k);
                    if (!factName.equals(fact.getName())) continue;
                    rulesFact.setOutput(true);
                }
            }
            this.m_hash.put(this.m_patternName, model);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected List getFacts() {
        ArrayList<String> factList = new ArrayList<String>();
        if (this.getPatternList().get(0) == PatternName.CALL_FUNCTION_STATELESS || this.getPatternList().get(0) == PatternName.CALL_FUNCTION_STATEFUL) {
            List paramList = this.getFunction().getParameters().getParameters();
            for (int i = 0; i < paramList.size(); ++i) {
                factList.add(((TParameter)paramList.get(i)).getType().getName());
            }
        } else {
            for (int i = 0; i < this.getPatternList().size(); ++i) {
                PatternName patternName = (PatternName)this.getPatternList().get(i);
                RulesetParamTableModel model = this.getDataModel(patternName);
                if (model == null) {
                    return null;
                }
                int rowCount = model.getRowCount();
                Vector data = model.getData();
                for (int j = 0; j < rowCount; ++j) {
                    RulesFact fact = (RulesFact)data.get(j);
                    if (!fact.isInput() && !fact.isOutput()) continue;
                    factList.add(fact.getFact().getName());
                }
            }
        }
        return factList;
    }

    public void setDataModel(PatternName pattern, RulesetParamTableModel dataModel) {
        this.m_hash.put(pattern, dataModel);
    }

    public void clearDataModel() {
        this.m_hash = new Hashtable();
    }

    public IRuleSet getRuleSet() {
        return this.m_ruleSet;
    }

    public void setRuleSet(IRuleSet set) {
        this.m_ruleSet = set;
    }

    public Vector getPatternList() {
        return this.m_patternList;
    }

    public void setPatternList(Vector list) {
        this.m_patternList = list;
    }

    public TFunction getFunction() {
        return this.m_function;
    }

    public void setFunction(TFunction m_function) {
        this.m_function = m_function;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String m_name) {
        this.m_name = m_name;
    }

    public String getNameSpace() {
        return this.m_namespace;
    }

    public void setNameSpace(String m_namespace) {
        this.m_namespace = m_namespace;
    }

    public IRuleCatalog getCatalog() {
        return this.m_catalog;
    }

    public void setCatalog(IRuleCatalog m_catalog) {
        this.m_catalog = m_catalog;
    }

    public boolean isEditMode() {
        return this.b_edit;
    }

    public void setEditMode(boolean b_edit) {
        this.b_edit = b_edit;
    }

    public URL getTargetURL() {
        return this.m_targetURL;
    }

    public void setTargetURL(URL m_targeturl) {
        this.m_targetURL = m_targeturl;
    }

    public Vector getXsdFilesNotFound() {
        return this.m_xsdFilesNotFound;
    }

    public void setXsdFilesNotFound(Vector filesNotFound) {
        this.m_xsdFilesNotFound = filesNotFound;
    }

    public Vector getXsdFiles() {
        return this.m_xsdFiles;
    }

    public void setXsdFiles(Vector files) {
        this.m_xsdFiles = files;
    }

    public Wizard getWizard() {
        return this._wizard;
    }

    public void setWizard(Wizard wizard) {
        this._wizard = wizard;
    }

    public URL getPrjURL() {
        return this.m_prjURL;
    }

    public void setPrjURL(URL m_prjurl) {
        this.m_prjURL = m_prjurl;
    }

    protected abstract void init();

    protected abstract RuleExplorerTree getRuleExplorerTree(PatternName var1, JFrame var2);
}

