/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.ruleexplorer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.IRuleCatalog;
import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.rules.connection.OracleRuleConnection;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class RuleExplorerTreeNode
extends DefaultTreeExplorerTreeNode {
    OracleRuleConnection m_ruleConn;
    String m_connType = "oracle_file";
    private int m_type;
    private static int RULESET = 1;
    private static int FUNCTION = 4;
    private static int VERSION = 5;
    private static int CATALOG = 2;
    private static int ENGINE = 3;
    public static int RULE_LEAF = 1;
    public static int CATALOG_LEAF = 2;
    public static int ENGINE_LEAF = 3;
    public static int m_leafNodeType = RULE_LEAF;
    public static int FUNCTION_LEAF = 4;
    private String m_name;
    private String m_dir;
    private String m_description;
    private boolean b_showVersions;
    private static final String WSIL_EXE = ".wsil";
    public static Icon DICTIONARY_ICON = ImageCache.getIcon("application/rules/dictionary16.png");
    public static Icon IMPORT_RULE_ENGINE_FILE_ICON = ImageCache.getIcon("application/rules/rulesengine_import_16x16.png");
    public static Icon RULE_ENGINE_CONNECTION_ICON = ImageCache.getIcon("application/rules/rulesengine_connection_16x16.png");
    public static Icon RULE_ENGINE_FILE_ICON = ImageCache.getIcon("application/rules/rulesengine_file_16x16.png");
    public static Icon WSIL_ICON = ImageCache.getIcon("application/rules/dictionary16.png");
    public static Icon FILE_ICON = new ImageIcon(UIHelper.loadImage((String)"images/folder.png", UIHelper.class));
    public static Icon WSDL_ICON = new ImageIcon(UIHelper.loadImage((String)"images/element.png", UIHelper.class));
    private RuleEngineFactory m_ruleEngineFactory = RuleEngineFactory.getInstance();
    private IRuleEngine m_rule_engine;
    IRuleCatalog m_ruleCatalog = null;
    IRuleSet m_ruleSet = null;
    TFunction m_function = null;
    String m_version = null;

    public RuleExplorerTreeNode(OracleRuleConnection conn, int leafType, boolean showVersions) {
        super(conn.getConnectionName());
        this.m_ruleConn = conn;
        this.init(conn.getConnectionName(), leafType, showVersions);
        this.m_connType = "oracle_webdav";
    }

    private void init(String name, int leafType, boolean showVersions) {
        this.m_type = ENGINE;
        this.m_name = name;
        this.m_description = name;
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, name);
        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, name);
        this.b_showVersions = showVersions;
        TextInfo[] expanded = new TextInfo[]{info1};
        TextInfo[] compact = new TextInfo[]{info2};
        this.setNodeText(new NodeText(expanded, compact));
        m_leafNodeType = leafType;
    }

    public IRuleSet getRuleSet() {
        return this.m_ruleSet;
    }

    public TFunction getFunction() {
        return this.m_function;
    }

    public void showVersions(boolean flag) {
        this.b_showVersions = flag;
    }

    public boolean isShowVersions() {
        return this.b_showVersions;
    }

    public IRuleCatalog getRuleCatalog() {
        if (this.m_ruleCatalog != null) {
            return this.m_ruleCatalog;
        }
        if (this.m_ruleSet != null) {
            return this.m_ruleSet.getCatalog();
        }
        return null;
    }

    public RuleExplorerTreeNode(IRuleCatalog ruleCatalog, String description) {
        super(ruleCatalog.getName());
        this.m_type = CATALOG;
        this.m_ruleCatalog = ruleCatalog;
        this.m_name = ruleCatalog.getName();
        this.m_description = description;
        this.m_rule_engine = ruleCatalog.getRuleEngine();
        String compactName = description;
        if (compactName == null) {
            compactName = ruleCatalog.getName();
        }
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, compactName);
        TextInfo info2 = new TextInfo(Color.gray, TextInfo.PLAIN_FONT, " - " + ruleCatalog.getName());
        TextInfo[] compact = new TextInfo[]{info1};
        TextInfo[] expanded = new TextInfo[]{info1, info2};
        this.setNodeText(new NodeText(expanded, compact));
    }

    public RuleExplorerTreeNode(IRuleSet ruleSet, String description) {
        super(ruleSet.getName());
        this.m_type = RULESET;
        this.m_ruleSet = ruleSet;
        this.m_name = ruleSet.getName();
        this.m_description = description;
        String compactName = description;
        if (compactName == null) {
            compactName = ruleSet.getName();
        }
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, compactName);
        TextInfo info2 = new TextInfo(Color.gray, TextInfo.PLAIN_FONT, " - " + ruleSet.getName());
        TextInfo[] compact = new TextInfo[]{info1};
        TextInfo[] expanded = new TextInfo[]{info1, info2};
        this.setNodeText(new NodeText(expanded, compact));
    }

    public RuleExplorerTreeNode(IRuleCatalog catalog, TFunction function, String description) {
        super(function.getName());
        this.m_type = FUNCTION;
        this.m_function = function;
        this.m_name = function.getName();
        this.m_description = description;
        this.m_ruleCatalog = catalog;
        String compactName = description;
        if (compactName == null) {
            compactName = function.getName();
        }
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, compactName);
        TextInfo info2 = new TextInfo(Color.gray, TextInfo.PLAIN_FONT, " - " + function.getName());
        TextInfo[] compact = new TextInfo[]{info1};
        TextInfo[] expanded = new TextInfo[]{info1, info2};
        this.setNodeText(new NodeText(expanded, compact));
    }

    public RuleExplorerTreeNode(String version, String description, IRuleCatalog catalog) {
        super(version);
        this.m_type = VERSION;
        this.m_version = version;
        this.m_name = version;
        this.m_description = description;
        this.m_ruleCatalog = catalog;
        this.m_rule_engine = this.m_ruleCatalog.getRuleEngine();
        String compactName = description;
        if (compactName == null) {
            compactName = version;
        }
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, compactName);
        TextInfo info2 = new TextInfo(Color.gray, TextInfo.PLAIN_FONT, " - " + version);
        TextInfo[] compact = new TextInfo[]{info1};
        TextInfo[] expanded = new TextInfo[]{info1, info2};
        this.setNodeText(new NodeText(expanded, compact));
    }

    public RuleExplorerTreeNode(Icon[] icons, NodeText nodeText, String description) {
        super(icons, nodeText, "Folder");
        if (nodeText != null) {
            TextInfo[] info = nodeText.m_expandedText;
            this.m_dir = info[0].getText();
            this.m_name = info[0].getText();
        }
        this.m_description = description;
    }

    public String getDisplayName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public TreeExplorerTreeNode[] getChildren() throws Exception {
        DummyNode dummyNode = null;
        this.m_childNodes.clear();
        if (this.m_type == VERSION) {
            this.m_ruleCatalog = this.m_rule_engine.getRuleCatalog(this.m_ruleCatalog.getName(), this.m_version);
        }
        if (this.m_type == ENGINE) {
            this.m_rule_engine = this.m_connType.equals("oracle_file") ? RulesUtil.getRuleEngineFromRuleDictionary(this.m_dir) : this.m_ruleConn.createRuleEngine();
            TRuleEngineProvider provider = this.m_rule_engine.getProvider();
            provider.setName(this.m_name);
            List catalogList = RuleExplorerTreeNode.getCatalogs(this.m_rule_engine);
            for (int i = 0; i < catalogList.size(); ++i) {
                IRuleCatalog ruleCatalog = (IRuleCatalog)catalogList.get(i);
                RuleExplorerTreeNode node = new RuleExplorerTreeNode(ruleCatalog, ruleCatalog.getName());
                node.m_ruleConn = this.m_ruleConn;
                node.showVersions(this.b_showVersions);
                if (node.hasChildren()) {
                    dummyNode = new DummyNode(MessageBundleUtil.getCommonString((String)"DEFAULT", (String)"default"));
                    node.add((MutableTreeNode)dummyNode);
                }
                Icon[] icons = new Icon[]{WSIL_ICON};
                node.setIcons(icons);
                this.m_childNodes.add(node);
            }
        } else if (this.m_type == CATALOG && this.b_showVersions) {
            List versionList = this.m_rule_engine.getRuleCatalogVersions(this.m_ruleCatalog.getName());
            for (int j = 0; j < versionList.size(); ++j) {
                String version = (String)versionList.get(j);
                RuleExplorerTreeNode node = new RuleExplorerTreeNode(version, version, this.m_ruleCatalog);
                node.m_ruleCatalog = this.m_ruleCatalog;
                node.showVersions(this.b_showVersions);
                NodeText text = node.getNodeText();
                if (node.hasChildren()) {
                    dummyNode = new DummyNode(MessageBundleUtil.getCommonString((String)"DEFAULT", (String)"default"));
                    node.add((MutableTreeNode)dummyNode);
                }
                Icon[] icons = new Icon[]{WSIL_ICON};
                node.setIcons(icons);
                this.m_childNodes.add(node);
            }
        } else if ((this.m_type == CATALOG || this.m_type == VERSION) && m_leafNodeType == FUNCTION_LEAF) {
            IDataModel dataModel = this.m_ruleCatalog.getDataModel();
            List funcList = dataModel.getFunctions();
            for (int j = 0; j < funcList.size(); ++j) {
                TFunction function = (TFunction)funcList.get(j);
                String description = function.getDescription();
                if (description == null || description.equals("")) {
                    description = function.getName();
                }
                RuleExplorerTreeNode node = new RuleExplorerTreeNode(this.m_ruleCatalog, function, description);
                node.m_ruleConn = this.m_ruleConn;
                node.showVersions(this.b_showVersions);
                NodeText text = node.getNodeText();
                if (text != null) {
                    TextInfo[] expanded = text.m_expandedText;
                    TextInfo[] compact = text.m_compactText;
                    expanded[0].setFont(TextInfo.BOLD_FONT);
                    compact[0].setFont(TextInfo.BOLD_FONT);
                    node.setNodeText(new NodeText(expanded, compact));
                }
                Icon[] icons = new Icon[]{WSDL_ICON};
                node.setIcons(icons);
                this.m_childNodes.add(node);
            }
        } else if (this.m_type == CATALOG || this.m_type == VERSION) {
            List ruleList = this.m_ruleCatalog.getRuleSets();
            for (int j = 0; j < ruleList.size(); ++j) {
                IRuleSet ruleSet = (IRuleSet)ruleList.get(j);
                String description = ruleSet.getDescription();
                if (description == null || description.equals("")) {
                    description = ruleSet.getName();
                }
                RuleExplorerTreeNode node = new RuleExplorerTreeNode(ruleSet, description);
                node.m_ruleConn = this.m_ruleConn;
                node.showVersions(this.b_showVersions);
                NodeText text = node.getNodeText();
                if (text != null) {
                    TextInfo[] expanded = text.m_expandedText;
                    TextInfo[] compact = text.m_compactText;
                    expanded[0].setFont(TextInfo.BOLD_FONT);
                    compact[0].setFont(TextInfo.BOLD_FONT);
                    node.setNodeText(new NodeText(expanded, compact));
                }
                Icon[] icons = new Icon[]{WSDL_ICON};
                node.setIcons(icons);
                this.m_childNodes.add(node);
            }
        } else if (this.m_type == RULESET) {
            // empty if block
        }
        if (this.m_childNodes.size() > 0) {
            return this.m_childNodes.toArray(new TreeExplorerTreeNode[0]);
        }
        return new TreeExplorerTreeNode[0];
    }

    public boolean hasChildren() {
        return this.m_type == ENGINE || this.m_type == CATALOG || this.m_type == VERSION;
    }

    public String toString() {
        return this.m_dir;
    }

    public static List getCatalogs(IRuleEngine engine) {
        ArrayList<IRuleCatalog> catalogList = new ArrayList<IRuleCatalog>();
        try {
            long time1 = new Date().getTime();
            List catalogNames = engine.getRuleCatalogNames();
            for (String str : catalogNames) {
                catalogList.add(engine.getRuleCatalog(str));
            }
            long time2 = new Date().getTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return catalogList;
    }

    public OracleRuleConnection getOracleRuleConnection() {
        return this.m_ruleConn;
    }
}

