/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.ruleexplorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bpel.services.rules.rpi.IRuleCatalog;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.datasources.wsil.WSILTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.DialogCancelListener;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleDataSource;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleExplorerTreeNode;

public class RuleExplorerTree
extends JDialog
implements ActionListener,
PropertyChangeListener,
DialogCancelListener {
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected TreeExplorer m_explorer;
    protected BPELGraphPane m_graphPane;
    private BPELProject m_project;
    public static final int RULESET = RuleExplorerTreeNode.RULE_LEAF;
    public static final int CATALOG = RuleExplorerTreeNode.CATALOG_LEAF;
    public static final int ENGINE = RuleExplorerTreeNode.ENGINE_LEAF;
    public static final int FUNCTION = RuleExplorerTreeNode.FUNCTION_LEAF;
    protected int m_retVal = 2;
    protected int m_leafType = FUNCTION;
    RuleDataSource m_ds;
    JCheckBox m_checkBox;
    JCheckBox m_versionCB;
    Action[] m_actions = new Action[2];

    public RuleExplorerTree(JFrame f, BPELProject prj, int leafType) {
        super(f, BPELStringTranslator.getString("DLG_TITLE_RULE_EXPLORER"), true);
        this.m_project = prj;
        if (leafType == FUNCTION) {
            this.setTitle(BPELStringTranslator.getString("DLG_TITLE_FUNC_EXPLORER"));
        }
        this.m_leafType = leafType;
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addMouseMotionListener(new MouseMotionAdapter(){});
        this.getGlassPane().addKeyListener(new KeyAdapter(){});
        this.createControls();
        this.layoutControls();
        this.updateButtons();
        this.addConnectionButton();
        this.attachHelpListener();
        UIHelper.attachDialogCancelListener((JDialog)this, (DialogCancelListener)this);
    }

    private void addConnectionButton() {
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = RuleExplorerTree.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    public TreeExplorer getExplorer() {
        return this.m_explorer;
    }

    public URL getUrl() {
        DefaultTreeExplorerTreeNode node;
        URL url = null;
        if (this.m_explorer != null && (node = this.m_explorer.getSelectedNode()) instanceof WSILTreeExplorerTreeNode) {
            url = ((WSILTreeExplorerTreeNode)node).getUrl();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int display() {
        TreeExplorerDataSource ds = null;
        this.m_ds = ds;
        if (ds != null) {
            this.enableUserInput(false);
            this.m_explorer.showWaitPanel();
            try {
                String title = BPELStringTranslator.getString("DLG_TITLE_RULE_EXPLORER");
                if (this.m_leafType == FUNCTION) {
                    title = BPELStringTranslator.getString("DLG_TITLE_FUNC_EXPLORER");
                }
                TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, title);
                TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, title);
                TextInfo[] expanded = new TextInfo[]{info1};
                TextInfo[] compact = new TextInfo[]{info2};
                NodeText nodeText = new NodeText(expanded, compact);
                Icon[] icons = new Icon[]{GlobalImageCache.getIcon((String)"browse16")};
                RuleExplorerTreeNode root = new RuleExplorerTreeNode(icons, nodeText, MessageBundleUtil.getCommonString((String)"WSIL_DISPLAYS_AVAILABLE_WSDL_FILES", (String)"Displays available WSDL files."));
                this.m_explorer.setDataSource(ds);
                this.m_explorer.setRoot((DefaultTreeExplorerTreeNode)root);
                this.m_explorer.load();
            }
            finally {
                this.enableUserInput(true);
                this.m_explorer.showExplorerPanel();
            }
        }
        this.show();
        return this.m_retVal;
    }

    public IRuleSet getRuleSet() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        if (node != null && node instanceof RuleExplorerTreeNode) {
            return ((RuleExplorerTreeNode)node).getRuleSet();
        }
        return null;
    }

    public TFunction getFunction() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        if (node != null && node instanceof RuleExplorerTreeNode) {
            return ((RuleExplorerTreeNode)node).getFunction();
        }
        return null;
    }

    public IRuleCatalog getRuleCatalog() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        if (node != null && node instanceof RuleExplorerTreeNode) {
            return ((RuleExplorerTreeNode)node).getRuleCatalog();
        }
        return null;
    }

    public String getRuleRepositoryLocation() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        if (node != null && node instanceof RuleExplorerTreeNode) {
            RuleExplorerTreeNode ruleNode = (RuleExplorerTreeNode)node;
            return ruleNode.getOracleRuleConnection().getRepoDir();
        }
        return null;
    }

    protected void createControls() {
        this.m_okBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)MessageBundleUtil.getCommonString((String)"M_OK", (String)"&OK"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)MessageBundleUtil.getCommonString((String)"M_CANCEL", (String)"&Cancel"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_helpBtn, (String)MessageBundleUtil.getCommonString((String)"M_HELP", (String)"&Help"));
        this.m_helpBtn.addActionListener(this);
        this.m_explorer = new TreeExplorer(BPELStringTranslator.getString("DESCRIPTION"));
        this.m_explorer.setDescriptionPanelVisible(false);
        this.m_explorer.setBorder(null);
        this.m_explorer.addPropertyChangeListener((PropertyChangeListener)this);
        JCheckBox checkBox = this.m_explorer.getCheckBox();
        checkBox.setText(BPELStringTranslator.getString("CHK_SHOW_LATEST_VER"));
        ActionListener[] listeners = checkBox.getActionListeners();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                checkBox.removeActionListener(listeners[i]);
            }
        }
        checkBox.addActionListener(this);
        this.m_checkBox = checkBox;
        this.m_versionCB = new JCheckBox();
        BPELStringTranslator.setButton(this.m_versionCB, BPELStringTranslator.getString("CHK_SHOW_ALL_VER"));
        this.m_checkBox.setVisible(false);
        this.m_versionCB.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)c, (Component)this.m_explorer, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        UIHelper.addComponent((Container)c, (Component)this.m_versionCB, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)btnPnl, (int)1, (int)2, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        UIHelper.centerInScreen((Component)this);
    }

    protected void updateButtons() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        this.m_okBtn.setEnabled(this.m_explorer.isNodeSelected() && !node.hasChildren());
    }

    public void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    public void handleCancel() {
        this.m_retVal = 2;
        this.dispose();
    }

    protected void helpInvoked() {
        HelpSystem help = HelpSystem.getHelpSystem();
        help.registerClientWindow((Window)this);
        help.goTo("bpmjdev_rule_func_expl");
        help.unregisterClientWindow((Window)this);
    }

    protected void attachHelpListener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                RuleExplorerTree.this.helpInvoked();
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        } else if (src == this.m_versionCB) {
            this.m_ds = null;
            try {
                String title = BPELStringTranslator.getString("DLG_TITLE_RULE_EXPLORER");
                if (this.m_leafType == FUNCTION) {
                    title = BPELStringTranslator.getString("DLG_TITLE_FUNC_EXPLORER");
                }
                TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, title);
                TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, title);
                TextInfo[] expanded = new TextInfo[]{info1};
                TextInfo[] compact = new TextInfo[]{info2};
                NodeText nodeText = new NodeText(expanded, compact);
                Icon[] icons = new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/flashlight.png", UIHelper.class))};
                RuleExplorerTreeNode root = new RuleExplorerTreeNode(icons, nodeText, MessageBundleUtil.getCommonString((String)"WSIL_DISPLAYS_AVAILABLE_WSDL_FILES", (String)"Displays available WSDL files."));
                root.showVersions(this.m_versionCB.isSelected());
                this.m_explorer.setDataSource((TreeExplorerDataSource)this.m_ds);
                this.m_explorer.setRoot((DefaultTreeExplorerTreeNode)root);
                this.m_explorer.load();
            }
            finally {
                this.enableUserInput(true);
                this.m_explorer.showExplorerPanel();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "TYPE_SELECTION_CHANGED") {
            this.updateButtons();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }
}

