/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.ruleexplorer;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.rules.connection.OracleRuleConnection;
import oracle.tip.tools.ide.pm.modules.rules.ruleexplorer.RuleExplorerTreeNode;

public class RuleDataSource
implements TreeExplorerDataSource {
    private static final String DEFAULT = "default";
    private static final String LOCAL = MessageBundleUtil.getCommonString((String)"LOCAL_DIRECTORY");
    private static final Icon[] icons = new Icon[]{RuleExplorerTreeNode.WSIL_ICON};
    private static final Icon[] fileIcons = new Icon[]{RuleExplorerTreeNode.FILE_ICON};
    private List m_rootList = new ArrayList();
    private URL m_url;

    public RuleDataSource(List connList, int leafType) {
        this(connList, leafType, false);
    }

    public RuleDataSource(List connList, int leafType, boolean showVersions) {
        if (connList != null) {
            for (int i = 0; i < connList.size(); ++i) {
                OracleRuleConnection connObj = (OracleRuleConnection)connList.get(i);
                RuleExplorerTreeNode defaultNode = new RuleExplorerTreeNode(connObj, leafType, showVersions);
                if (defaultNode.hasChildren()) {
                    defaultNode.add((MutableTreeNode)new DummyNode(DEFAULT));
                }
                this.m_rootList.add(defaultNode);
                if (connObj.isConnection()) {
                    defaultNode.setIcons(new Icon[]{RuleExplorerTreeNode.RULE_ENGINE_CONNECTION_ICON});
                    continue;
                }
                defaultNode.setIcons(new Icon[]{RuleExplorerTreeNode.RULE_ENGINE_FILE_ICON});
            }
        }
    }

    private static String generateUniqName(String initName, List existingNames) {
        int n = 1;
        String currentName = initName + n;
        boolean notFound = true;
        block0: while (notFound) {
            notFound = false;
            for (int i = 0; i < existingNames.size(); ++i) {
                String name = existingNames.toString();
                if (!currentName.equals(name)) continue;
                currentName = initName + ++n;
                notFound = true;
                continue block0;
            }
        }
        return currentName;
    }

    public TreeExplorerTreeNode[] getRoots() {
        if (this.m_rootList != null) {
            return this.m_rootList.toArray(new TreeExplorerTreeNode[0]);
        }
        return new TreeExplorerTreeNode[0];
    }
}

