/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.connection;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.encryption.EncryptionException;
import oracle.tip.tools.ide.common.encryption.EncryptionHandler;
import oracle.tip.tools.ide.common.encryption.StringEncrypter;
import oracle.tip.tools.ide.pm.modules.rules.connection.RuleConnectionData;

public class RuleConnection
implements Cloneable,
EncryptionHandler {
    private String m_username;
    private String m_password;
    private String m_repoDir;
    private String m_port;
    private boolean m_bDownloadConnInfo;
    public static final String ORACLE = "oracle_file";
    public static final String ILOG = "ilog";
    public static final String ORA_WEBDAV = "oracle_webdav";
    private URL m_url;
    private String m_type = "oracle_file";
    private List mDomainInfoList = new ArrayList();
    private String m_webDavConnName;
    private String m_iLogConnName;

    public Object clone() {
        RuleConnection lConnection = new RuleConnection();
        lConnection.setDownloadReposInfo(this.m_bDownloadConnInfo);
        lConnection.setRepoDir(this.m_repoDir);
        lConnection.setPassword(this.m_password);
        lConnection.setPort(this.m_port);
        lConnection.setUserName(this.m_username);
        lConnection.setType(this.getType());
        return lConnection;
    }

    public RuleConnectionData getRuleConnectionData() {
        RuleConnectionData data = new RuleConnectionData();
        data.setConnectionType(this.m_type);
        data.setFile(this.m_repoDir);
        data.setIlog(this.m_iLogConnName);
        data.setWebdav(this.m_webDavConnName);
        return data;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    public void setWebDavConn(String webDavConnName) {
    }

    public String getWebDavConnName() {
        return "";
    }

    public List getDomains() {
        return this.mDomainInfoList;
    }

    public void setDomains(List pList) {
        if (pList != null) {
            this.mDomainInfoList = pList;
        }
    }

    public void setIlog(String ilogConnName) {
        this.m_iLogConnName = ilogConnName;
    }

    public String getIlog() {
        return this.m_iLogConnName;
    }

    public String getUserName() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getRepoDir() {
        return this.m_repoDir;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public boolean getDownloadConnInfo() {
        return this.m_bDownloadConnInfo;
    }

    public void setUserName(String username) {
        this.m_username = username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setRepoDir(String repoDir) {
        this.m_repoDir = repoDir;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public void setDownloadReposInfo(boolean bDownload) {
        this.m_bDownloadConnInfo = bDownload;
    }

    public void decrypt(StringEncrypter pEncrypter) throws EncryptionException {
        for (EncryptionHandler handler : this.mDomainInfoList) {
            handler.decrypt(pEncrypter);
        }
    }

    public void encrypt(StringEncrypter pEncrypter) throws EncryptionException {
        for (EncryptionHandler handler : this.mDomainInfoList) {
            handler.encrypt(pEncrypter);
        }
    }
}

