/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules.connection;

import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.rules.connection.RuleConnection;

public class OracleRuleConnection {
    private String m_connectionName;
    private String m_repoDir;
    private boolean m_isConnection = true;
    private String m_connType = "oracle_file";
    RuleEngineFactory m_ruleEngineFactory = RuleEngineFactory.getInstance();

    public OracleRuleConnection(String connectionName, String repoDir, boolean isConnection) {
        this.m_connectionName = connectionName;
        this.m_repoDir = repoDir;
        this.m_isConnection = isConnection;
        this.m_connType = "oracle_file";
    }

    public OracleRuleConnection(RuleConnection connection, String name) {
        this.m_connectionName = name;
        if (connection.getType().equals("oracle_file")) {
            this.m_repoDir = connection.getRepoDir();
            this.m_isConnection = true;
            this.m_connType = "oracle_file";
        } else if (connection.getType().equals("oracle_webdav")) {
            this.m_isConnection = true;
            this.m_connType = "oracle_webdav";
        }
    }

    public OracleRuleConnection(String connectionName, String repoDir) {
        this(connectionName, repoDir, true);
    }

    public boolean isConnection() {
        return this.m_isConnection;
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public String getRepoDir() {
        return this.m_repoDir;
    }

    public String toString() {
        return this.m_connectionName;
    }

    public String getConnectionType() {
        return this.m_connType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRuleEngine createRuleEngine() {
        IRuleEngine ruleEngine = null;
        try {
            if (this.m_connType.equals("oracle_file")) {
                return RulesUtil.getRuleEngineFromRuleDictionary(this.m_repoDir);
            }
            if (!this.m_connType.equals("oracle_webdav")) return ruleEngine;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ruleEngine;
    }
}

