/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.ObjectFactory;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.util.DecisionServiceBuilder;
import oracle.ide.net.URLFileSystem;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.rules.connection.OracleRuleConnection;

public class RulesUtil {
    public static DecisionServices getDecisionServices(URL fileURL) throws Exception {
        ObjectFactory factory = new ObjectFactory();
        RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
        Unmarshaller unmarshaller = rpi_factory.createUnmarshaller();
        File configFile = new File(fileURL.getFile());
        DecisionServices services = URLFileSystem.exists((URL)fileURL) ? (DecisionServices)unmarshaller.unmarshal(configFile) : factory.createDecisionServices();
        return services;
    }

    public static TRuleEngineProvider addProvider(URL prjURL, TRuleEngineProvider provider) throws Exception {
        return provider;
    }

    public static List createConnections(List repoFiles) {
        ArrayList<OracleRuleConnection> list = new ArrayList<OracleRuleConnection>();
        for (int i = 0; i < repoFiles.size(); ++i) {
            String fileName = (String)repoFiles.get(i);
            File file = new File(fileName);
            String connName = file.getName();
            list.add(new OracleRuleConnection(connName, fileName, false));
        }
        return list;
    }

    public static void removeService(BPELGraphPane pane, String serviceName) {
    }

    public static List getRepoFiles(URL prjURL) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(prjURL.getFile() + File.separator + "rules/oracle/");
        String[] files = file.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                list.add(file.getAbsolutePath() + File.separator + files[i]);
            }
        }
        return list;
    }

    public static PartnerLink getPL(BPELGraphPane pane, String serviceName) {
        BPELGraphModel graphModel = (BPELGraphModel)pane.getModel();
        BPELProject prj = pane.getBPELProject();
        Process processModel = graphModel.getProcess();
        PartnerLinks pls = processModel.getPartnerLinks();
        List pLinks = null;
        if (pls != null) {
            pLinks = pls.getPartnerLinks();
        }
        if (pLinks != null) {
            for (int i = 0; i < pLinks.size(); ++i) {
                PartnerLink pl = (PartnerLink)pLinks.get(i);
                if (!pl.getName().equals(serviceName + "PL")) continue;
                return pl;
            }
        }
        return null;
    }

    public static IRuleEngine getRuleEngineFromRuleDictionary(String name, String repoFileName) throws Exception {
        DecisionServiceBuilder b = new DecisionServiceBuilder("TestComponent");
        File dictFile = new File(repoFileName);
        InputStreamReader dictReader = new InputStreamReader(new FileInputStream(dictFile));
        RuleDictionary m_rule_dictionary = RuleDictionary.readDictionary((Reader)dictReader, null);
        IRuleEngine m_rule_engine = b.addOracleRuleEngineProvider("myRuleEngine", repoFileName, m_rule_dictionary);
        return m_rule_engine;
    }

    public static IRuleEngine getRuleEngineFromRuleDictionary(String repoFileName) throws Exception {
        return RulesUtil.getRuleEngineFromRuleDictionary("myRuleEngine", repoFileName);
    }

    public static URL resolveVariableDef(Variable v, BPELProject prj, Process proc) {
        URL ret = null;
        boolean isXSD = true;
        QName name = v.getMessageType();
        if (name != null) {
            isXSD = false;
        } else {
            name = v.getElement();
            if (name != null) {
                isXSD = true;
            } else {
                return null;
            }
        }
        String tname = name.getLocalPart();
        String ns = name.getNamespaceURI();
        String processName = prj.getProcessName();
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(prj.getWSDLFileURL(processName));
        URL wsdlURL = prj.getWSDLFileURL(processName);
        try {
            Definition projDef = prj.getWSDLFileDefinition();
            ret = isXSD ? WSDLUtil.resolveElementToFile((Definition)projDef, (String)ns, (String)tname, (boolean)true) : WSDLUtil.resolveMessageToWSDLFile((Definition)projDef, (QName)name);
            List plwsdls = null;
            if (ret == null) {
                plwsdls = BPELModelerUtil.getWSDLURIsOfPartnerLinks((Process)proc, (DeploymentFile)prj.getDeploymentFile());
                plwsdls.remove(wsdlURL);
                for (Object loc : plwsdls) {
                    ret = isXSD ? WSDLUtil.resolveElementToFile((Definition)WSDLUtil.parseWSDLDocument((URI)((URI)loc)), (String)ns, (String)tname, (boolean)true) : WSDLUtil.resolveMessageToWSDLFile((Definition)WSDLUtil.parseWSDLDocument((URI)((URI)loc)), (QName)name);
                    if (ret == null) continue;
                    return ret;
                }
            }
            if (ret == null) {
                List wsdls = prj.getProjectWSDLFiles();
                wsdls.remove(wsdlURL);
                wsdls.removeAll(plwsdls);
                for (Object loc : wsdls) {
                    ret = isXSD ? WSDLUtil.resolveElementToFile((Definition)WSDLUtil.parseWSDL((URL)((URL)loc)), (String)ns, (String)tname, (boolean)true) : WSDLUtil.resolveMessageToWSDLFile((Definition)WSDLUtil.parseWSDL((URL)((URL)loc)), (QName)name);
                    if (ret == null) continue;
                    return ret;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

