/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.wsdl.Definition;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.util.WSDLGenerator;

public class RuleWSDLGenerator {
    private DecisionServices m_decisionServices;
    private WSDLGenerator m_wsdlGenerator;
    private RuleEngineFactory m_rpiFactory = RuleEngineFactory.getInstance();
    private Unmarshaller m_unmarshaller;
    private String m_fileName;

    public RuleWSDLGenerator(String configFileName) {
        this.m_fileName = configFileName;
        try {
            this.m_unmarshaller = this.m_rpiFactory.createUnmarshaller();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Definition generateWSDL(String serviceName, String wsdlName) {
        File configFile = new File(this.m_fileName);
        try {
            this.m_decisionServices = (DecisionServices)this.m_unmarshaller.unmarshal(configFile);
            this.m_wsdlGenerator = new WSDLGenerator(this.m_decisionServices);
            return RuleWSDLGenerator.generateWSDL(serviceName, wsdlName, this.m_wsdlGenerator);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Definition generateWSDL(String serviceName, String wsdlName, String configFileName) {
        File configFile = new File(configFileName);
        try {
            RuleEngineFactory rpiFactory = RuleEngineFactory.getInstance();
            Unmarshaller unmarshaller = rpiFactory.createUnmarshaller();
            DecisionServices decisionServices = (DecisionServices)unmarshaller.unmarshal(configFile);
            WSDLGenerator wsdlGenerator = new WSDLGenerator(decisionServices);
            return RuleWSDLGenerator.generateWSDL(serviceName, wsdlName, wsdlGenerator);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Definition generateWSDL(String serviceName, String wsdlName, WSDLGenerator wsdlGenerator) throws Exception {
        File wsdlFile = new File(wsdlName);
        OutputStream stream = System.out;
        if (wsdlFile != null) {
            stream = new FileOutputStream(wsdlFile);
        }
        Definition def = null;
        ((OutputStream)stream).close();
        return def;
    }
}

