/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.TableRowData;

public class RuleBpelVariablesTableModel
extends BaseTableModel {
    public static final int DIRECTION_COL = 0;
    public static final int NAME_COL = 1;
    public static final int TYPE_COL = 2;
    public static final int QNAME_COL = 3;
    public static final int SCHEMA_COL = 3;
    private boolean m_bExpandNamespaces = false;

    public void setExpandNamespaces(boolean bExpand) {
        this.m_bExpandNamespaces = bExpand;
        this.refresh();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int col) {
        TableRowData data = (TableRowData)this.m_data.elementAt(row);
        String dir = data.m_direction ? BPELStringTranslator.getString("RULE_DIRECTION_INPUT", "Input") : BPELStringTranslator.getString("RULE_DIRECTION_OUTPUT", "Output");
        Variable v = data.m_var;
        switch (col) {
            case 0: {
                return dir;
            }
            case 1: {
                return v.getName();
            }
            case 2: {
                QName qName = v.getVariableTypeQName();
                if (qName != null) {
                    return this.m_bExpandNamespaces ? BPELModelUtil.getExpandedName((QName)qName) : BPELModelUtil.getPrefixQualifiedName((QName)qName);
                }
                return null;
            }
            case 3: {
                QName qname = v.getVariableTypeQName();
                if (qname != null) {
                    return this.m_bExpandNamespaces ? BPELModelUtil.getExpandedName((QName)qname) : BPELModelUtil.getPrefixQualifiedName((QName)qname);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_NAME", "Name");
            }
            case 2: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_TYPE", "Type");
            }
            case 0: {
                return BPELStringTranslator.getString("RULE_CREATION_DIALOG_DIRECTION", "Direction");
            }
        }
        return " ";
    }

    public void moveUp(int row) {
        if (row <= 0 || row >= this.m_data.size()) {
            return;
        }
        Object curObj = this.m_data.get(row);
        this.m_data.set(row, this.m_data.get(row - 1));
        this.m_data.set(row - 1, curObj);
        this.fireTableRowsUpdated(row - 1, row);
    }

    public void moveDown(int row) {
        if (row < 0 || row + 1 >= this.m_data.size()) {
            return;
        }
        Object curObj = this.m_data.get(row);
        this.m_data.set(row, this.m_data.get(row + 1));
        this.m_data.set(row + 1, curObj);
        this.fireTableRowsUpdated(row, row + 1);
    }
}

