/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.common.utils.ContentUtil;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.ElementVariableChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.TablePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.RuleBpelVariablesTableModel;
import oracle.tip.tools.ide.pm.modules.rules.RuleBuilderData;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.rules.TableRowData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.rules.dictionarybuilder.RuleInputOutputEditor;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.sdkmodel.SchemaElem;

public class RuleBpelVariablesPanel
extends TablePanel
implements ActionListener,
ListSelectionListener,
RuleInputOutputEditor {
    protected ButtonMenu m_btnMenu;
    protected JCheckBox m_resetCB;
    protected Scope m_activity;
    protected BPELGraphPane m_graphPane;
    protected JButton m_upBtn;
    protected JButton m_downBtn;
    protected RuleBuilderData m_ruleData;
    protected HashMap<QName, String> m_inputTypes = new HashMap();
    protected HashMap<QName, String> m_outputTypes = new HashMap();

    public RuleBpelVariablesPanel(BaseTableModel tabModel, RuleBuilderData data) {
        super(tabModel, new Insets(0, 0, 0, 0));
        this.m_ruleData = data;
        this.setTableLabelText(BPELStringTranslator.getString("RULE_CREATION_DIALOG_INPUTS_OUTPUTS", "Inputs and Outputs:"));
        this.createControls();
        this.updateButtons();
    }

    public void setup(BPELGraphPane graph, Scope activty) {
        this.m_graphPane = graph;
        this.m_activity = activty;
    }

    public List getVariables() {
        RuleBpelVariablesTableModel model = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        return new ArrayList(model.getData());
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(100);
                col.setMaxWidth(100);
                continue;
            }
            if (i == 3) {
                col.setPreferredWidth(30);
                continue;
            }
            col.setPreferredWidth(30);
        }
    }

    protected void createControls() {
        this.m_upBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_up_blue16"), (String)BPELStringTranslator.getString("MOVE_UP_TIP"), (String)BPELStringTranslator.getString("MOVE_UP_MNEMONIC"));
        this.m_downBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_down_blue16"), (String)BPELStringTranslator.getString("MOVE_DOWN_TIP"), (String)BPELStringTranslator.getString("MOVE_DOWN_MNEMONIC"));
        this.m_upBtn.addActionListener(this);
        this.m_downBtn.addActionListener(this);
        this.setColumnSizes();
        this.m_btnMenu = new ButtonMenu("", ImageCache.getIcon("add16"));
        Action[] actions = new Action[]{new CreateInputAction(), new CreateOutputAction()};
        this.m_btnMenu.setActions(actions);
        this.m_toolBar.removeAll();
        this.m_toolBar.add((Component)this.m_btnMenu);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_toolBar.add((Component)this.m_upBtn);
        this.m_toolBar.add((Component)this.m_downBtn);
        this.m_resetCB = new JCheckBox("", true);
        BPELStringTranslator.setButton(this.m_resetCB, BPELStringTranslator.getString("STATELESS_BTN", "&Stateless"));
        this.m_resetCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleBpelVariablesPanel.this.m_ruleData.reset_ = RuleBpelVariablesPanel.this.m_resetCB.isSelected();
            }
        });
        GraphUtils.addComponent((Container)this, (Component)this.m_resetCB, (int)0, (int)2, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void handleCreate(boolean isInput) {
        this.m_btnMenu.grabFocus();
        ElementVariableChooser dlg = new ElementVariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_activity);
        if (isInput) {
            dlg.setTitle(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_INPUT"));
        } else {
            dlg.setTitle(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_OUTPUT"));
        }
        RuleBpelVariablesTableModel tabModel = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        if (dlg.display() == 0) {
            boolean isUsed;
            Variable v = ((VariableChooser)dlg).getSelectedVariable();
            QName q = v.getElement();
            if (q == null) {
                q = v.getType();
            }
            boolean bl = isInput ? this.m_inputTypes.get(q) != null : (isUsed = this.m_outputTypes.get(q) != null);
            if (isUsed) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("RULE_DUPLICATED_TYPE_VAR_NOT_ALLOWED", "Variables with the same type are not allowed for Rules!"), (int)1);
                return;
            }
            TableRowData data = new TableRowData();
            data.m_direction = isInput;
            data.m_var = v;
            tabModel.getData().addElement(data);
            this.updateRuleData();
            tabModel.refresh();
            this.updateButtons();
            if (isInput) {
                this.m_inputTypes.put(q, v.getName());
            } else {
                this.m_outputTypes.put(q, v.getName());
            }
        }
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            RuleBpelVariablesTableModel tabModel = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
            int[] rows = this.m_table.getSelectedRows();
            this.updateButtons();
            this.updateRuleData();
            Vector data = tabModel.getData();
            for (int row : rows) {
                TableRowData d = (TableRowData)data.get(row);
                QName q = d.m_var.getElement();
                if (q == null) {
                    q = d.m_var.getType();
                }
                if (d.m_direction) {
                    this.m_inputTypes.remove(q);
                    continue;
                }
                this.m_outputTypes.remove(q);
            }
            tabModel.removeRows(rows);
        }
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        ListSelectionModel model = this.m_table.getSelectionModel();
        int sel = model.getMinSelectionIndex();
        if (sel == -1) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(false);
        } else if (sel == 0) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(this.m_table.getModel().getRowCount() > 1);
        } else {
            this.m_upBtn.setEnabled(true);
            if (sel + 1 == this.m_table.getModel().getRowCount()) {
                this.m_downBtn.setEnabled(false);
            } else {
                this.m_downBtn.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_removeBtn) {
            this.handleRemove();
        } else if (src == this.m_upBtn) {
            this.performMoveUp();
        } else if (src == this.m_downBtn) {
            this.performMoveDown();
        }
    }

    public void performMoveUp() {
        RuleBpelVariablesTableModel model = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveUp(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel - 1, sel - 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel - 1, 0, true));
        }
    }

    public void performMoveDown() {
        RuleBpelVariablesTableModel model = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveDown(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel + 1, sel + 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel + 1, 0, true));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    public JComponent getInputOutputEditor() {
        return this;
    }

    public void saveToRuleData(WizardData ruleData) {
        RuleBuilderData wizardData = (RuleBuilderData)ruleData;
        RuleBpelVariablesTableModel tableModel = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        Vector data = tableModel.getData();
        ArrayList inputXSD = new ArrayList();
        ArrayList outputXSD = new ArrayList();
        HashSet<SchemaElem> inXSDs = new HashSet<SchemaElem>();
        HashSet<SchemaElem> outXSDs = new HashSet<SchemaElem>();
        ArrayList<Variable> inputVars = new ArrayList<Variable>();
        ArrayList<Variable> outputVars = new ArrayList<Variable>();
        for (Object o : data) {
            TableRowData l = (TableRowData)o;
            Boolean dir = l.m_direction;
            Variable var = l.m_var;
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
            Process processModel = graphModel.getProcess();
            URL loc = RulesUtil.resolveVariableDef(var, this.m_graphPane.getBPELProject(), processModel);
            SchemaElem pair = new SchemaElem();
            try {
                if (loc != null && !ContentUtil.isXSDDocument((URL)loc)) {
                    URI uri = new URI(URIUtil.escapeURIString((String)loc.toExternalForm()));
                    WSDLPartData[] parts = WSDLUtil.getParts((URI)uri, (String)var.getMessageType().getLocalPart(), (String)var.getMessageType().getNamespaceURI());
                    List inlineSchemaList = null;
                    for (WSDLPartData part : parts) {
                        String type = part.getPartType();
                        int xsdType = part.getPartXSDType();
                        if (xsdType == 3) {
                            pair.m_elemName = new QName(part.getTargetNamespace(), type);
                        } else {
                            if (inlineSchemaList == null) {
                                inlineSchemaList = WSDLUtil.getSchemaElement((URI)uri);
                            }
                            pair.m_schemaURL = loc;
                            pair.m_elemName = new QName(part.getTargetNamespace(), type);
                            pair.m_inlineSchemas = inlineSchemaList;
                        }
                        pair.m_aliasInfo = var.getName() + "_" + part.getPartName();
                    }
                } else if (loc == null) {
                    pair.m_elemName = var.getType();
                    pair.m_aliasInfo = var.getName();
                } else {
                    boolean bothInputOutput;
                    pair.m_schemaURL = loc;
                    if (var.getElement() != null) {
                        pair.m_elemName = var.getElement();
                    } else {
                        pair.m_elemType = var.getType();
                    }
                    pair.m_aliasInfo = var.getName();
                    QName q = var.getElement();
                    if (q == null) {
                        q = var.getType();
                    }
                    boolean bl = dir.booleanValue() ? this.m_outputTypes.get(q) != null : (bothInputOutput = this.m_inputTypes.get(q) != null);
                    if (bothInputOutput) {
                        pair.m_aliasInfo = "Inout_" + this.m_inputTypes.get(q) + "_" + this.m_outputTypes.get(q);
                    }
                }
                if (dir.booleanValue()) {
                    inXSDs.add(pair);
                    inputVars.add(var);
                    continue;
                }
                outXSDs.add(pair);
                outputVars.add(var);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        inputXSD.addAll(inXSDs);
        outputXSD.addAll(outXSDs);
        wizardData.setInputVarsXSD(inputXSD);
        wizardData.setOutputVarsXSD(outputXSD);
        wizardData.setInputVars(inputVars);
        wizardData.setOutputVars(outputVars);
    }

    public void updateRuleData() {
        RuleBpelVariablesTableModel tableModel = (RuleBpelVariablesTableModel)((Object)this.m_table.getModel());
        Vector data = tableModel.getData();
        ArrayList<Variable> inputVars = new ArrayList<Variable>();
        ArrayList<Variable> outputVars = new ArrayList<Variable>();
        for (Object o : data) {
            TableRowData l = (TableRowData)o;
            Boolean dir = l.m_direction;
            Variable var = l.m_var;
            if (dir.booleanValue()) {
                inputVars.add(var);
                continue;
            }
            outputVars.add(var);
        }
        this.m_ruleData.setInputVars(inputVars);
        this.m_ruleData.setOutputVars(outputVars);
    }

    class CreateOutputAction
    extends AbstractAction {
        public CreateOutputAction() {
            super(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_OUTPUT") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RuleBpelVariablesPanel.this.handleCreate(false);
        }
    }

    class CreateInputAction
    extends AbstractAction {
        public CreateInputAction() {
            super(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_INPUT") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RuleBpelVariablesPanel.this.handleCreate(true);
        }
    }
}

