/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.wsdl.Definition;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.IRuleCatalog;
import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.RuleEngineUtil;
import oracle.bpel.services.rules.rpi.RuleProviderException;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TArgumentList;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpel.services.rules.rpi.model.TFactType;
import oracle.bpel.services.rules.rpi.model.TFunction;
import oracle.bpel.services.rules.rpi.model.TParameter;
import oracle.bpel.services.rules.rpi.model.TParameterDirection;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.bpel.services.rules.rpi.model.TPrimitiveFactType;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.model.TRuleEngineRepository;
import oracle.bpel.services.rules.rpi.model.TXmlFactType;
import oracle.bpel.services.rules.rpi.oracle2.OracleRuleEngine;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rule;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.DropNode;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAInvalidFileNameException;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.model.SCAComponent;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAImplementation;
import oracle.tip.tools.ide.fabric.model.SCASource;
import oracle.tip.tools.ide.fabric.model.SCATarget;
import oracle.tip.tools.ide.fabric.model.SCAWire;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageFactory;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleTablePanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.AssignNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.RuleNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.patterns.PatternFragmentUtil;
import oracle.tip.tools.ide.pm.modules.rules.BpelRulesCreationDialog;
import oracle.tip.tools.ide.pm.modules.rules.DecisionServiceConstants;
import oracle.tip.tools.ide.pm.modules.rules.Pattern;
import oracle.tip.tools.ide.pm.modules.rules.PatternName;
import oracle.tip.tools.ide.pm.modules.rules.RuleBuilderData;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAException;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.rules.dictionarybuilder.DictionaryFileBuilder;
import oracle.tip.tools.ide.rules.dictionarybuilder.RuleType;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.DictionaryBuilderUtil;
import oracle.xml.parser.schema.XSDNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RuleActivityDialog
extends BaseEditingPage
implements ActionListener,
EditorPage {
    private static final String BUSINESS_RULE_ACTIVITY_NAME = BPELStringTranslator.getString("BUSINESS_RULE_ACTIVITY_NAME");
    private static final String NO_DICT = BPELStringTranslator.getString("NO_DS_SELECTION");
    protected static final Font DEFAULT_FONT = new Font(UIManager.getFont("Label.font").getFontName(), 0, UIManager.getFont("Label.font").getSize());
    JTextField m_nameField = new JTextField();
    Vector m_opVector = new Vector();
    Vector m_serviceVector = new Vector();
    Vector m_decsFilesVector = new Vector();
    JComboBox m_operationsCombo = new JComboBox(this.m_opVector);
    JComboBox m_ServicesCombo = new JComboBox(this.m_serviceVector);
    JComboBox m_DecsFilesCombo = new JComboBox(this.m_decsFilesVector);
    JTabbedPane m_tabbedPane = new JTabbedPane();
    BPELProject m_prj = null;
    IRuleSet m_ruleSet;
    CopyRuleTableModel m_inputModel;
    CopyRuleTableModel m_outputModel;
    RuleAssignTablePanel m_inputTablePnl;
    RuleAssignTablePanel m_outputTablePnl;
    CopyPageInputs m_inputFactIn;
    CopyPageInputs m_outputFactIn;
    Rule m_ruleActivity;
    RuleNode m_ruleNode;
    Sequence m_sequence;
    SequenceNode m_sequenceNode;
    InvokeNode m_invokeNode;
    PartnerLinkNode m_partnerLinkNode = null;
    JButton m_createServiceBtn;
    protected JButton m_editBtn;
    IRuleCatalog m_catalog;
    boolean m_bEditing = false;
    private List<SCAComponent> decisionComponents = new ArrayList<SCAComponent>();
    boolean m_ruleFileSelected = false;
    List m_assertVarList;
    List m_watchVarList;
    Service m_service;
    Pattern m_pattern;
    DecisionServices m_decisionServices;
    DecisionServices m_selDecService;
    SCAComposite composite;
    protected CardPanel m_cardPnl;
    protected List<Variable> m_inputVars = new ArrayList<Variable>();
    protected List<Variable> m_outputVars = new ArrayList<Variable>();
    private final String EDITING_PNL = "EDITING_PANEL";
    private final String NON_EDITING_PNL = "NON_EDITING_PANEL";
    private List<String> m_varNames = new ArrayList<String>();

    public RuleActivityDialog(GraphPane pane, oracle.tip.tools.ide.common.graph.model.Node n) throws Exception {
        super((BPELGraphPane)pane);
        this.m_prj = this.getBPELProject();
        this.m_ruleNode = (RuleNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_ruleActivity = (Rule)model;
        if (this.m_prj instanceof JDevBPELProject) {
            this.composite = ((JDevBPELProject)this.m_prj).getSCAComposite();
        }
        this.fillDecisionComponentsList();
        if (this.m_ruleActivity != null) {
            String targetWireName;
            this.m_nameField.setText(this.m_ruleActivity.getName());
            Assign assign = this.m_ruleActivity.getBPELToFactsAssign();
            if (assign != null) {
                this.m_inputModel = new CopyRuleTableModel();
                this.setModelData(this.m_inputModel, assign);
            }
            if ((assign = this.m_ruleActivity.getFactsToBPELAssign()) != null) {
                this.m_outputModel = new CopyRuleTableModel();
                this.setModelData(this.m_outputModel, assign);
            }
            if ((targetWireName = this.getTargetWireName()) != null && targetWireName.indexOf("/") != -1) {
                String bLRuleComponent = targetWireName.substring(0, targetWireName.indexOf("/"));
                String bLRuleService = targetWireName.substring(targetWireName.indexOf("/") + 1, targetWireName.length());
                String operation = this.m_ruleActivity.getOperationName();
                this.populateDecsFilesCombo(bLRuleComponent, bLRuleService);
                this.m_ServicesCombo.addActionListener(this);
                this.populateOpCombo(operation);
                this.m_operationsCombo.addActionListener(this);
                this.m_bEditing = true;
                this.m_ruleFileSelected = true;
            } else {
                this.populateDecsFilesCombo(null, null);
                if (this.m_serviceVector.size() > 0) {
                    this.m_service = (Service)this.m_serviceVector.get(0);
                }
                if (this.m_service != null) {
                    this.populateOpCombo(this.m_service.getTDecisionService().getName());
                } else {
                    this.populateOpCombo(null);
                }
            }
        }
        this.loadUI();
        this.jbInit();
        if (this.m_bEditing && this.m_service != null) {
            String decisionPrefix = this.m_graphModel.getProcess().getPrefixForNamespace(this.m_service.getTDecisionService().getTargetNamespace());
            String patternName = this.m_pattern.getTPattern().getName().value();
            patternName = this.getServiceOpName(patternName);
            this.setAssertCopyList("dsIn", decisionPrefix, patternName);
            this.setWatchCopyList("dsOut", decisionPrefix, patternName);
        }
    }

    private String getTargetWireName() {
        Invoke invoke = this.m_ruleActivity.getInvoke();
        if (invoke == null) {
            return null;
        }
        String plName = invoke.getPartnerLink();
        List wires = this.composite.getWires();
        if (wires == null) {
            return null;
        }
        for (int count = 0; count < wires.size(); ++count) {
            SCAWire wire = (SCAWire)wires.get(count);
            try {
                SCASource source = wire.getSource();
                String name = source.getDisplayString();
                if (!name.endsWith(plName)) continue;
                SCATarget target = wire.getTarget();
                return target.getDisplayString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    protected void populateDecsFilesCombo(String businessRuleComponentName, String serviceName) {
        this.m_service = null;
        this.m_decsFilesVector.clear();
        DecsFile decsFile = new DecsFile(null);
        decsFile.setDiaplayName(NO_DICT);
        this.m_decsFilesVector.add(decsFile);
        this.readDescisonServiceFiles(businessRuleComponentName, serviceName);
        if (null == serviceName) {
            this.m_DecsFilesCombo.setSelectedIndex(0);
        }
    }

    private void fillDecisionComponentsList() {
        if (this.composite == null) {
            return;
        }
        List components = this.composite.getComponents();
        if (components == null) {
            return;
        }
        SCAComponent component = null;
        HashSet<SCAComponent> set = new HashSet<SCAComponent>();
        set.addAll(this.decisionComponents);
        for (int i = 0; i < components.size(); ++i) {
            component = (SCAComponent)components.get(i);
            if (!component.getImplementation().isDecisionImplementation() || set.contains(component)) continue;
            this.decisionComponents.add(component);
        }
    }

    private void loadUI() {
        this.m_tabbedPane.removeAll();
        Assign assign = this.m_ruleActivity.getBPELToFactsAssign();
        if (assign != null) {
            this.createCopyPages(true);
        }
        if ((assign = this.m_ruleActivity.getFactsToBPELAssign()) != null) {
            this.createCopyPages(false);
        }
        this.populateFactTables();
    }

    private void readDescisonServiceFiles(String businessRuleComponentName, String serviceName) {
        if (!(this.m_prj instanceof JDevBPELProject)) {
            return;
        }
        SCAProject project = this.getScaProject();
        if (project == null) {
            return;
        }
        SCAComponent component = null;
        for (int i = 0; i < this.decisionComponents.size(); ++i) {
            component = this.decisionComponents.get(i);
            SCAImplementation impl = component.getImplementation();
            String path = project.getSCARoot().getFile() + impl.getSrcURI();
            File file = new File(path);
            DecsFile decsFile = new DecsFile(file);
            decsFile.setDiaplayName(component.getName());
            this.m_decsFilesVector.add(decsFile);
            if (!component.getName().equals(businessRuleComponentName)) continue;
            this.m_DecsFilesCombo.setSelectedItem(decsFile);
            this.parseFile(file, serviceName);
        }
    }

    private void parseFile(File f, String serviceName) {
        DecisionServices _services = null;
        try {
            RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
            Unmarshaller unmarshaller = rpi_factory.createUnmarshaller();
            this.m_selDecService = _services = (DecisionServices)unmarshaller.unmarshal(f);
            List serviceList = _services.getDecisionServices();
            Services services = new Services(_services);
            for (int i = 0; i < serviceList.size(); ++i) {
                TDecisionService tService = (TDecisionService)serviceList.get(i);
                Service service = new Service(services, tService);
                this.m_serviceVector.add(service);
                if (this.m_ServicesCombo.getSelectedIndex() < 0) {
                    this.m_ServicesCombo.setSelectedItem(service);
                }
                if (this.m_service != null && !tService.getName().equals(serviceName)) continue;
                this.m_service = service;
                this.m_ServicesCombo.setSelectedItem(service);
            }
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void parseFile(File f) {
        this.m_serviceVector.clear();
        this.m_ServicesCombo.removeAllItems();
        DecisionServices _services = null;
        try {
            RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
            Unmarshaller unmarshaller = rpi_factory.createUnmarshaller();
            this.m_selDecService = _services = (DecisionServices)unmarshaller.unmarshal(f);
            List serviceList = _services.getDecisionServices();
            Services services = new Services(_services);
            for (int i = 0; i < serviceList.size(); ++i) {
                TDecisionService tService = (TDecisionService)serviceList.get(i);
                Service service = new Service(services, tService);
                this.m_serviceVector.add(service);
                this.m_ServicesCombo.setSelectedItem(service);
            }
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void populateOpCombo(String operation) {
        this.m_opVector.clear();
        if (this.m_service == null) {
            return;
        }
        List patternList = this.m_service.getTDecisionService().getPatterns();
        for (int j = 0; j < patternList.size(); ++j) {
            TPattern tPattern = (TPattern)patternList.get(j);
            Pattern pattern = new Pattern(tPattern);
            this.m_opVector.add(pattern);
            if (j != 0 && (operation == null || !tPattern.getName().value().equalsIgnoreCase(operation))) continue;
            this.m_pattern = pattern;
        }
        if (this.m_pattern != null) {
            this.m_operationsCombo.setSelectedItem(this.m_pattern);
        } else if (this.m_opVector.size() > 0) {
            this.m_operationsCombo.setSelectedItem(this.m_opVector.size() - 2);
        }
    }

    private void createNewRuleNode() {
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            Object p = null;
            int index = 0;
            oracle.tip.tools.ide.common.graph.model.Node pNode = this.m_ruleNode.getParentNode();
            if (pNode != null) {
                p = pNode.getUserObject();
                index = pNode.indexOf((oracle.tip.tools.ide.common.graph.model.Node)this.m_ruleNode);
            }
            if (p != null) {
                ((ContainerActivity)p).deleteActivity((Activity)this.m_ruleActivity);
            }
            this.m_ruleActivity = (Rule)BPELParser.createImplementation(Rule.class);
            this.m_ruleActivity.setDOMElement(this.m_ruleActivity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            this.m_ruleActivity.setName(this.m_nameField.getText());
            this.m_ruleNode.setUserObject(this.m_ruleActivity);
            if (p != null) {
                ((ContainerActivity)p).insertActivity(index / 2, (Activity)this.m_ruleActivity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createInvoke() {
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            Invoke invoke = (Invoke)BPELParser.createImplementation(Invoke.class);
            invoke.setDOMElement(invoke.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            this.m_sequence.addActivity((Activity)invoke);
            this.m_invokeNode = new InvokeNode();
            this.m_invokeNode.setUserObject(invoke);
            this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_sequenceNode, (oracle.tip.tools.ide.common.graph.model.Node)this.m_invokeNode);
            this.m_invokeNode.setName("Invoke");
            this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_invokeNode, (oracle.tip.tools.ide.common.graph.model.Node)new PortNode(1));
            this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_invokeNode, (oracle.tip.tools.ide.common.graph.model.Node)new PortNode(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Sequence createSequenceNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
        sequence.setDOMElement(sequence.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Sequence", Sequence.class);
        sequence.setName(name);
        try {
            this.m_ruleActivity.addActivity((Activity)sequence);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SequenceNode sequenceNode = new SequenceNode();
        sequenceNode.setUserObject(sequence);
        this.m_graphModel.addChildNode(this.m_ruleNode, (oracle.tip.tools.ide.common.graph.model.Node)sequenceNode);
        this.m_graphModel.addChildNode(this.m_ruleNode, (oracle.tip.tools.ide.common.graph.model.Node)new DropNode());
        this.m_sequence = sequence;
        this.m_sequenceNode = sequenceNode;
        return sequence;
    }

    private Assign createAssignNode(String name) {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Assign assign = (Assign)BPELParser.createImplementation(Assign.class);
        assign.setDOMElement(assign.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        try {
            this.m_sequence.addActivity((Activity)assign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assign.setName(name);
        AssignNode assignNode = new AssignNode();
        assignNode.setUserObject(assign);
        this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_sequenceNode, (oracle.tip.tools.ide.common.graph.model.Node)assignNode);
        assignNode.setName(name);
        return assign;
    }

    private boolean isReturnFacts(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        TDecisionServicePatternName name = pattern.getTPattern().getName();
        return name == TDecisionServicePatternName.WATCH || name == TDecisionServicePatternName.ASSERT_EXECUTE_WATCH_STATEFUL || name == TDecisionServicePatternName.ASSERT_EXECUTE_WATCH_STATELESS || name == TDecisionServicePatternName.CALL_FUNCTION_STATEFUL || name == TDecisionServicePatternName.CALL_FUNCTION_STATELESS;
    }

    private boolean isFunction() {
        assert (this.m_pattern != null);
        TDecisionServicePatternName name = this.m_pattern.getTPattern().getName();
        return name == TDecisionServicePatternName.CALL_FUNCTION_STATEFUL || name == TDecisionServicePatternName.CALL_FUNCTION_STATELESS;
    }

    private boolean isInputFacts(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        TDecisionServicePatternName name = pattern.getTPattern().getName();
        return name != TDecisionServicePatternName.WATCH;
    }

    private void setModelData(CopyRuleTableModel model, Assign assign) {
        Vector<Copy> data = new Vector<Copy>();
        List copyRules = assign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                data.add(copy);
            }
        }
        model.setData(data);
    }

    private void createCopyPages(boolean isInput) {
        RuleAssignTablePanel panel = null;
        CopyPageInputs factsIn = null;
        CopyRuleTableModel model = null;
        Assign assign = null;
        if (isInput) {
            if (this.m_inputModel == null) {
                this.m_inputModel = new CopyRuleTableModel();
            }
            this.m_inputTablePnl = new RuleAssignTablePanel(this.m_inputModel, this.m_graphPane);
            assign = this.m_ruleActivity.getBPELToFactsAssign();
            this.m_inputFactIn = new CopyPageInputs((Activity)assign);
            panel = this.m_inputTablePnl;
            model = this.m_inputModel;
            factsIn = this.m_inputFactIn;
        } else {
            if (this.m_outputModel == null) {
                this.m_outputModel = new CopyRuleTableModel();
            }
            this.m_outputTablePnl = new RuleAssignTablePanel(this.m_outputModel, this.m_graphPane);
            assign = this.m_ruleActivity.getFactsToBPELAssign();
            this.m_outputFactIn = new CopyPageInputs((Activity)assign);
            panel = this.m_outputTablePnl;
            factsIn = this.m_outputFactIn;
            model = this.m_outputModel;
        }
        ArrayList<String> selList = new ArrayList<String>();
        selList.add(BPELStringTranslator.getString("DLG_COMBO_COPY_TYPE"));
        CopyRuleTablePanel.MyRenderer renderer = new CopyRuleTablePanel.MyRenderer();
        TableColumnModel colModel = panel.getTable().getColumnModel();
        this.setTableProperties(renderer, colModel);
        if (isInput) {
            factsIn.storeData("ToTypeSelList", selList);
        } else {
            factsIn.storeData("FromTypeSelList", selList);
        }
        panel.setActivity((Activity)assign);
        if (isInput) {
            this.m_tabbedPane.addTab(BPELStringTranslator.getString("DLG_TAB_TITLE_RULE_INPUT"), panel);
        } else {
            this.m_tabbedPane.addTab(BPELStringTranslator.getString("DLG_TAB_TITLE_RULE_OUTPUT"), panel);
        }
        panel.updateButtons();
    }

    private void setTableProperties(CopyRuleTablePanel.MyRenderer renderer, TableColumnModel colModel) {
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(20);
                col.setMaxWidth(20);
                col.setCellRenderer(new CopyRuleTablePanel.ImageColumnTableCellRenderer());
                continue;
            }
            col.setCellRenderer(renderer);
            col.setWidth(190);
            col.setPreferredWidth(190);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setBorderPainted(false);
        JLabel nameLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)nameLbl, (Component)this.m_nameField, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel businessRuleLbl = new JLabel();
        BPELStringTranslator.setLabel(businessRuleLbl, this.m_DecsFilesCombo, BPELStringTranslator.getString("DLG_LBL_BUSINESS_RULE"));
        this.add((Component)nameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.m_nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)businessRuleLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.m_editBtn = new JButton(ImageCache.getIcon("edit16"));
        this.m_editBtn.setToolTipText(BPELStringTranslator.getString("EDIT_DICTIONARY_TIP"));
        this.m_editBtn.addActionListener(this);
        if (this.m_bEditing) {
            JTextField descFileTextField = new JTextField();
            if (this.m_DecsFilesCombo.getSelectedItem() != null) {
                descFileTextField.setText(this.m_DecsFilesCombo.getSelectedItem().toString());
            } else {
                descFileTextField.setText(BPELStringTranslator.getString("BRL_COMP_NOT_FOUND"));
            }
            descFileTextField.setEnabled(false);
            this.add((Component)descFileTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            toolbar.add(this.m_editBtn);
            this.add((Component)toolbar, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        } else {
            this.add((Component)this.m_DecsFilesCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.m_createServiceBtn = new JButton(ImageCache.getIcon("add16"));
            this.m_createServiceBtn.setToolTipText(BPELStringTranslator.getString("BTN_CREATE_RULE_SERVICE"));
            this.m_createServiceBtn.addActionListener(this);
            this.m_editBtn.setEnabled(false);
            toolbar.add(this.m_createServiceBtn);
            toolbar.add(this.m_editBtn);
            this.add((Component)toolbar, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        }
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add("EDITING_PANEL", (Component)this.createEditingPnl());
        this.m_cardPnl.add("NON_EDITING_PANEL", (Component)this.createNonEditingPnl());
        this.add((Component)this.m_cardPnl, new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_bEditing) {
            this.m_cardPnl.show("EDITING_PANEL");
        } else {
            this.m_cardPnl.show("NON_EDITING_PANEL");
        }
    }

    private JPanel createEditingPnl() {
        JPanel editingPnl = new JPanel();
        editingPnl.setLayout(new GridBagLayout());
        MultiLineLabel factLbl = new MultiLineLabel(WordWrapper.getTextWrapper(), BPELStringTranslator.getString("DLG_INST_VAR_FACT_MAP"));
        JLabel servicesLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)servicesLbl, (Component)this.m_ServicesCombo, (String)BPELStringTranslator.getString("DLG_LBL_SERVICE"));
        if (this.m_bEditing) {
            editingPnl.add((Component)servicesLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
            JTextField servicesTextField = new JTextField();
            if (this.m_ServicesCombo.getSelectedItem() != null) {
                servicesTextField.setText(this.m_ServicesCombo.getSelectedItem().toString());
            } else {
                servicesTextField.setText(BPELStringTranslator.getString("BRL_SERVICE_NOT_FOUND"));
            }
            servicesTextField.setEnabled(false);
            editingPnl.add((Component)servicesTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        } else {
            editingPnl.add((Component)servicesLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            editingPnl.add((Component)this.m_ServicesCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        JLabel opLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)opLbl, (Component)this.m_operationsCombo, (String)BPELStringTranslator.getString("LBL_OPERATION"));
        editingPnl.add((Component)opLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.m_bEditing) {
            JTextField textField = new JTextField();
            if (this.m_operationsCombo.getSelectedItem() != null) {
                textField.setText(this.m_operationsCombo.getSelectedItem().toString());
            } else {
                textField.setText(BPELStringTranslator.getString("BRL_OPR_NOT_FOUND"));
            }
            textField.setEnabled(false);
            editingPnl.add((Component)textField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        } else {
            editingPnl.add((Component)this.m_operationsCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)factLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_tabbedPane, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        editingPnl.add((Component)panel, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_ServicesCombo.addActionListener(this);
        this.m_DecsFilesCombo.addActionListener(this);
        this.m_operationsCombo.addActionListener(this);
        return editingPnl;
    }

    private JPanel createNonEditingPnl() {
        JPanel pnl = new JPanel(new GridBagLayout());
        MultiLineLabel tabbedPaneLbl = new MultiLineLabel(WordWrapper.getTextWrapper(), BPELStringTranslator.getString("DLG_INIT_INST_VAR_FACT_MAP"));
        GraphUtils.addComponent((Container)pnl, (Component)tabbedPaneLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(20, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)pnl, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return pnl;
    }

    private void populatePatterns(Service service) {
        this.populatePatterns(service, null);
    }

    private void populatePatterns(Service service, String operation) {
        if (service == null) {
            return;
        }
        this.m_opVector.clear();
        List patternList = service.getTDecisionService().getPatterns();
        Pattern selectedPattern = null;
        for (int j = 0; j < patternList.size(); ++j) {
            TPattern tPattern = (TPattern)patternList.get(j);
            Pattern pattern = new Pattern(tPattern);
            this.m_opVector.add(pattern);
            if (operation == null || !tPattern.getName().value().equalsIgnoreCase(operation)) continue;
            selectedPattern = pattern;
        }
        if (selectedPattern != null) {
            this.m_operationsCombo.setSelectedItem(selectedPattern);
        } else {
            this.m_operationsCombo.setSelectedIndex(this.m_opVector.size() - 2);
        }
    }

    public oracle.tip.tools.ide.common.graph.model.Node getNode() {
        if (!this.m_bEditing) {
            return null;
        }
        return this.m_ruleNode;
    }

    protected void editRuleDictionary() {
        if (this.m_selDecService != null) {
            List plist = this.m_selDecService.getRuleEngineProviders();
            if (plist != null && plist.size() > 0) {
                TRuleEngineRepository reposit = ((TRuleEngineProvider)plist.get(0)).getRepository();
                URL url = URLFileSystem.getParent((URL)this.m_prj.getProjectURL());
                String dictPath = reposit.getPath();
                URL dictURL = null;
                try {
                    dictURL = URLFactory.newURL((String)dictPath);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (dictURL == null) {
                    dictURL = URLFactory.newURL((URL)this.m_prj.getProjectURL(), (String)dictPath.substring(dictPath.indexOf("/") + 1));
                }
                final URL dictionaryURL = dictURL;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        RuleActivityDialog.this.openRuleDictionary(dictionaryURL);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
            this.cancelEditing();
        }
    }

    protected void openRuleDictionary(URL dictURL) {
        try {
            IDE ide = IDEResolver.getIDE();
            ide.openEditor(dictURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_ServicesCombo) {
                this.m_service = (Service)this.m_ServicesCombo.getSelectedItem();
                this.populatePatterns(this.m_service);
            } else if (e.getSource() == this.m_DecsFilesCombo) {
                this.handleDescFileSelection();
            } else if (e.getSource() == this.m_operationsCombo) {
                this.loadAssertPanels();
            } else if (e.getSource() == this.m_createServiceBtn) {
                RuleBuilderData data = new RuleBuilderData();
                data.setProject((Project)this.m_graphModel.getBPELProject().getProjectContext());
                data.setType(RuleType.RULES);
                DictionaryFileBuilder builder = DictionaryBuilderUtil.createBuilder((WizardData)data);
                BpelRulesCreationDialog dialog = new BpelRulesCreationDialog(this.m_graphPane, this.m_ruleActivity, data, builder);
                if (dialog.display() == 0) {
                    this.m_inputVars = data.getInputVars();
                    this.m_outputVars = data.getOutputVars();
                    this.addNewComponent(data.getName(), data.reset_);
                    this.saveDialog();
                }
            } else if (e.getSource() == this.m_editBtn) {
                this.editRuleDictionary();
            }
        }
        catch (Throwable ex) {
            GraphUtils.displayError((Component)this, (Throwable)ex);
        }
    }

    private void cleanUp() {
        try {
            Variables vars = this.m_ruleActivity.getVariables();
            if (vars != null) {
                List l = vars.getVariables();
                for (int i = l.size() - 1; i >= 0; --i) {
                    Variable v = (Variable)l.get(i);
                    if (!v.getName().equals("dsOut") && !v.getName().equals("dsIn") && !this.m_varNames.contains(v.getName())) continue;
                    this.m_ruleActivity.deleteVariable(v);
                }
                this.m_varNames.clear();
            }
            if (this.m_sequence != null) {
                this.m_ruleActivity.deleteActivity((Activity)this.m_sequence);
                this.m_sequence = null;
            }
            if (this.m_sequenceNode != null) {
                this.m_graphModel.deleteNode(this.m_ruleNode, (oracle.tip.tools.ide.common.graph.model.Node)this.m_sequenceNode);
                this.m_sequenceNode = null;
            }
            if (this.m_partnerLinkNode != null) {
                this.m_processModel.deletePartnerLink((PartnerLink)this.m_partnerLinkNode.getUserObject());
                SwimLaneNode m_swimLaneNode = this.m_graphModel.getRightSwimLaneNode();
                this.m_graphModel.deleteNode((oracle.tip.tools.ide.common.graph.model.Node)m_swimLaneNode, (oracle.tip.tools.ide.common.graph.model.Node)this.m_partnerLinkNode);
                this.m_partnerLinkNode = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleDescFileSelection() {
        DecsFile name = (DecsFile)this.m_DecsFilesCombo.getSelectedItem();
        String descFN = name.toString();
        if (descFN.equals(NO_DICT)) {
            this.m_ruleFileSelected = false;
            this.m_editBtn.setEnabled(false);
            this.m_cardPnl.show("NON_EDITING_PANEL");
            this.cleanUp();
        } else {
            this.m_ruleFileSelected = true;
            this.parseFile(name.getDecsFile());
            this.m_editBtn.setEnabled(true);
            this.m_cardPnl.show("EDITING_PANEL");
        }
    }

    private void saveDialog() {
        ApplyCancelPanel panel = this.getApplyCancelPanel();
        panel.handleOK();
    }

    private void updateRuleNode() {
        this.m_ruleActivity.setName(this.m_nameField.getText());
        this.m_ruleActivity.getValidationReport(new ValidationContext(this.m_processModel), true);
    }

    private void populateFactTables() {
        Variables vars = this.m_processModel.getVariables();
        if (vars == null) {
            return;
        }
        List varList = vars.getVariables();
        Pattern pattern = (Pattern)this.m_operationsCombo.getSelectedItem();
        if (pattern == null) {
            return;
        }
        Service service = (Service)this.m_ServicesCombo.getSelectedItem();
        if (service == null) {
            return;
        }
        try {
            this.m_ruleSet = service.getRuleSet();
            List assertFactNameList = service.getAssertFacts(pattern);
            List watchFactNameList = service.getWatchFacts(pattern);
            this.setFactsIn(assertFactNameList, watchFactNameList);
            if (this.m_inputFactIn != null) {
                this.m_inputFactIn.storeData("ToVariables", this.m_assertVarList);
                this.m_inputFactIn.storeData("FromVariables", varList);
                this.m_inputFactIn.storeData("ShowFlatListToVar", Boolean.TRUE);
                this.m_inputTablePnl.getTable().setSize(180, 120);
                this.m_inputTablePnl.setInput(this.m_inputFactIn);
                this.m_inputTablePnl.updateButtons();
            }
            if (this.m_outputFactIn != null) {
                this.m_outputFactIn.storeData("FromVariables", this.m_watchVarList);
                this.m_outputFactIn.storeData("ToVariables", varList);
                this.m_outputFactIn.storeData("ShowFlatListFromVar", Boolean.TRUE);
                this.m_outputTablePnl.getTable().setSize(180, 120);
                this.m_outputTablePnl.setInput(this.m_outputFactIn);
                this.m_outputTablePnl.updateButtons();
            }
            this.m_tabbedPane.setVisible(true);
        }
        catch (Throwable e) {
            Exception exception = new Exception(BPELStringTranslator.getString("SDK_PARSE_ERROR"));
            exception.setStackTrace(e.getStackTrace());
            GraphUtils.displayError((Component)this, (Throwable)exception);
        }
    }

    private void setFactsIn(List assertFactNameList, List watchFactNameList) throws Exception {
        this.m_assertVarList = this.createVariables(assertFactNameList, true);
        this.m_watchVarList = this.createVariables(watchFactNameList, false);
        if (this.m_assertVarList != null && this.m_assertVarList.size() > 0 && this.m_inputFactIn != null) {
            this.m_inputFactIn.storeData("ToSelectedVar", this.m_assertVarList.get(0));
        }
        if (this.m_watchVarList != null && this.m_watchVarList.size() > 0 && this.m_inputFactIn != null) {
            this.m_inputFactIn.storeData("ToSelectedVar", this.m_watchVarList.get(0));
        }
    }

    private List<Variable> findVariables(boolean isInput) {
        Variables vars = this.m_ruleActivity.getVariables();
        if (vars == null) {
            return null;
        }
        List varsList = vars.getVariables();
        String suffix = isInput ? "_i" : "_o";
        ArrayList<Variable> varList = new ArrayList<Variable>();
        for (Variable var : varsList) {
            if (!var.getName().endsWith(suffix)) continue;
            varList.add(var);
        }
        return varList;
    }

    private List createVariables(List factNameList, boolean isInput) throws Exception {
        if (factNameList == null) {
            return new ArrayList();
        }
        IDataModel dataModel = this.m_catalog.getDataModel();
        List factList = dataModel.getFactTypes();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        int factIndex = 0;
        String suffix = isInput ? "_i" : "_o";
        for (int i = 0; i < factNameList.size(); ++i) {
            String factName = (String)factNameList.get(i);
            Variable factVar = this.findFactVariable(factName, isInput);
            if (factVar != null) {
                varList.add(factVar);
                continue;
            }
            for (int j = factIndex; j < factList.size(); ++j) {
                XSDNode xsdNode;
                TFactType fact = (TFactType)factList.get(j);
                String dataModelFactName = fact.getName();
                if (!dataModelFactName.equals(factName)) continue;
                if (fact instanceof TXmlFactType) {
                    TXmlFactType xmlFact = (TXmlFactType)fact;
                    String schemaLocation = this.importSchema(xmlFact.getSchemaLocation());
                    xmlFact.setSchemaLocation(URIUtil.escapeURIString((String)schemaLocation));
                    xsdNode = dataModel.getXSD(fact);
                    Variable var = this.createVariable(factName.replaceAll("\\.", "_") + suffix, xsdNode, schemaLocation);
                    this.m_ruleActivity.addVariable(var);
                    varList.add(var);
                    continue;
                }
                if (!(fact instanceof TPrimitiveFactType)) continue;
                xsdNode = dataModel.getXSD(fact);
                Variable var = this.createVariable(factName.replaceAll("\\.", "_") + suffix, xsdNode, null);
                this.m_ruleActivity.addVariable(var);
                varList.add(var);
            }
        }
        return varList;
    }

    private Variable findFactVariable(String factName, boolean isInput) {
        List<Variable> oldVars = this.findVariables(isInput);
        if (oldVars == null) {
            return null;
        }
        String suffix = isInput ? "_i" : "_o";
        for (Variable v : oldVars) {
            String factVarName = factName.replaceAll("\\.", "_") + suffix;
            if (!factVarName.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    private String importSchema(String originalLocation) {
        URL dirURL = this.m_prj.getBPELDirectoryURL();
        URL newURL = null;
        try {
            URL originalURL = URLFactory.newURL((String)originalLocation);
            newURL = originalURL == null ? URLFactory.newURL((URL)dirURL, (String)originalLocation) : (URLFileSystem.exists((URL)originalURL) ? originalURL : URLFactory.newURL((URL)dirURL, (String)("xsd//" + URLFileSystem.getFileName((URL)originalURL))));
            if (originalURL != null && !URLFileSystem.exists((URL)newURL)) {
                URLFileSystem.copy((URL)originalURL, (URL)newURL);
            }
            return newURL.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return originalLocation;
        }
    }

    private Variable createVariable(String name, XSDNode node, String schemaURL) {
        String varName = BPELModelUtil.generateUniqueScopeVariableName((Scope)this.m_processModel, (String)name);
        Variable var = null;
        try {
            var = RuleActivityDialog.createVariable(this.m_prj, this.m_processModel, (Scope)this.m_processModel, varName, node, schemaURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_varNames.add(name);
        return var;
    }

    @Override
    public Object getUserObject() {
        return this.m_ruleActivity;
    }

    @Override
    public void onCancel() {
        if (!this.m_bEditing) {
            this.cleanUp();
        }
    }

    @Override
    public void saveChanges() {
        this.updateRuleNode();
        if (!this.m_ruleFileSelected) {
            return;
        }
        String decisionPrefix = this.m_graphModel.getProcess().addNamespace(this.m_service.getTDecisionService().getTargetNamespace());
        String bpelPrefix = this.m_graphModel.getProcess().addNamespace("http://xmlns.oracle.com/bpel");
        if (!this.m_bEditing) {
            this.createHeaderAssign(decisionPrefix, bpelPrefix);
        }
        Assign assign = null;
        if (this.isInputFacts(this.m_pattern)) {
            assign = this.m_ruleActivity.getBPELToFactsAssign();
            if (this.m_inputModel != null) {
                assign.setCopyRules((List)this.m_inputModel.getData());
            }
        }
        if (this.isReturnFacts(this.m_pattern)) {
            assign = this.m_ruleActivity.getFactsToBPELAssign();
            if (this.m_outputModel != null) {
                assign.setCopyRules((List)this.m_outputModel.getData());
            }
        }
        if (!this.m_bEditing) {
            String patternName = this.m_pattern.getTPattern().getName().value();
            patternName = this.getServiceOpName(patternName);
            PartnerLink pl = null;
            try {
                pl = this.createPL(this.m_ServicesCombo.getSelectedItem() + ".wsdl");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String plName = pl.getName();
            Invoke invoke = this.m_ruleActivity.getInvoke();
            QName portType = new QName(this.m_service.getTDecisionService().getTargetNamespace(), "IDecisionService", decisionPrefix);
            invoke.setPartnerLink(plName);
            invoke.setPortType(portType);
            invoke.setOperation(patternName);
            Variable variable = null;
            variable = this.createVariable(this.m_processModel, (Activity)this.m_ruleActivity, pl, portType, patternName, plName, true);
            variable.setName("dsIn");
            this.m_ruleActivity.addVariable(variable);
            invoke.setInputVariable(variable.getName());
            if (this.m_assertVarList != null && this.m_assertVarList.size() > 0) {
                this.setAssertCopyList(variable.getName(), decisionPrefix, patternName);
            }
            if (this.m_watchVarList != null && this.m_watchVarList.size() > 0) {
                variable = this.createVariable(this.m_processModel, (Activity)this.m_ruleActivity, pl, portType, patternName, plName, false);
                variable.setName("dsOut");
                this.m_ruleActivity.addVariable(variable);
                invoke.setOutputVariable(variable.getName());
                this.setWatchCopyList(variable.getName(), decisionPrefix, patternName);
            }
            this.setupBpelVarsAndFactVarsCopy();
            final StatusGlassPane status = new StatusGlassPane((Component)((Object)this.m_graphPane));
            status.enableUserInput(false);
            status.setStatusMessage(BPELStringTranslator.getString("PLEASE_WAIT_MSG"), BPELStringTranslator.getString("BRL_UPDATING_SCA_PROJECT"));
            final PartnerLink partnerLink = pl;
            this.m_graphModel.buildPartnerLinkConnections();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RuleActivityDialog.this.updateComposite(partnerLink);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        status.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        }
        this.disableEditing();
    }

    private void disableEditing() {
        this.m_bEditing = true;
        this.m_DecsFilesCombo.setEnabled(false);
        this.m_ServicesCombo.setEnabled(false);
        this.m_operationsCombo.setEnabled(false);
        if (this.m_createServiceBtn != null) {
            this.m_createServiceBtn.setVisible(false);
        }
    }

    protected void updateComposite(PartnerLink pl) {
        DecsFile file = (DecsFile)this.m_DecsFilesCombo.getSelectedItem();
        boolean newReferenceCreated = this.createReference(pl);
        if (newReferenceCreated) {
            this.addWire(file.toString(), pl);
            this.setPLProperties(pl);
        }
    }

    private void addWire(String string, PartnerLink pl) {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(this.m_prj);
        c.addWire(this.m_prj.getProcessName(), pl.getName(), string, this.m_ServicesCombo.getSelectedItem().toString());
    }

    private void prepareRuleNode() {
        this.cleanUp();
        this.createSequenceNode();
        if (this.isInputFacts(this.m_pattern)) {
            this.createAssignNode("BPEL_Var_To_Rule_Facts");
            this.createAssignNode("Facts_To_Rule_Service");
        }
        this.createInvoke();
        if (this.isReturnFacts(this.m_pattern)) {
            this.createAssignNode("Rule_Service_To_Facts");
            this.createAssignNode("Facts_To_BPEL_Var");
        }
    }

    private boolean createReference(PartnerLink pl) {
        boolean newReferenceCreated = false;
        SCAController c = JDevSCAIntegrationUtil.getSCAController(this.m_prj);
        WsdlInfo wsdlInfo = null;
        try {
            wsdlInfo = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(this.m_prj, pl, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (c.isNameUniqueWithinComponent(this.m_prj.getProcessName(), pl.getName())) {
            c.addReference(this.m_prj.getProcessName(), pl.getName(), (InterfaceInfo)wsdlInfo);
            newReferenceCreated = true;
        }
        return newReferenceCreated;
    }

    private void setWatchCopyList(String dsOut, String decisionPrefix, String patternName) {
        Assign assign = this.m_ruleActivity.getServiceToFactsAssign();
        if (assign == null || this.m_watchVarList == null) {
            return;
        }
        List copyList = assign.getCopyRules();
        int c = copyList.size();
        for (int i = 0; i < this.m_watchVarList.size(); ++i) {
            Variable var = (Variable)this.m_watchVarList.get(i);
            if (this.isCopyCreated(var, assign.getCopyRules(), false)) continue;
            From from = (From)BPELParser.createImplementation(From.class);
            To to = (To)BPELParser.createImplementation(To.class);
            to.setVariable(var.getName());
            from.setVariable(dsOut);
            from.setPart("payload");
            QName qname = var.getElement();
            String prefix = qname.getPrefix();
            String elementName = qname.getLocalPart();
            prefix = this.m_processModel.getPrefixForNamespace(qname.getNamespaceURI());
            from.setQuery("/" + decisionPrefix + ":" + patternName + "Decision/" + decisionPrefix + ":" + "resultList" + "/" + prefix + ":" + elementName);
            Copy append = (Copy)BPELParser.createImplementation(Copy.class);
            append.createDOMElement(assign.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            append.setFrom(from);
            append.setTo(to);
            copyList.add(append);
        }
        if (copyList.size() > c) {
            assign.setCopyRules(copyList);
        }
    }

    public boolean isCopyCreated(Variable v, List copies, boolean isInput) {
        if (copies == null || v == null) {
            return false;
        }
        for (Object o : copies) {
            To t;
            From f;
            if (!(o instanceof Copy)) continue;
            Copy c = (Copy)o;
            if (!(isInput ? (f = c.getFrom()).getVariable().equals(v.getName()) : (t = c.getTo()).getVariable().equals(v.getName()))) continue;
            return true;
        }
        return false;
    }

    private void setAssertCopyList(String dsIn, String decisionPrefix, String patternName) {
        Assign assign;
        String inputList = "assertList";
        if (this.isFunction()) {
            inputList = "parameterList";
        }
        if ((assign = this.m_ruleActivity.getFactsToServiceAssign()) == null || this.m_assertVarList == null) {
            return;
        }
        List copyList = assign.getCopyRules();
        int c = copyList.size();
        for (int i = 0; i < this.m_assertVarList.size(); ++i) {
            Variable var = (Variable)this.m_assertVarList.get(i);
            if (this.isCopyCreated(var, assign.getCopyRules(), true)) continue;
            From from = (From)BPELParser.createImplementation(From.class);
            To to = (To)BPELParser.createImplementation(To.class);
            from.setVariable(var.getName());
            to.setVariable(dsIn);
            to.setPart("payload");
            QName qname = var.getElement();
            String prefix = qname.getPrefix();
            String elementName = qname.getLocalPart();
            prefix = this.m_processModel.getPrefixForNamespace(qname.getNamespaceURI());
            to.setQuery("/" + decisionPrefix + ":" + patternName + "/" + decisionPrefix + ":" + inputList + "/" + prefix + ":" + elementName);
            Copy append = (Copy)BPELParser.createImplementation(Copy.class);
            append.createDOMElement(assign.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            append.setFrom(from);
            append.setTo(to);
            copyList.add(append);
        }
        if (copyList.size() > c) {
            assign.setCopyRules(copyList);
        }
    }

    @Override
    public boolean validateEditorChanges() {
        String activityName = this.m_nameField.getText();
        String msg = null;
        if (this.m_ruleFileSelected) {
            int index;
            if (activityName == null || activityName.equals("") || !Helper.isValidNCName((String)activityName)) {
                msg = BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID");
            }
            if ((index = this.m_operationsCombo.getSelectedIndex()) < 0) {
                msg = BPELStringTranslator.getString("RULE_OPERATION_NOT_VALID");
            }
            if ((index = this.m_ServicesCombo.getSelectedIndex()) < 0) {
                msg = BPELStringTranslator.getString("RULE_SERVICE_NOT_VALID");
            }
            if (msg == null) {
                String svcname = this.m_ServicesCombo.getSelectedItem().toString();
                String wsdlName = svcname + ".wsdl";
                String pLinkWsdlLocation = URIUtil.escapeURIString((String)(this.getScaProject().getSCARoot() + wsdlName));
                Definition def = null;
                try {
                    def = WSDLUtil.parseWSDLDocument((String)pLinkWsdlLocation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (def == null) {
                    msg = "Decision service WSDL file:\n" + wsdlName + "\nis invalid or doesn't exist!";
                }
            }
        }
        if (msg != null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (String)msg, (String)MessageBundleUtil.getCommonString((String)"XXERROR"), (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }

    private String getServiceOpName(String patternName) {
        for (int i = 0; i < DecisionServiceConstants.PATTERN_NAMES.length; ++i) {
            if (!DecisionServiceConstants.PATTERN_NAMES[i].equals(patternName)) continue;
            return DecisionServiceConstants.SERVICE_OP_NAMES[i];
        }
        return patternName;
    }

    private void createHeaderAssign(String namespacePrefix, String bpelPrefix) {
        assert (!this.m_bEditing);
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        String patternName = this.m_pattern.getTPattern().getName().value();
        patternName = this.getServiceOpName(patternName);
        String oraPrefix = this.m_graphModel.getProcess().addNamespace("http://schemas.oracle.com/xpath/extension");
        hashTable.put("${root}", patternName);
        hashTable.put("${serviceName}", this.m_service.getTDecisionService().getName());
        hashTable.put("${decisionPrefix}", namespacePrefix);
        hashTable.put("${ora}", oraPrefix);
        hashTable.put("${bpelPrefix}", bpelPrefix);
        if (this.m_sequence == null) {
            return;
        }
        try {
            Element domElement = this.m_sequence.getDOMElement();
            Node node = PatternFragmentUtil.getPatternFragementNode("decideHeader", hashTable);
            Node newNode = domElement.getOwnerDocument().importNode(node, true);
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            Assign assign = (Assign)BPELParser.createImplementation(Assign.class);
            assign.setDOMElement(assign.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            assign.readFromElement((Element)newNode, this.m_processModel.createParserContext(), true);
            AssignNode headNode = new AssignNode();
            headNode.setUserObject(assign);
            headNode.setName(assign.getName());
            int index = this.m_sequenceNode.indexOf((oracle.tip.tools.ide.common.graph.model.Node)this.m_invokeNode);
            this.m_sequence.insertActivity(index - 1, (Activity)assign);
            List kids = this.m_sequenceNode.getChildren();
            oracle.tip.tools.ide.common.graph.model.Node[] nodes = new oracle.tip.tools.ide.common.graph.model.Node[kids.size()];
            kids.toArray(nodes);
            this.m_sequenceNode.removeAllChildNodes();
            for (int i = 0; i < nodes.length; ++i) {
                oracle.tip.tools.ide.common.graph.model.Node n = nodes[i];
                if (n == this.m_invokeNode) {
                    this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_sequenceNode, (oracle.tip.tools.ide.common.graph.model.Node)headNode);
                }
                this.m_graphModel.addChildNode((oracle.tip.tools.ide.common.graph.model.Node)this.m_sequenceNode, n);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createSCAComponent(String m_DecisionServiceFilename, String plName) {
        String m_name = null;
        m_name = m_DecisionServiceFilename;
        if (!m_DecisionServiceFilename.endsWith(".decs")) {
            m_DecisionServiceFilename = m_DecisionServiceFilename + ".decs";
        }
        try {
            this.createInboundComponent(this.m_prj, m_name, "decision", m_DecisionServiceFilename);
            JDevSCAIntegrationUtil.saveSCAComposite(this.m_prj, m_name);
        }
        catch (SCAException e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void createInboundComponent(BPELProject m_prj, String componentName, String componentType, String definitionInfo) throws SCAException {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(m_prj);
        if (JDevSCAIntegrationUtil.isNameUniqueWithinComposite(m_prj, componentName)) {
            try {
                c.createComponent(componentName, componentType, definitionInfo);
            }
            catch (SCAInvalidFileNameException e) {
                e.printStackTrace();
            }
        }
    }

    private PartnerLink createPL(String wsdlName) throws Exception {
        String pLinkWsdlLocation = URIUtil.escapeURIString((String)(this.getScaProject().getSCARoot() + wsdlName));
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        Process processModel = graphModel.getProcess();
        PartnerLinks pLinks = processModel.getPartnerLinks();
        if (pLinks == null) {
            pLinks = processModel.createPartnerLinks();
        }
        List partnerLinks = pLinks.getPartnerLinks();
        String svcname = this.m_ServicesCombo.getSelectedItem().toString();
        String decName = this.m_DecsFilesCombo.getSelectedItem().toString();
        String plinkName = decName + "." + svcname;
        Map links = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)WSDLUtil.parseWSDLDocument((String)pLinkWsdlLocation));
        if (links != null && links.size() == 0) {
            PartnerLinkWSDLUtil.addPLTypesIntoWSDL((String)pLinkWsdlLocation, null);
        }
        for (int count = 0; count < partnerLinks.size(); ++count) {
            PartnerLink partnerLink = (PartnerLink)partnerLinks.get(count);
            if (!partnerLink.getName().equals(plinkName)) continue;
            return partnerLink;
        }
        if (this.m_bEditing) {
            return this.editPartnerLink(wsdlName);
        }
        PartnerLink pLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        pLink.setName(plinkName);
        pLink.setProcessURL(this.m_prj.getBPELFileURL());
        pLink.setWSDLLocation(this.getScaProject().getSCARoot() + wsdlName);
        pLink.setInbound(false);
        pLink.setPortType("IDecisionService");
        pLink.setPartnerRole("IDecisionService_Role");
        String prefix = processModel.addNamespace(this.getNameSpace());
        QName qname = new QName(this.getNameSpace(), "IDecisionService_PL", prefix);
        pLink.setPartnerLinkType(qname);
        pLinks.addPartnerLink(pLink);
        this.m_partnerLinkNode = new PartnerLinkNode();
        this.m_partnerLinkNode.setUserObject(pLink);
        this.m_partnerLinkNode.setIcon(DecisionServiceConstants.PARTNERLINK_ICON);
        this.m_partnerLinkNode.setIconName("application/rules/decision_service_16x16.png");
        SwimLaneNode m_swimLaneNode = ((BPELGraphModel)this.m_graphPane.getModel()).getRightSwimLaneNode();
        this.m_graphPane.getModel().addChildNode((oracle.tip.tools.ide.common.graph.model.Node)m_swimLaneNode, (oracle.tip.tools.ide.common.graph.model.Node)this.m_partnerLinkNode);
        return pLink;
    }

    private String getNameSpace() {
        Service service = (Service)this.m_ServicesCombo.getSelectedItem();
        String m_nameSpace = service.m_service.getTargetNamespace();
        return m_nameSpace;
    }

    private PartnerLink editPartnerLink(String wsdlName) throws Exception {
        PartnerLink pLink = RulesUtil.getPL(this.m_graphPane, this.getName());
        pLink.setWSDLLocation(wsdlName);
        return pLink;
    }

    private void setPLProperties(PartnerLink pLink) {
        ArrayList<PLProperties> propertyList = pLink.getPropertyList();
        if (propertyList == null) {
            propertyList = new ArrayList<PLProperties>();
        }
        PLProperties prop = new PLProperties("DecisionService", this.getName(), null);
        propertyList.add(prop);
        prop = new PLProperties("wsdlRuntimeLocation", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/" + this.getName() + "?WSDL", null);
        propertyList.add(prop);
        prop = new PLProperties("decisionServiceDetails", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/public_html/" + "GetDecisionServiceInfo.jsp", null);
        propertyList.add(prop);
        propertyList.add(new PLProperties("optSoapShortcut", "False", null));
        pLink.setPropertyList(propertyList);
        DeploymentFile depFile = this.m_prj.getDeploymentFile();
        try {
            depFile.setPLProperties(pLink.getName(), propertyList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAssertPanels() {
        if (!this.m_bEditing) {
            this.m_inputModel = null;
            this.m_outputModel = null;
        }
        this.m_pattern = (Pattern)this.m_operationsCombo.getSelectedItem();
        this.prepareRuleNode();
        this.loadUI();
    }

    public static Variable createVariableUrl(BPELProject project, Process process, Scope parent, String name, XSDNode node, URL url) throws Exception {
        Variable var = (Variable)BPELParser.createImplementation(Variable.class);
        var.setName(name);
        String prefix = process.addNamespace(node.getTargetNS());
        var.setElement(new QName(node.getTargetNS(), node.getName(), prefix));
        if (url != null) {
            WSDLUtil.addImportToWSDL((BPELProject)project, (URL)url, (String)node.getTargetNS());
        }
        return var;
    }

    public static Variable createVariable(BPELProject project, Process process, Scope parent, String name, XSDNode node, String urlStr) throws Exception {
        if (urlStr != null) {
            return RuleActivityDialog.createVariableUrl(project, process, parent, name, node, new URL(urlStr));
        }
        return RuleActivityDialog.createVariableUrl(project, process, parent, name, node, null);
    }

    protected void addNewComponent(String businessRuleComponentName, boolean resetSession) {
        if (this.composite == null) {
            return;
        }
        List components = this.composite.getComponents();
        SCAComponent component = null;
        HashSet<SCAComponent> set = new HashSet<SCAComponent>();
        set.addAll(this.decisionComponents);
        boolean bDecFileExist = false;
        for (int i = 0; i < components.size(); ++i) {
            component = (SCAComponent)components.get(i);
            if (component.getImplementation().isDecisionImplementation()) {
                if (!set.contains(component)) {
                    this.decisionComponents.add(component);
                    break;
                }
                if (component.getName().equals(businessRuleComponentName)) {
                    bDecFileExist = true;
                    break;
                }
            }
            component = null;
        }
        if (component == null) {
            return;
        }
        this.m_service = null;
        SCAProject project = this.getScaProject();
        if (project == null) {
            return;
        }
        SCAImplementation impl = component.getImplementation();
        String path = project.getSCARoot().getFile() + impl.getSrcURI();
        File file = new File(path);
        DecsFile decsFile = new DecsFile(file);
        decsFile.setDiaplayName(component.getName());
        if (!bDecFileExist) {
            this.m_decsFilesVector.add(decsFile);
            this.m_DecsFilesCombo.setSelectedItem(decsFile);
        } else {
            this.m_DecsFilesCombo.setSelectedItem(decsFile);
        }
        if (!resetSession) {
            this.populatePatterns(this.m_service, "callFunctionStateful");
        }
    }

    public void setupBpelVarsAndFactVarsCopy() {
        this.copyVars2Vars(this.m_ruleActivity.getBPELToFactsAssign(), this.m_assertVarList, this.m_inputVars, true);
        this.copyVars2Vars(this.m_ruleActivity.getFactsToBPELAssign(), this.m_watchVarList, this.m_outputVars, false);
    }

    private void copyVars2Vars(Assign assign, List<Variable> ruleVars, List<Variable> bpelVars, boolean inBound) {
        if (assign == null || ruleVars == null || ruleVars.size() == 0 || bpelVars == null || bpelVars.size() == 0) {
            return;
        }
        for (int i = 0; i < bpelVars.size(); ++i) {
            Variable bpelVar = bpelVars.get(i);
            if (bpelVar.getMessageType() != null) {
                QName type = bpelVar.getMessageType();
                WSDLPartData[] parts = WSDLUtil.getMessagePartData((BPELProject)this.m_graphModel.getBPELProject(), (String)type.getLocalPart());
                for (int k = 0; k < parts.length; ++k) {
                    WSDLPartData part = parts[k];
                    QName partType = new QName(part.getTargetNamespace(), part.getPartType());
                    Variable ruleVar = this.findRuleVar(partType, ruleVars);
                    this.copyVar2Var(assign, ruleVar, part, bpelVar, inBound);
                }
                continue;
            }
            Variable ruleVar = this.findRuleVar(bpelVar.getElement(), ruleVars);
            this.copyVar2Var(assign, ruleVar, null, bpelVar, inBound);
        }
    }

    private Variable findRuleVar(QName type, List<Variable> vars) {
        Variable var = null;
        for (Variable v : vars) {
            if (!v.getElement().equals(type)) continue;
            return v;
        }
        return var;
    }

    private void copyVar2Var(Assign assign, Variable ruleVar, WSDLPartData part, Variable bpelVar, boolean inBound) {
        From from = (From)BPELParser.createImplementation(From.class);
        To to = (To)BPELParser.createImplementation(To.class);
        List copyList = assign.getCopyRules();
        if (inBound) {
            from.setVariable(bpelVar.getName());
            to.setVariable(ruleVar.getName());
            if (part != null) {
                from.setPart(part.getPartName());
            }
        } else {
            from.setVariable(ruleVar.getName());
            to.setVariable(bpelVar.getName());
            if (part != null) {
                to.setPart(part.getPartName());
            }
        }
        Copy append = (Copy)BPELParser.createImplementation(Copy.class);
        append.createDOMElement(assign.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        append.setFrom(from);
        append.setTo(to);
        copyList.add(append);
        assign.setCopyRules(copyList);
    }

    public SCAProject getScaProject() {
        JDevBPELProject p = (JDevBPELProject)this.m_prj;
        return (SCAProject)p.getSCAProject();
    }

    private class DecsFile {
        private File decsFile = null;
        private String displayName;

        public DecsFile(File file) {
            this.decsFile = file;
        }

        File getDecsFile() {
            return this.decsFile;
        }

        public void setDiaplayName(String name) {
            this.displayName = name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private class RuleAssignTablePanel
    extends CopyRuleTablePanel {
        CopyPageInputs m_input;

        public RuleAssignTablePanel(BaseTableModel tabModel, BPELGraphPane pane) {
            super(tabModel, pane, true);
        }

        public void setInput(CopyPageInputs in) {
            this.m_input = in;
        }

        public ToolBar getToolBar() {
            return this.m_toolBar;
        }

        @Override
        public void performAdd(int pageType) {
            if (RuleActivityDialog.this.m_service == null) {
                return;
            }
            CopyDialogEditPage page = CopyPageFactory.newCopyDialogEditPage(8, this.m_graphPane, this.m_input);
            page.loadControls();
            String title = BPELStringTranslator.getString("DLG_TITLE_FACT_MAP");
            page.setHelpTopicId("oracle.tip.tools.ide.pm.modules.rules.RuleActivityDialog.RuleAssignTablePanel.ExtGenCopyDialogEditPage.Create");
            CopyRuleDialog dlg = new CopyRuleDialog(GraphUtils.getFrame((Component)this), page, title);
            if (dlg.create() == 0) {
                Object rule = page.getCopyRule();
                CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
                model.insertRow(rule);
                model.refresh();
                this.setModified(true);
            }
        }

        @Override
        protected void doEdit(int row) {
            if (row == -1) {
                return;
            }
            CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
            Object obj = model.getRow(row);
            CopyPageInputs in = new CopyPageInputs(this.m_activity);
            CopyDialogEditPage page = CopyPageFactory.editCopyDialogEditPage(obj, this.m_graphPane, in);
            String title = CopyPageFactory.getEditPageTitle(obj, in);
            CopyRuleDialog dlg = new CopyRuleDialog(GraphUtils.getFrame((Component)this), page, title);
            page.loadControls();
            page.setHelpTopicId("oracle.tip.tools.ide.pm.modules.rules.RuleActivityDialog.RuleAssignTablePanel.ExtGenCopyDialogEditPage.Edit");
            if (dlg.edit() == 0) {
                Object rule = page.getCopyRule();
                model.setRow(rule, row);
                this.setModified(true);
            }
        }
    }

    private class Service {
        TDecisionService m_service;
        Services m_services;

        public Service(Services services, TDecisionService service) {
            this.m_service = service;
            this.m_services = services;
        }

        public String toString() {
            return this.m_service.getName();
        }

        public TDecisionService getTDecisionService() {
            return this.m_service;
        }

        public IRuleSet getRuleSet() throws Exception {
            return this.m_services.getRuleSet(this.m_service);
        }

        public List getAssertFacts(Pattern pattern) throws Exception {
            TPattern tPattern = pattern.getTPattern();
            TArgumentList tArgList = tPattern.getArguments();
            PatternName pName = PatternName.getPatternName(pattern);
            if (pName == PatternName.CALL_FUNCTION_STATELESS || pName == PatternName.CALL_FUNCTION_STATEFUL) {
                ArrayList<String> assertList = new ArrayList<String>();
                String functionName = tArgList.getCall();
                TFunction function = this.m_services.getFunction(this.m_service, functionName);
                if (function == null) {
                    return assertList;
                }
                List paramList = function.getParameters().getParameters();
                if (paramList == null) {
                    return assertList;
                }
                for (int i = 0; i < paramList.size(); ++i) {
                    TParameter param = (TParameter)paramList.get(i);
                    TParameterDirection direction = param.getDirection();
                    if (direction != TParameterDirection.IN && direction != TParameterDirection.INOUT) continue;
                    assertList.add(param.getType().getName());
                }
                return assertList;
            }
            return RuleEngineUtil.getAssertValues((List)tArgList.getAsserts());
        }

        public List getWatchFacts(Pattern pattern) throws Exception {
            TPattern tPattern = pattern.getTPattern();
            TArgumentList tArgList = tPattern.getArguments();
            PatternName pName = PatternName.getPatternName(pattern);
            if (pName != PatternName.CALL_FUNCTION_STATEFUL && pName != PatternName.CALL_FUNCTION_STATELESS) {
                return tArgList.getWatches();
            }
            String functionName = tArgList.getCall();
            TFunction function = this.m_services.getFunction(this.m_service, functionName);
            ArrayList<String> watchList = new ArrayList<String>();
            if (function == null) {
                return watchList;
            }
            List paramList = function.getParameters().getParameters();
            if (paramList == null) {
                return watchList;
            }
            for (int i = 0; i < paramList.size(); ++i) {
                TParameter param = (TParameter)paramList.get(i);
                TParameterDirection direction = param.getDirection();
                if (direction != TParameterDirection.OUT && direction != TParameterDirection.INOUT) continue;
                watchList.add(param.getType().getName());
            }
            return watchList;
        }
    }

    private class Services {
        DecisionServices m_decisionServices;
        List m_providerList = null;
        Hashtable m_engineHash = new Hashtable();
        private RuleEngineFactory m_ruleEngineFactory = RuleEngineFactory.getInstance();

        private TRuleEngineProvider getProvider(String engineName) {
            for (int i = 0; i < this.m_providerList.size(); ++i) {
                TRuleEngineProvider provider = (TRuleEngineProvider)this.m_providerList.get(i);
                if (!provider.getName().equals(engineName)) continue;
                return provider;
            }
            return null;
        }

        public Services(DecisionServices services) {
            this.m_decisionServices = services;
            this.m_providerList = this.m_decisionServices.getRuleEngineProviders();
        }

        private IRuleEngine getEngine(TDecisionService service) throws RuleProviderException {
            TRuleEngineProvider provider;
            IRuleEngine ruleEngine = (IRuleEngine)this.m_engineHash.get(service);
            if (ruleEngine == null && (ruleEngine = this.m_ruleEngineFactory.createRuleEngine(provider = this.getProvider(service.getRuleEngineProviderReference()))) != null) {
                if (ruleEngine instanceof OracleRuleEngine) {
                    URL url = URLFileSystem.getParent((URL)RuleActivityDialog.this.m_prj.getProjectURL());
                    String dictPath = ruleEngine.getProvider().getRepository().getPath();
                    URL dictURL = null;
                    try {
                        dictURL = URLFactory.newURL((String)dictPath);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (dictURL == null) {
                        dictURL = URLFactory.newURL((URL)RuleActivityDialog.this.m_prj.getProjectURL(), (String)dictPath.substring(dictPath.indexOf("/") + 1));
                        dictURL = URLFactory.newURL((String)URIUtil.escapeURIString((String)dictURL.toExternalForm()));
                    }
                    ((OracleRuleEngine)ruleEngine).setDictionaryURL(dictURL);
                }
                this.m_engineHash.put(service, ruleEngine);
            }
            return ruleEngine;
        }

        public IRuleSet getRuleSet(TDecisionService service) throws Exception {
            IRuleEngine engine = this.getEngine(service);
            RuleActivityDialog.this.m_catalog = service.getCatalogVersion() == null ? engine.getRuleCatalog(service.getCatalog()) : engine.getRuleCatalog(service.getCatalog(), service.getCatalogVersion());
            String ruleSetName = service.getRuleset();
            return RuleActivityDialog.this.m_catalog.getRuleSet(ruleSetName);
        }

        public TFunction getFunction(TDecisionService service, String funcName) throws Exception {
            IRuleEngine engine = this.getEngine(service);
            IRuleCatalog catalog = service.getCatalogVersion() == null ? engine.getRuleCatalog(service.getCatalog()) : engine.getRuleCatalog(service.getCatalog(), service.getCatalogVersion());
            IDataModel dataModel = catalog.getDataModel();
            return dataModel.getFunction(funcName);
        }

        public TDecisionService getService(String name) {
            List list = this.m_decisionServices.getDecisionServices();
            for (int i = 0; i < list.size(); ++i) {
                TDecisionService service = (TDecisionService)list.get(i);
                if (!service.getName().equals(name)) continue;
                return service;
            }
            return null;
        }
    }
}

