/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.rules;

import java.util.Vector;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.modules.rules.Pattern;

public class PatternName {
    String m_xmlName;
    String m_resource;
    String m_display;
    private static Vector s_patternNames;
    public static PatternName ASSERT;
    public static PatternName ASSERT_EXECUTE;
    public static PatternName ASSERT_EXECUTE_WATCH_STATEFUL;
    public static PatternName ASSERT_EXECUTE_WATCH_STATELESS;
    public static PatternName CALL_FUNCTION_STATELESS;
    public static PatternName WATCH;
    public static PatternName CALL_FUNCTION_STATEFUL;
    public static PatternName ASSERT_EXECUTE_WATCH_STATEFUL2;

    private PatternName(String xmlName, String resource) {
        this.m_xmlName = xmlName;
        this.m_resource = resource;
        this.m_display = MessageBundleUtil.getCommonString((String)this.m_resource);
    }

    public static PatternName getPatternName(Pattern pattern) {
        return PatternName.getPatternName(pattern.getTPattern());
    }

    public static PatternName getPatternName(TPattern tPattern) {
        return PatternName.getPatternName(tPattern.getName().value());
    }

    public static Vector getPatternNames() {
        Vector<PatternName> patternNames = new Vector<PatternName>();
        patternNames.add(ASSERT_EXECUTE_WATCH_STATEFUL);
        patternNames.add(CALL_FUNCTION_STATEFUL);
        return patternNames;
    }

    public String getXMLName() {
        return this.m_xmlName;
    }

    public static PatternName getPatternName(String str) {
        if (s_patternNames == null) {
            s_patternNames = new Vector();
            s_patternNames.add(ASSERT);
            s_patternNames.add(WATCH);
            s_patternNames.add(ASSERT_EXECUTE);
            s_patternNames.add(ASSERT_EXECUTE_WATCH_STATEFUL2);
            s_patternNames.add(ASSERT_EXECUTE_WATCH_STATELESS);
            s_patternNames.add(CALL_FUNCTION_STATEFUL);
            s_patternNames.add(CALL_FUNCTION_STATELESS);
        }
        for (int i = 0; i < s_patternNames.size(); ++i) {
            PatternName pName = (PatternName)s_patternNames.get(i);
            if (!pName.getXMLName().equals(str)) continue;
            return pName;
        }
        return null;
    }

    public String toString() {
        return this.m_display;
    }

    static {
        ASSERT = new PatternName(TDecisionServicePatternName.ASSERT.value(), "COMBO_ITEM_PATTERN_ASSERT");
        ASSERT_EXECUTE = new PatternName(TDecisionServicePatternName.ASSERT_EXECUTE.value(), "COMBO_ITEM_PATTERN_EXEC");
        ASSERT_EXECUTE_WATCH_STATEFUL = new PatternName(TDecisionServicePatternName.ASSERT_EXECUTE_WATCH_STATEFUL.value(), "COMBO_ITEM_PATTERN_RESULT");
        ASSERT_EXECUTE_WATCH_STATELESS = new PatternName(TDecisionServicePatternName.ASSERT_EXECUTE_WATCH_STATELESS.value(), "COMBO_ITEM_PATTERN_RESET");
        CALL_FUNCTION_STATELESS = new PatternName(TDecisionServicePatternName.CALL_FUNCTION_STATELESS.value(), "COMBO_ITEM_PATTERN_FUNC");
        WATCH = new PatternName(TDecisionServicePatternName.WATCH.value(), "COMBO_ITEM_PATTERN_WATCH");
        CALL_FUNCTION_STATEFUL = new PatternName(TDecisionServicePatternName.CALL_FUNCTION_STATEFUL.value(), "COMBO_ITEM_PATTERN_FUNC_STATEFUL");
        ASSERT_EXECUTE_WATCH_STATEFUL2 = new PatternName(TDecisionServicePatternName.ASSERT_EXECUTE_WATCH_STATEFUL.value(), "COMBO_ITEM_PATTERN_RESULT2");
    }
}

