/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.modules.patterns.Pattern;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternManager {
    static Hashtable patterns = new Hashtable();
    static XMLDocument patternDoc;
    static Hashtable images;
    private static ArrayList s_fileList;
    private static Hashtable s_patterns;
    private static final String s_patternsFile = "c:\\work\\patterns\\patterns.xml";

    public static void loadPatterns(String patternsDir) {
        if (s_fileList.size() > 0) {
            return;
        }
        PatternManager.getFileList(patternsDir);
        for (int i = 0; i < s_fileList.size(); ++i) {
            Pattern pattern = new Pattern((String)s_fileList.get(i));
            s_patterns.put(pattern.getUniqName(), pattern);
        }
    }

    private static void getFileList(String dir) {
        if (dir == null || dir.equals("")) {
            return;
        }
        File dirFile = new File(dir);
        String[] fileList = dirFile.list();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File file = new File(dir, fileList[i]);
            if (file.isDirectory()) {
                PatternManager.getFileList(file.getPath());
                continue;
            }
            if (!fileList[i].equalsIgnoreCase("pattern.xml")) continue;
            s_fileList.add(dirFile.getPath() + File.separator + fileList[i]);
        }
    }

    private static FileInputStream createInitialFile(File file) {
        XMLDocument doc = new XMLDocument();
        try {
            doc.setVersion("1.0");
            doc.setEncoding("UTF-8");
            Element patternsElement = doc.createElement("patterns");
            doc.appendChild((Node)patternsElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PatternManager.save(doc, file);
        try {
            return new FileInputStream(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(XMLDocument doc, File file) {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            XMLPrintDriver driver = new XMLPrintDriver((OutputStream)outStream);
            driver.setFormatPrettyPrint(true);
            driver.setEOLChars(System.getProperty("line.separator"));
            driver.setEncoding("UTF-8");
            driver.printDocument(doc);
        }
        catch (Exception ex) {
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void add(String patternName, Scope scope, GraphPane graph, String image) {
        Document doc = scope.getDOMElement().getOwnerDocument();
        Element elem = scope.getDOMElement();
        Node node = doc.importNode(elem, true);
        patterns.put(patternName, node);
        images.put(patternName, image);
        PatternManager.save(graph);
    }

    private static void save(GraphPane graph) {
        URL url = ((BPELGraphPane)graph).getBPELProject().getProjectURL();
        XMLDocument doc = new XMLDocument();
        try {
            URL fileUrl = new URL(url, "patterns.xml");
            doc.setVersion("1.0");
            doc.setEncoding("UTF-8");
            Element patternsElement = doc.createElement("patterns");
            doc.appendChild((Node)patternsElement);
            Element docElem = doc.getDocumentElement();
            Enumeration e = patterns.keys();
            while (e.hasMoreElements()) {
                String patternName = (String)e.nextElement();
                Node scopeNode = (Node)patterns.get(patternName);
                Element patternElem = doc.createElement("pattern");
                patternElem.setAttribute("name", patternName);
                patternElem.setAttribute("image", (String)images.get(patternName));
                Node newNode = doc.importNode(scopeNode, true);
                patternElem.appendChild(newNode);
                docElem.appendChild(patternElem);
            }
            GraphicsFileUtil.save((Document)doc, fileUrl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Node get(String patternName) {
        return (Node)patterns.get(patternName);
    }

    public static boolean isPatternPage(String pageName) {
        Enumeration e = s_patterns.elements();
        if (e != null && e.hasMoreElements()) {
            Pattern pattern = (Pattern)e.nextElement();
            return pageName.equals(pattern.getPageName());
        }
        return false;
    }

    private static void init(String patternsFileName) {
        List patternsFileList = PatternManager.readPatternsFile(patternsFileName);
        if (patternsFileList != null) {
            for (int i = 0; i < patternsFileList.size(); ++i) {
                Pattern pattern = new Pattern((String)patternsFileList.get(i));
                s_patterns.put(pattern.getUniqName(), pattern);
            }
        }
    }

    public static Pattern getPattern(String patternName) {
        return (Pattern)s_patterns.get(patternName);
    }

    private static List readPatternsFile(String patternsFileName) {
        File file = new File(s_patternsFile);
        ArrayList<String> patternList = new ArrayList<String>();
        try {
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)new FileInputStream(file));
            XMLDocument doc = parser.getDocument();
            Iterator patternsIterator = XMLHelper.getChildElementIterator((Element)doc.getDocumentElement());
            while (patternsIterator.hasNext()) {
                Element patternFileElem = (Element)patternsIterator.next();
                String patternFileName = patternFileElem.getFirstChild().getNodeValue();
                patternList.add(patternFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return patternList;
    }

    public static void dumpNode(Node node) {
        XMLDocument doc = new XMLDocument();
        try {
            URL url = new URL("file:///c:/temp/");
            URL fileUrl = new URL(url, "patterns_debug.xml");
            doc.setVersion("1.0");
            doc.setEncoding("UTF-8");
            Element patternsElement = doc.createElement("patterns");
            doc.appendChild((Node)patternsElement);
            Element docElem = doc.getDocumentElement();
            Element patternElem = doc.createElement("pattern");
            patternElem.setAttribute("name", "junk");
            patternElem.setAttribute("image", "junk image");
            Node newNode = doc.importNode(node, true);
            patternElem.appendChild(newNode);
            docElem.appendChild(patternElem);
            GraphicsFileUtil.save((Document)doc, fileUrl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        images = new Hashtable();
        s_fileList = new ArrayList();
        s_patterns = new Hashtable();
    }
}

