/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.patterns;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternFragmentUtil {
    private static boolean m_bInit;
    private static final char[] m_bLock;
    private static final String CHAR_ENC = "UTF-8";
    private static final String PATTERN_FILE_NAME = "pattern.xml";
    private static final String FRAGMENT_TAG_NAME = "fragment";
    private static final String[] dirArray;
    private static final Map m_fragmentMap;

    private PatternFragmentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Node getPatternFragementNode(String patternName, Map args) throws Exception {
        Node retNode;
        if (!m_bInit) {
            char[] cArray = m_bLock;
            // MONITORENTER : m_bLock
            PatternFragmentUtil.loadPatterns(PatternFragmentUtil.getPatternDirectory());
            m_bInit = true;
            // MONITOREXIT : cArray
        }
        if ((retNode = (Node)m_fragmentMap.get(patternName)) == null) return retNode;
        if (args == null) return retNode;
        if (args.size() <= 0) return retNode;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLPrintDriver driver = new XMLPrintDriver((OutputStream)out);
        driver.setEncoding(CHAR_ENC);
        if (!(retNode instanceof XMLElement)) {
            throw new Exception("Fragement has to be an XML element.");
        }
        driver.setFormatPrettyPrint(true);
        driver.printElement((XMLElement)retNode);
        Iterator it = args.keySet().iterator();
        String retStr = out.toString(CHAR_ENC);
        block2: while (true) {
            if (!it.hasNext()) {
                ByteArrayInputStream in = new ByteArrayInputStream(retStr.getBytes(CHAR_ENC));
                DOMParser parser = new DOMParser();
                parser.setPreserveWhitespace(false);
                parser.parse((InputStream)in);
                return parser.getDocument().getDocumentElement();
            }
            String key = (String)it.next();
            String val = (String)args.get(key);
            int index = retStr.indexOf(key);
            while (true) {
                if (index == -1) continue block2;
                retStr = retStr.substring(0, index) + val + retStr.substring(index + key.length(), retStr.length());
                index = retStr.indexOf(key);
            }
            break;
        }
    }

    private static void loadPatterns(String dir) throws Exception {
        ArrayList fileList = new ArrayList();
        PatternFragmentUtil.getFileList(dir, fileList);
        DOMParser parser = new DOMParser();
        for (int i = 0; i < fileList.size(); ++i) {
            URL url = (URL)fileList.get(i);
            parser.parse(url);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            NodeList nl = docElem.getChildNodes();
            String patternName = docElem.getAttribute("name");
            if (nl.getLength() <= 0) continue;
            Node fragment = null;
            for (int j = 0; j < nl.getLength() && fragment == null; ++j) {
                Node n = nl.item(j);
                String nodeName = n.getNodeName();
                if (n.getNodeType() != 1 || nodeName == null || !FRAGMENT_TAG_NAME.equals(nodeName)) continue;
                fragment = n;
            }
            if (fragment == null) continue;
            nl = fragment.getChildNodes();
            boolean bCont = true;
            for (int k = 0; k < nl.getLength() && bCont; ++k) {
                Node n = nl.item(k);
                if (n.getNodeType() != 1) continue;
                m_fragmentMap.put(patternName, n);
                bCont = false;
            }
        }
    }

    private static void getFileList(String dir, List fileList) throws Exception {
        if (dir == null || dir.equals("")) {
            return;
        }
        File dirFile = new File(dir);
        String[] fl = dirFile.list();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fl.length; ++i) {
            File file = new File(dir, fl[i]);
            if (file.isDirectory()) {
                PatternFragmentUtil.getFileList(file.getPath(), fileList);
                continue;
            }
            if (!fl[i].equalsIgnoreCase(PATTERN_FILE_NAME)) continue;
            fileList.add(new File(dirFile.getPath(), fl[i]).toURL());
        }
    }

    private static String getPatternDirectory() {
        File file = new File(Ide.getHomeDirectory());
        file = file.getParentFile();
        for (int i = 0; i < dirArray.length; ++i) {
            file = new File(file, dirArray[i]);
        }
        return file.getAbsolutePath();
    }

    static {
        m_bLock = new char[0];
        dirArray = new String[]{"integration", "bpm", "pattern"};
        m_fragmentMap = new HashMap();
    }
}

