/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteUI;
import oracle.tip.tools.ide.pm.addin.jdeveloper.PMPaletteContext;
import oracle.tip.tools.ide.pm.modules.patterns.PatternUIElement;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Pattern {
    private String m_name;
    private String m_palettePage;
    private String m_graphName;
    private static final String SEPARATOR = ".";
    private static final String VISUAL_NODE = "/typedef/visual";
    private static final String NAME_ATTR = "name";
    private static final String SRC_ATTR = "src";
    private static final String PALETTE_ITEM_NODE = "/typedef/palette-item";
    private static final String ICON_ATTR = "icon";
    private static final String LABEL_ATTR = "label";
    private static final String PALETTE_NAME_ATTR = "paletteName";
    private static final String ROOT_NODE = "/typedef";
    private static final String GRAPH_NAME_ATTR = "/typedef[@name]";
    private static final String SCOPE_NODE = "/typedef/fragment/xxx:scope";
    private static final String FIELD_NODES = "/typedef/fields/field";
    private Node m_scopeNode;
    private ArrayList m_fieldList = new ArrayList();
    URL m_patternURL;
    private String m_pageName;
    int count = 1;
    private static final String URI = "http://schemas.xmlsoap.org/ws/2003/03/business-process/";

    public Pattern(String patternFile) {
        this.load(patternFile);
    }

    private void load(String patternFile) {
        File file = new File(patternFile);
        try {
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)new FileInputStream(file));
            XMLDocument doc = parser.getDocument();
            Node paletteItemNode = doc.selectSingleNode(PALETTE_ITEM_NODE);
            String imageLoc = ((XMLElement)paletteItemNode).getAttribute(ICON_ATTR);
            String label = ((XMLElement)paletteItemNode).getAttribute(LABEL_ATTR);
            String imageFileName = file.getParent() + File.separator + imageLoc;
            this.m_pageName = ((XMLElement)paletteItemNode).getAttribute(PALETTE_NAME_ATTR);
            if (this.m_pageName == null || this.m_pageName.equals("")) {
                this.m_pageName = "http://xmlns.oracle.com/processmodel";
            }
            PaletteManager paletteManager = PaletteManager.getPaletteManager();
            Palette palette = paletteManager.getPalette();
            PalettePage palettePage = paletteManager.getPage(this.m_pageName);
            if (palettePage == null) {
                palette.addPage(this.m_pageName, "Test", "Test", false, true, false);
            }
            palettePage = paletteManager.getPage(this.m_pageName);
            palettePage.setPaletteContext(PMPaletteContext.class.getName());
            Node scopeNode = doc.selectSingleNode(SCOPE_NODE, (NSResolver)new MyNSResolver());
            String info = ((XMLElement)scopeNode).getAttributeNS("http://schemas.oracle.com/bpel/extension/partnerlink", "pattern");
            palettePage.addPaletteItem(imageFileName, info, false, "this is a test", label, "http://xmlns.oracle.com/processmodel", null, null);
            paletteManager.showPalettePage(this.m_pageName);
            PaletteUI paletteUI = (PaletteUI)PaletteManager.getPaletteManager().getPaletteWindow().getGUI();
            paletteUI.refreshCombo();
            XMLDocument dummyDoc = new XMLDocument();
            this.m_scopeNode = dummyDoc.importNode(scopeNode, true);
            this.m_name = info;
            this.m_graphName = ((XMLElement)doc.selectSingleNode(ROOT_NODE)).getAttribute(NAME_ATTR);
            this.m_patternURL = file.toURL();
            NodeList fieldNodes = doc.selectNodes(FIELD_NODES);
            if (fieldNodes != null) {
                for (int i = 0; i < fieldNodes.getLength(); ++i) {
                    XMLElement fieldElem = (XMLElement)fieldNodes.item(i);
                    PatternUIElement uiElement = new PatternUIElement();
                    uiElement.setLabel(fieldElem.getAttribute("displayName"));
                    uiElement.setXPath(fieldElem.getAttribute("mapping"));
                    this.m_fieldList.add(uiElement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPageName() {
        return this.m_pageName;
    }

    public String getGraphName() {
        return this.m_graphName + this.count++;
    }

    public URL getPatternURL() {
        return this.m_patternURL;
    }

    public String getUniqName() {
        return this.m_name;
    }

    public List getFields() {
        return this.m_fieldList;
    }

    public Node getScopeNode() {
        return this.m_scopeNode;
    }

    static class MyNSResolver
    implements NSResolver {
        MyNSResolver() {
        }

        public String resolveNamespacePrefix(String pref) {
            if (pref.equals("xxx")) {
                return Pattern.URI;
            }
            return null;
        }
    }
}

