/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.notification.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.BPELBaseType;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.modules.notification.NotificationWizardContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NotificationsUtil {
    public static String getObjectValue(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Element) {
            Element elt = (Element)obj;
            NodeList nl = elt.getChildNodes();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < nl.getLength(); ++i) {
                String nodeValue;
                Node n = nl.item(i);
                if (n.getNodeType() == 3) {
                    nodeValue = n.getNodeValue();
                    buf.append(nodeValue);
                    continue;
                }
                if (n.getNodeType() != 4) continue;
                nodeValue = n.getNodeValue();
                buf.append(nodeValue);
            }
            return buf.toString();
        }
        return obj.toString();
    }

    public static Copy createCopy(String fromExpression, String toVarPart, String toVarQuery, Document doc, Assign assign) {
        From fromModel = (From)BPELParser.createImplementation(From.class);
        fromModel.setDOMElement(fromModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        To toModel = (To)BPELParser.createImplementation(To.class);
        toModel.setDOMElement(toModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        ParserContext parserContext = ((BPELBaseType)assign).getParserContext();
        ((BPELBaseType)copy).setParserContext(parserContext);
        copy.setDOMElement(copy.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        fromModel.setExpression(fromExpression);
        toModel.setVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        toModel.setPart(toVarPart);
        toModel.setQuery(toVarQuery);
        ((BPELBaseType)toModel).setParserContext(parserContext);
        ((BPELBaseType)fromModel).setParserContext(parserContext);
        copy.setFrom(fromModel);
        copy.setTo(toModel);
        return copy;
    }

    public static void createOrReplaceCopy(String fromExpression, String toVarPart, String toVarQuery, Document doc, Assign assign) {
        boolean m_edit = false;
        int pos = -1;
        From fromModel = (From)BPELParser.createImplementation(From.class);
        fromModel.setDOMElement(fromModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        To toModel = (To)BPELParser.createImplementation(To.class);
        toModel.setDOMElement(toModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        List _copyRules = assign.getCopyRules();
        ArrayList<Copy> copyRules = new ArrayList<Copy>();
        copyRules.addAll(_copyRules);
        for (Object obj : _copyRules) {
            String expression;
            Copy cpy;
            if (!(obj instanceof Copy) || (cpy = (Copy)obj).getTo() == null || cpy.getTo().getQuery() == null || !(expression = cpy.getTo().getQuery()).equalsIgnoreCase(toVarQuery)) continue;
            m_edit = true;
            pos = _copyRules.indexOf(cpy);
            break;
        }
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        ParserContext parserContext = ((BPELBaseType)assign).getParserContext();
        ((BPELBaseType)copy).setParserContext(parserContext);
        copy.setDOMElement(copy.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        fromModel.setExpression(fromExpression);
        toModel.setVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        toModel.setPart(toVarPart);
        toModel.setQuery(toVarQuery);
        ((BPELBaseType)toModel).setParserContext(parserContext);
        ((BPELBaseType)fromModel).setParserContext(parserContext);
        copy.setFrom(fromModel);
        copy.setTo(toModel);
        if (!m_edit) {
            copyRules.add(copy);
        } else {
            copyRules.set(pos, copy);
        }
        assign.setCopyRules(new ArrayList());
        assign.setCopyRules(copyRules);
    }

    public static Copy createLiteralCopy(String fromExpression, String toVarPart, String toVarQuery, Document doc, Assign assign) {
        From fromModel = (From)BPELParser.createImplementation(From.class);
        fromModel.setDOMElement(fromModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        To toModel = (To)BPELParser.createImplementation(To.class);
        toModel.setDOMElement(toModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        ParserContext parserContext = ((BPELBaseType)assign).getParserContext();
        ((BPELBaseType)copy).setParserContext(parserContext);
        copy.setDOMElement(copy.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        fromModel.setLiteral(fromExpression);
        toModel.setVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        toModel.setPart(toVarPart);
        toModel.setQuery(toVarQuery);
        ((BPELBaseType)toModel).setParserContext(parserContext);
        ((BPELBaseType)fromModel).setParserContext(parserContext);
        copy.setFrom(fromModel);
        copy.setTo(toModel);
        return copy;
    }

    public static String getNamespacePrefix(oracle.tip.tools.ide.common.bpelparser.iface.Process process) {
        String prefix = process.getPrefixForNamespace(NotificationWizardContext.NS_NAMESHPACE);
        if (prefix == null) {
            prefix = process.addNamespace(NotificationWizardContext.NS_NAMESHPACE);
        }
        return prefix;
    }

    public static PartnerLinkNode findPartnerLinkNode(String linkName, BPELGraphPane pane) {
        SwimLaneView swimLaneView = pane.getLeftSwimLaneView();
        SwimLaneNode leftSwimLaneNode = (SwimLaneNode)swimLaneView.getNode();
        for (Object o : leftSwimLaneNode.getChildren()) {
            PartnerLinkNode partnerLinkNode;
            PartnerLink modelLink;
            if (!(o instanceof PartnerLinkNode) || !(modelLink = (PartnerLink)(partnerLinkNode = (PartnerLinkNode)((Object)o)).getUserObject()).getName().equals(linkName)) continue;
            return partnerLinkNode;
        }
        swimLaneView = pane.getRightSwimLaneView();
        SwimLaneNode rightSwimLaneNode = (SwimLaneNode)swimLaneView.getNode();
        for (Object o : rightSwimLaneNode.getChildren()) {
            PartnerLinkNode partnerLinkNode;
            PartnerLink modelLink;
            if (!(o instanceof PartnerLinkNode) || !(modelLink = (PartnerLink)(partnerLinkNode = (PartnerLinkNode)((Object)o)).getUserObject()).getName().equals(linkName)) continue;
            return partnerLinkNode;
        }
        return null;
    }

    public static NamespaceResolver getNSResolver(Activity activity, GraphPane pane) {
        BpelNSResolver nsResolver = new BpelNSResolver(((BPELGraphModel)pane.getModel()).getProcess());
        Map map = ((BPELGraphModel)pane.getModel()).getProcess().getNamespaceAliases();
        Object[] values = map.keySet().toArray();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                nsResolver.addNSEntry((String)values[i], (String)map.get(values[i]));
            }
        }
        for (Activity curAct = activity; curAct != null && !(curAct instanceof Process); curAct = curAct.getParentActivity()) {
            Map attrMap;
            if (!(curAct instanceof Activity) || (attrMap = curAct.getAttributesMap()) == null) continue;
            for (String attName : attrMap.keySet()) {
                String prefix;
                if (!attName.startsWith("xmlns:") || (prefix = attName.substring(6, attName.length())).equals("")) continue;
                nsResolver.addNSEntry(prefix, (String)attrMap.get(attName));
            }
        }
        return nsResolver;
    }

    public static void copy(InputStream inputFile, File outputFile) {
        try {
            int c;
            FileWriter out = new FileWriter(outputFile);
            while ((c = inputFile.read()) != -1) {
                out.write(c);
            }
            inputFile.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e.getStackTrace());
        }
    }

    public static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }
}

